/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.impl.security.authorization;

import java.security.Principal;
import javax.security.auth.Subject;
import javax.xml.rpc.handler.MessageContext;
import org.globus.gsi.jaas.GlobusPrincipal;
import org.globus.ogsa.ServiceProperties;
import org.globus.ogsa.impl.security.authorization.Authorization;
import org.globus.ogsa.impl.security.authorization.AuthorizationException;
import org.globus.ogsa.impl.security.authorization.BasicSubjectAuthorization;
import org.globus.ogsa.impl.security.authorization.ServiceAuthorization;
import org.globus.ogsa.impl.security.util.AuthUtil;

public class IdentityAuthorization
extends BasicSubjectAuthorization
implements Authorization,
ServiceAuthorization {
    protected Subject subject;

    protected IdentityAuthorization() {
    }

    public IdentityAuthorization(Subject subject) {
        this.subject = subject;
    }

    public IdentityAuthorization(String globusIdentity) {
        this.subject = new Subject();
        this.subject.getPrincipals().add((Principal)new GlobusPrincipal(globusIdentity));
    }

    public String getIdentity() {
        return AuthUtil.getIdentity(this.subject);
    }

    public void authorize(Subject peerSubject, ServiceProperties service, MessageContext context) throws AuthorizationException {
        this.authorize(this.subject, peerSubject, context);
    }

    public void authorize(Subject peerSubject, MessageContext context) throws AuthorizationException {
        this.authorize(this.subject, peerSubject, context);
    }
}

