/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.impl.security.descriptor;

import javax.xml.rpc.handler.MessageContext;
import org.globus.ogsa.impl.security.Constants;
import org.globus.ogsa.impl.security.descriptor.AuthMethod;
import org.globus.util.I18n;

public class GSIAuthMethod
implements AuthMethod {
    private static I18n i18n = I18n.getI18n((String)"org.globus.ogsa.impl.security.descriptor.errors");
    static final int BOTH_TYPE = 0;
    static final int INTEGRITY_TYPE = 1;
    static final int PRIVACY_TYPE = 2;
    private int type;
    public static final GSIAuthMethod BOTH = new GSIAuthMethod(0);
    public static final GSIAuthMethod PRIVACY = new GSIAuthMethod(2);
    public static final GSIAuthMethod INTEGRITY = new GSIAuthMethod(1);

    GSIAuthMethod(int type) {
        this.type = type;
    }

    public boolean isAuthenticated(MessageContext ctx) {
        switch (this.type) {
            case 0: {
                return ctx.getProperty("org.globus.security.context") != null;
            }
            case 1: {
                return Constants.SIGNATURE.equals(ctx.getProperty("org.globus.security.msg.type"));
            }
            case 2: {
                return Constants.ENCRYPTION.equals(ctx.getProperty("org.globus.security.msg.type"));
            }
        }
        return false;
    }

    public String getName() {
        switch (this.type) {
            case 0: {
                return i18n.getMessage("gsiMethod");
            }
            case 1: {
                return i18n.getMessage("gsiMethodSig");
            }
            case 2: {
                return i18n.getMessage("gsiMethodEnc");
            }
        }
        return "GSI secure conversation";
    }
}

