/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.impl.security.descriptor;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.security.auth.Subject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.gsi.GlobusCredential;
import org.globus.gsi.GlobusCredentialException;
import org.globus.gsi.jaas.JaasGssUtil;
import org.globus.ogsa.GridServiceException;
import org.globus.ogsa.ServiceProperties;
import org.globus.ogsa.config.ConfigException;
import org.globus.ogsa.impl.security.authentication.SecureServicePropertiesHelper;
import org.globus.ogsa.impl.security.descriptor.ContainerSecurityConfig;
import org.globus.ogsa.impl.security.descriptor.SecurityDescriptor;
import org.globus.ogsa.impl.security.descriptor.util.ElementParserException;
import org.globus.ogsa.utils.XmlFactory;
import org.globus.security.gridmap.GridMap;
import org.globus.util.I18n;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.w3c.dom.Document;

public class SecurityConfig {
    private static Log logger = LogFactory.getLog((String)(class$org$globus$ogsa$impl$security$descriptor$SecurityConfig == null ? (class$org$globus$ogsa$impl$security$descriptor$SecurityConfig = SecurityConfig.class$("org.globus.ogsa.impl.security.descriptor.SecurityConfig")) : class$org$globus$ogsa$impl$security$descriptor$SecurityConfig).getName());
    private static I18n i18n = I18n.getI18n((String)"org.globus.ogsa.impl.security.descriptor.errors", (ClassLoader)(class$org$globus$ogsa$impl$security$descriptor$SecurityConfig == null ? (class$org$globus$ogsa$impl$security$descriptor$SecurityConfig = SecurityConfig.class$("org.globus.ogsa.impl.security.descriptor.SecurityConfig")) : class$org$globus$ogsa$impl$security$descriptor$SecurityConfig).getClassLoader());
    public static final String TRUSTED_CERTS = "trustedCertificates";
    public static final String SECURITY_DESCRIPTOR = "securityConfig";
    public static final String SERVICE_KEY = "serviceKey";
    public static final String SERVICE_CERT = "serviceCert";
    public static final String SERVICE_PROXY = "serviceProxy";
    private static final String INITIALIZED = "serviceInitialized";
    private static final String LAST_MODIFIED = "serviceCredLastModified";
    protected ServiceProperties serviceProps;
    static /* synthetic */ Class class$org$globus$ogsa$impl$security$descriptor$SecurityConfig;

    public SecurityConfig(ServiceProperties props) {
        this.serviceProps = props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize(ServiceProperties props) throws ConfigException {
        if (props == null) {
            return;
        }
        ServiceProperties serviceProperties = props;
        synchronized (serviceProperties) {
            if (SecurityConfig.isInitialized(props)) {
                return;
            }
            SecurityConfig config = new SecurityConfig(props);
            config.initialize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() throws ConfigException {
        ServiceProperties serviceProperties = this.serviceProps;
        synchronized (serviceProperties) {
            this.initGridMap();
            this.initCredentials();
            this.initSecurityDescriptor();
            this.serviceProps.setProperty(INITIALIZED, Boolean.TRUE);
        }
    }

    public static boolean isInitialized(ServiceProperties props) {
        return props.getProperty(INITIALIZED) != null;
    }

    private String getProperty(String name) {
        return (String)this.serviceProps.getProperty(name);
    }

    protected void initGridMap() throws ConfigException {
        String gridMapFile = this.getProperty("gridmap");
        if (gridMapFile == null) {
            gridMapFile = ContainerSecurityConfig.getConfig().getGridMapFile();
        }
        if (gridMapFile != null) {
            logger.debug((Object)("Loading gridmap file: " + gridMapFile));
            GridMap gridMap = new GridMap();
            try {
                gridMap.load(gridMapFile);
            }
            catch (IOException e) {
                throw new ConfigException(e);
            }
            SecureServicePropertiesHelper.setGridMap(this.serviceProps, gridMap);
        } else {
            logger.debug((Object)"No gridmap file specified.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refresh(ServiceProperties props) throws ConfigException {
        ServiceProperties serviceProperties = props;
        synchronized (serviceProperties) {
            String credFile = (String)props.getProperty(SERVICE_CERT);
            if (credFile == null) {
                credFile = (String)props.getProperty(SERVICE_PROXY);
            }
            if (credFile == null) {
                return;
            }
            File file = new File(credFile);
            Long lastModified = (Long)props.getProperty(LAST_MODIFIED);
            if (lastModified == null || lastModified.longValue() != file.lastModified()) {
                SecurityConfig config = new SecurityConfig(props);
                config.initCredentials();
            }
        }
    }

    private void setLastModified(long time) {
        this.serviceProps.setProperty(LAST_MODIFIED, new Long(time));
    }

    private GSSCredential initServiceCredentials() throws GSSException, GlobusCredentialException, ConfigException {
        String certFile = this.getProperty(SERVICE_CERT);
        if (certFile == null) {
            String proxyFile = this.getProperty(SERVICE_PROXY);
            if (proxyFile == null) {
                return null;
            }
            logger.debug((Object)("Loading credential: proxy = '" + proxyFile + "'"));
            GlobusCredential gCred = new GlobusCredential(proxyFile);
            this.setLastModified(new File(proxyFile).lastModified());
            return ContainerSecurityConfig.toGSSCredential(gCred);
        }
        String keyFile = this.getProperty(SERVICE_KEY);
        if (keyFile == null) {
            throw new ConfigException(i18n.getMessage("serviceKeyMissing"));
        }
        logger.debug((Object)("Loading credential: cert = '" + certFile + "' key = '" + keyFile + "'"));
        GlobusCredential gCred = new GlobusCredential(certFile, keyFile);
        this.setLastModified(new File(certFile).lastModified());
        return ContainerSecurityConfig.toGSSCredential(gCred);
    }

    protected void initCredentials() throws ConfigException {
        try {
            GSSCredential cred = this.initServiceCredentials();
            if (cred != null) {
                Subject subject = JaasGssUtil.createSubject((GSSCredential)cred);
                SecureServicePropertiesHelper.setSubject(this.serviceProps, subject);
            }
        }
        catch (GSSException e) {
            throw new ConfigException(e);
        }
        catch (GlobusCredentialException e) {
            throw new ConfigException((Exception)((Object)e));
        }
    }

    protected void initSecurityDescriptor() throws ConfigException {
        String descriptor = this.getProperty(SECURITY_DESCRIPTOR);
        if (descriptor == null) {
            logger.debug((Object)"No security descriptor specified.");
            return;
        }
        logger.debug((Object)("Loading security descriptor: " + descriptor));
        ClassLoader loader = (class$org$globus$ogsa$impl$security$descriptor$SecurityConfig == null ? (class$org$globus$ogsa$impl$security$descriptor$SecurityConfig = SecurityConfig.class$("org.globus.ogsa.impl.security.descriptor.SecurityConfig")) : class$org$globus$ogsa$impl$security$descriptor$SecurityConfig).getClassLoader();
        InputStream input = loader.getResourceAsStream(descriptor);
        if (input == null) {
            throw new ConfigException(i18n.getMessage("noSecDescriptor", (Object)descriptor));
        }
        try {
            Document doc = XmlFactory.newDocument(input);
            SecurityDescriptor desc = new SecurityDescriptor();
            desc.parse(doc.getDocumentElement());
            SecureServicePropertiesHelper.setSecurityDescriptor(this.serviceProps, desc);
        }
        catch (ElementParserException e) {
            throw new ConfigException((Exception)((Object)e));
        }
        catch (GridServiceException e) {
            throw new ConfigException(e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

