/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.impl.security.descriptor.util;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.globus.ogsa.impl.security.descriptor.util.ElementHandler;
import org.globus.ogsa.impl.security.descriptor.util.ElementParserException;
import org.globus.util.I18n;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ElementParser
implements ElementHandler {
    private static I18n i18n = I18n.getI18n((String)"org.globus.ogsa.impl.security.descriptor.util.errors", (ClassLoader)(class$org$globus$ogsa$impl$security$descriptor$util$ElementParser == null ? (class$org$globus$ogsa$impl$security$descriptor$util$ElementParser = ElementParser.class$("org.globus.ogsa.impl.security.descriptor.util.ElementParser")) : class$org$globus$ogsa$impl$security$descriptor$util$ElementParser).getClassLoader());
    protected Map elementHandlers = new HashMap();
    private QName elemName;
    static /* synthetic */ Class class$org$globus$ogsa$impl$security$descriptor$util$ElementParser;

    public ElementParser(QName elemName) {
        this.elemName = elemName;
    }

    public void register(QName name, ElementHandler handler) {
        this.elementHandlers.put(name, handler);
    }

    public void parse(Element configElement) throws ElementParserException {
        ElementParser.checkElement(configElement, this.elemName);
        Node currentChild = configElement.getFirstChild();
        while (currentChild != null) {
            if (currentChild.getNodeType() == 1) {
                Element elem = (Element)currentChild;
                QName name = ElementParser.getQName(elem);
                ElementHandler handler = (ElementHandler)this.elementHandlers.get(name);
                if (handler == null) {
                    throw new ElementParserException(i18n.getMessage("noHandler", (Object)name));
                }
                handler.parse(elem);
            }
            currentChild = currentChild.getNextSibling();
        }
    }

    public static QName getQName(Node node) {
        return new QName(node.getNamespaceURI(), node.getLocalName());
    }

    public static void checkElement(Element configElement, QName expectedName) throws ElementParserException {
        QName cfgName;
        if (expectedName != null && !(cfgName = ElementParser.getQName(configElement)).equals(expectedName)) {
            throw new ElementParserException(i18n.getMessage("invalidElement", new Object[]{cfgName, expectedName}));
        }
    }

    public static Node getFirstChildElement(Node elem) {
        Node currentChild = elem.getFirstChild();
        while (currentChild != null) {
            if (currentChild.getNodeType() == 1) {
                return (Element)currentChild;
            }
            currentChild = currentChild.getNextSibling();
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

