/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.router;

import org.apache.axis.AxisFault;
import org.apache.axis.MessageContext;
import org.apache.axis.message.RPCElement;
import org.apache.axis.message.SOAPBodyElement;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.ogsa.config.ContainerConfig;
import org.globus.ogsa.impl.core.handle.HandleHelper;
import org.globus.ogsa.utils.MessageUtils;
import org.gridforum.ogsi.HandleType;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ReferenceRewriter {
    static Log logger = LogFactory.getLog((String)(class$org$globus$ogsa$router$ReferenceRewriter == null ? (class$org$globus$ogsa$router$ReferenceRewriter = ReferenceRewriter.class$("org.globus.ogsa.router.ReferenceRewriter")) : class$org$globus$ogsa$router$ReferenceRewriter).getName());
    static /* synthetic */ Class class$org$globus$ogsa$router$ReferenceRewriter;

    public static void rewrite(SOAPHeaderElement routerHeader, SOAPEnvelope envelope) throws AxisFault {
        String via = routerHeader.getAttributeValue("via");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Rewriting with via:" + via));
            logger.debug((Object)("Envelope before rewriting: " + envelope.toString()));
        }
        if (via == null) {
            logger.error((Object)MessageUtils.getMessage("viaMissing"));
            return;
        }
        RPCElement resultBodyElement = (RPCElement)envelope.getFirstBody();
        Element body = null;
        try {
            body = resultBodyElement.getAsDOM();
        }
        catch (Exception e) {
            AxisFault.makeFault((Exception)e);
        }
        String oldUrl = ReferenceRewriter.rewrite(body, via);
        if (oldUrl != null) {
            envelope.clearBody();
            envelope.addBodyElement(new SOAPBodyElement(body));
            routerHeader.setAttribute("", "to", oldUrl);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Rewrote reference to:" + oldUrl));
            logger.debug((Object)("Envelope after rewriting: " + envelope.toString()));
        }
    }

    private static String rewrite(Element element, String via) {
        ReferenceRewriter.rewriteElements(element, via, "http://ogsa.globus.org/", "instanceOf", "handle");
        return ReferenceRewriter.rewriteElements(element, via, "http://schemas.xmlsoap.org/wsdl/soap/", "address", "location");
    }

    private static String rewriteElements(Element elements, String via, String namespace, String name, String attr) {
        String oldUrl = null;
        NodeList nodes = elements.getElementsByTagNameNS(namespace, name);
        int i = 0;
        while (i < nodes.getLength()) {
            Element element = (Element)nodes.item(i);
            oldUrl = ReferenceRewriter.rewriteAttribute(element, attr, via);
            ++i;
        }
        return oldUrl;
    }

    private static String rewriteAttribute(Element element, String attr, String via) {
        String ogsiLocation;
        String oldUrl = element.getAttribute(attr);
        int oldUrlServicePos = oldUrl.indexOf(ogsiLocation = ContainerConfig.getOgsiLocation()) + ogsiLocation.length();
        if (oldUrlServicePos > ogsiLocation.length()) {
            element.setAttribute(attr, via + oldUrl.substring(oldUrlServicePos));
        }
        return oldUrl;
    }

    public static Object externalize(Object obj) {
        if (obj instanceof HandleType) {
            return ReferenceRewriter.externalizeHandle((HandleType)obj);
        }
        return obj;
    }

    public static HandleType externalizeHandle(HandleType handle) {
        logger.debug((Object)"Externalizing : HandleType");
        if (!HandleHelper.isLocal(handle)) {
            logger.debug((Object)"No local handle");
            return handle;
        }
        MessageContext context = MessageContext.getCurrentContext();
        if (context == null) {
            return handle;
        }
        SOAPHeaderElement header = (SOAPHeaderElement)context.getProperty("org.globus.ogsa.RouterHeader");
        if (header == null) {
            return handle;
        }
        String via = header.getAttributeValue("via");
        if (via == null) {
            return handle;
        }
        String oldUrl = handle.toString();
        String ogsiLocation = ContainerConfig.getOgsiLocation();
        int oldUrlServicePos = oldUrl.indexOf(ogsiLocation) + ogsiLocation.length();
        HandleType newHandle = null;
        if (oldUrlServicePos > ogsiLocation.length()) {
            newHandle = new HandleType(via + oldUrl.substring(oldUrlServicePos));
        }
        if (newHandle != null) {
            logger.debug((Object)("rewrote handle to: " + newHandle.getValue()));
            return newHandle;
        }
        return handle;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

