/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.server;

import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.security.Principal;
import javax.security.auth.Subject;
import org.apache.axis.AxisEngine;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.gsi.GSIConstants;
import org.globus.gsi.gssapi.GSSConstants;
import org.globus.gsi.gssapi.net.GssSocket;
import org.globus.gsi.gssapi.net.GssSocketFactory;
import org.globus.gsi.jaas.GlobusPrincipal;
import org.globus.gsi.jaas.UserNamePrincipal;
import org.globus.ogsa.server.ServiceRequest;
import org.globus.ogsa.server.ServiceRequestQueue;
import org.globus.ogsa.server.ServiceThread;
import org.globus.ogsa.server.ServiceThreadPool;
import org.globus.security.gridmap.GridMap;
import org.gridforum.jgss.ExtendedGSSContext;
import org.gridforum.jgss.ExtendedGSSManager;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSManager;

class GSIServiceThread
extends ServiceThread {
    static Log logger = LogFactory.getLog((String)(class$org$globus$ogsa$server$GSIServiceThread == null ? (class$org$globus$ogsa$server$GSIServiceThread = GSIServiceThread.class$("org.globus.ogsa.server.GSIServiceThread")) : class$org$globus$ogsa$server$GSIServiceThread).getName());
    private GridMap gridMap;
    private boolean gsiMode;
    private GSSCredential credentials;
    static /* synthetic */ Class class$org$globus$ogsa$server$GSIServiceThread;

    public GSIServiceThread(ServiceRequestQueue queue, ServiceThreadPool pool, AxisEngine engine, GSSCredential credentials, GridMap gridMap, boolean gsiMode) {
        super(queue, pool, engine);
        this.setGridMap(gridMap);
        this.setGSIMode(gsiMode);
        this.setCredentials(credentials);
        logger.info((Object)(this.getName() + ": Thread created"));
    }

    public void setGridMap(GridMap gridMap) {
        this.gridMap = gridMap;
    }

    public void setGSIMode(boolean gsiMode) {
        this.gsiMode = gsiMode;
    }

    public void setCredentials(GSSCredential credentials) {
        this.credentials = credentials;
    }

    protected String getProtocol() {
        return "httpg";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void process(ServiceRequest request) {
        logger.debug((Object)(this.getName() + ": processing requests"));
        GSSManager manager = ExtendedGSSManager.getInstance();
        GssSocket gsiSocket = null;
        OutputStream out = null;
        try {
            String userID;
            String globusID;
            ExtendedGSSContext context;
            block14: {
                block15: {
                    context = (ExtendedGSSContext)manager.createContext(this.credentials);
                    context.setOption(GSSConstants.GSS_MODE, (Object)(this.gsiMode ? GSIConstants.MODE_GSI : GSIConstants.MODE_SSL));
                    GssSocketFactory factory = GssSocketFactory.getDefault();
                    gsiSocket = (GssSocket)factory.createSocket(request.getSocket(), null, 0, (GSSContext)context);
                    gsiSocket.setUseClientMode(false);
                    gsiSocket.setAuthorization(null);
                    out = gsiSocket.getOutputStream();
                    globusID = context.getSrcName().toString();
                    logger.info((Object)(this.getName() + ": Authenticated globus user: " + globusID));
                    this.gridMap.refresh();
                    userID = this.gridMap.getUserID(globusID);
                    if (userID != null) break block14;
                    logger.error((Object)("User '" + globusID + "' not in gridmap file."));
                    byte[] status = ServiceThread.UNAUTH;
                    out.write(ServiceThread.HTTP);
                    out.write(ServiceThread.UNAUTH);
                    out.write(ServiceThread.HTML_MIME_STUFF);
                    out.write(ServiceThread.SEPARATOR);
                    out.flush();
                    Object var12_13 = null;
                    try {
                        gsiSocket.close();
                    }
                    catch (Exception e2) {}
                    break block15;
                    {
                        catch (IOException e) {
                            logger.error((Object)(this.getName() + ": Unexpected error: "), (Throwable)e);
                            Object var12_14 = null;
                            try {
                                gsiSocket.close();
                            }
                            catch (Exception e2) {}
                        }
                    }
                    catch (Throwable throwable) {
                        Object var12_15 = null;
                        try {
                            gsiSocket.close();
                        }
                        catch (Exception e2) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
                return;
            }
            logger.info((Object)(this.getName() + ": Authorized as local user: " + userID));
            logger.info((Object)(this.getName() + ": Mode: " + (this.gsiMode ? "GSI" : "SSL")));
            this.msgContext.setProperty("org.globus.gsi.authorized.user.name", (Object)userID);
            this.msgContext.setProperty("org.globus.gsi.authorized.user.dn", (Object)globusID);
            Subject subject = this.getSubject();
            subject.getPrincipals().add((Principal)new GlobusPrincipal(globusID));
            subject.getPrincipals().add((Principal)new UserNamePrincipal(userID));
            GSSCredential delegCred = context.getDelegCred();
            if (delegCred != null) {
                this.msgContext.setProperty("org.globus.gsi.credentials", (Object)delegCred);
                subject.getPrivateCredentials().add(delegCred);
            }
        }
        catch (Exception e) {
            if (gsiSocket != null) {
                try {
                    gsiSocket.close();
                }
                catch (Exception ee) {
                    // empty catch block
                }
            }
            logger.error((Object)("Error processing request: " + e.getMessage()), (Throwable)e);
            return;
        }
        ServiceRequest req = new ServiceRequest((Socket)gsiSocket, request.getServerSocket());
        super.process(req);
    }

    protected Subject getSubject() {
        Subject subject = (Subject)this.msgContext.getProperty("callerSubject");
        if (subject == null) {
            subject = new Subject();
            this.msgContext.setProperty("callerSubject", (Object)subject);
        }
        return subject;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

