/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.NoSuchElementException;
import org.apache.axis.AxisEngine;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.message.SOAPBodyElement;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPFault;
import org.apache.axis.transport.http.NonBlockingBufferedInputStream;
import org.apache.axis.utils.Messages;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.ogsa.config.ContainerConfig;
import org.globus.ogsa.server.ServiceRequest;
import org.globus.ogsa.server.ServiceRequestQueue;
import org.globus.ogsa.server.ServiceThreadPool;
import org.globus.ogsa.utils.MessageUtils;
import org.globus.ogsa.utils.PerformanceLog;
import org.w3c.dom.Document;

public class ServiceThread
extends Thread {
    private ServiceRequestQueue queue;
    private ServiceThreadPool threadPool;
    private AxisEngine engine;
    protected MessageContext msgContext;
    private Message requestMsg;
    private NonBlockingBufferedInputStream is;
    private Message responseMsg;
    private StringBuffer soapAction;
    private StringBuffer httpRequest;
    private StringBuffer fileName;
    static Log logger = LogFactory.getLog((String)(class$org$globus$ogsa$server$ServiceThread == null ? (class$org$globus$ogsa$server$ServiceThread = ServiceThread.class$("org.globus.ogsa.server.ServiceThread")) : class$org$globus$ogsa$server$ServiceThread).getName());
    static PerformanceLog performanceLogger = new PerformanceLog((class$org$globus$ogsa$server$ServiceThread == null ? (class$org$globus$ogsa$server$ServiceThread = ServiceThread.class$("org.globus.ogsa.server.ServiceThread")) : class$org$globus$ogsa$server$ServiceThread).getName() + ".performance");
    static PerformanceLog performanceProcessLogger = new PerformanceLog((class$org$globus$ogsa$server$ServiceThread == null ? (class$org$globus$ogsa$server$ServiceThread = ServiceThread.class$("org.globus.ogsa.server.ServiceThread")) : class$org$globus$ogsa$server$ServiceThread).getName() + ".performance.process");
    protected static byte[] HTTP = "HTTP/1.0 ".getBytes();
    private static byte[] OK = ("200 " + Messages.getMessage((String)"ok00")).getBytes();
    protected static byte[] UNAUTH = ("401 " + Messages.getMessage((String)"unauth00")).getBytes();
    private static byte[] ISE = ("500 " + Messages.getMessage((String)"internalError01")).getBytes();
    private static String FILE_NOT_FOUND = "404 ";
    private static byte[] XML_MIME_STUFF = "\nContent-Type: text/xml; charset=utf-8\nContent-Length: ".getBytes();
    protected static byte[] HTML_MIME_STUFF = "\nContent-Type: text/html; charset=utf-8\nContent-Length: ".getBytes();
    protected static byte[] JNLP_MIME_STUFF = "\nContent-Type: application/x-java-jnlp-file\nContent-Length: ".getBytes();
    protected static byte[] JAR_MIME_STUFF = "\nContent-Type: application/java-archive\nContent-Length: ".getBytes();
    protected static byte[] SEPARATOR = "\n\n".getBytes();
    private static final byte[] toLower = new byte[256];
    private static final byte[] lenHeader;
    private static final int lenLen;
    private static final byte[] actionHeader;
    private static final int actionLen;
    private static final byte[] getHeader;
    private static final byte[] headHeader;
    private static final byte[] postHeader;
    private static final byte[] headerEnder;
    private static final int BUFSIZ = 4096;
    private byte[] buf = new byte[4096];
    private String webRoot;
    private String webRootPath;
    private boolean webStartEnabled = false;
    static /* synthetic */ Class class$org$globus$ogsa$server$ServiceThread;

    public ServiceThread(ServiceRequestQueue queue, ServiceThreadPool pool, AxisEngine engine) {
        logger.debug((Object)"Starting up thread");
        this.queue = queue;
        this.threadPool = pool;
        this.webRoot = System.getProperty("org.globus.ogsa.server.webroot");
        String webStart = System.getProperty("org.globus.ogsa.server.webstart");
        boolean bl = this.webStartEnabled = webStart != null && webStart.equalsIgnoreCase("enable");
        if (this.webRoot == null) {
            this.webRoot = "." + File.separator;
        } else if (!this.webRoot.equals("") && !this.webRoot.endsWith(File.separator)) {
            this.webRoot = this.webRoot + File.separator;
        }
        try {
            this.webRootPath = new File(this.webRoot).getCanonicalPath();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        this.engine = engine;
        this.is = new NonBlockingBufferedInputStream();
        this.soapAction = new StringBuffer();
        this.httpRequest = new StringBuffer();
        this.fileName = new StringBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            try {
                while (true) {
                    this.msgContext = new MessageContext(this.engine);
                    this.responseMsg = null;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Thread " + this.getName() + " listening for requests"));
                    }
                    ServiceRequest request = this.queue.dequeue();
                    performanceProcessLogger.start();
                    this.process(request);
                    performanceProcessLogger.stop("process");
                    Thread.yield();
                }
            }
            catch (NoSuchElementException nse) {
                logger.debug((Object)("Stopping thread " + this.getName()));
                Object var4_3 = null;
                this.threadPool.removeThread(this);
            }
            catch (Exception e) {
                logger.error((Object)MessageUtils.toString(e));
                Object var4_4 = null;
                this.threadPool.removeThread(this);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.threadPool.removeThread(this);
            throw throwable;
        }
    }

    protected String getProtocol() {
        return "http";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void process(ServiceRequest request) {
        Socket socket = null;
        try {
            try {
                String filePart;
                byte[] status;
                OutputStream out;
                block37: {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Thread " + this.getName() + " processing requests"));
                    }
                    socket = request.getSocket();
                    out = socket.getOutputStream();
                    ServerSocket serverSocket = request.getServerSocket();
                    status = OK;
                    boolean doWsdl = false;
                    filePart = "";
                    this.is.setInputStream(socket.getInputStream());
                    int contentLength = this.parseHeaders((InputStream)this.is, this.soapAction, this.httpRequest, this.fileName);
                    this.is.setContentLength(contentLength);
                    int paramIdx = this.fileName.toString().indexOf(63);
                    if (paramIdx != -1) {
                        String params = this.fileName.substring(paramIdx + 1);
                        this.fileName.setLength(paramIdx);
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)Messages.getMessage((String)"filename00", (String)("" + this.fileName.toString())));
                            logger.debug((Object)Messages.getMessage((String)"params00", (String)params));
                        }
                        if ("wsdl".equalsIgnoreCase(params)) {
                            doWsdl = true;
                        }
                    }
                    this.msgContext.setProperty("realpath", (Object)this.fileName.toString());
                    String url = this.getProtocol() + "://localhost:" + serverSocket.getLocalPort() + "/" + this.fileName.toString();
                    this.msgContext.setProperty("transport.url", (Object)url);
                    filePart = this.fileName.toString();
                    if (filePart.startsWith(ContainerConfig.getOgsiLocation())) {
                        this.msgContext.setTargetService(filePart.substring(ContainerConfig.getOgsiLocation().length()));
                    }
                    if (this.httpRequest.toString().equals("GET")) {
                        if (doWsdl) {
                            this.doWSDL(this.engine, this.msgContext, out);
                            return;
                        }
                        this.doGet(this.engine, this.msgContext, out, filePart, true);
                        return;
                    }
                    if (!this.httpRequest.toString().equals("HEAD")) break block37;
                    this.doGet(this.engine, this.msgContext, out, filePart, false);
                    return;
                }
                try {
                    this.doPost(this.engine, this.msgContext);
                }
                catch (Exception e) {
                    status = this.doFault(e, this.msgContext, filePart);
                }
                out.write(HTTP);
                out.write(status);
                out.write(("\r\nContent-Type: " + this.responseMsg.getContentType(this.msgContext.getSOAPConstants())).getBytes());
                out.write(("\r\nContent-Length: " + this.responseMsg.getContentLength()).getBytes());
                out.write(SEPARATOR);
                this.responseMsg.writeTo(out);
                out.flush();
                return;
            }
            catch (InterruptedIOException iie) {
                return;
            }
            catch (SocketException se) {
                logger.debug((Object)MessageUtils.toString(se));
                return;
            }
        }
        catch (Exception e) {
            logger.error((Object)MessageUtils.toString(e));
            return;
        }
        finally {
            try {
                if (socket != null) {
                    socket.close();
                }
            }
            catch (Exception e) {
                logger.error((Object)MessageUtils.toString(e));
            }
        }
    }

    protected void doWSDL(AxisEngine engine, MessageContext msgContext, OutputStream out) throws AxisFault, IOException {
        engine.generateWSDL(msgContext);
        Document doc = (Document)msgContext.getProperty("WSDL");
        if (doc != null) {
            String response = XMLUtils.DocumentToString((Document)doc);
            byte[] respBytes = response.getBytes();
            out.write(HTTP);
            out.write(OK);
            out.write(XML_MIME_STUFF);
            this.putInt(out, respBytes.length);
            out.write(SEPARATOR);
            out.write(respBytes);
            out.flush();
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void doGet(AxisEngine engine, MessageContext msgContext, OutputStream out, String filePart, boolean returnContent) throws IOException {
        int bytesRead;
        File getFile;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("trying to retrieve file from:" + this.webRoot + filePart));
        }
        if (this.webRoot.equals("") && filePart.startsWith("/")) {
            filePart = filePart.substring(1, filePart.length());
        }
        String filePath = this.webRoot + filePart;
        if (!File.separator.equals("/")) {
            filePath = filePath.replace('/', File.separator.charAt(0));
        }
        if (!(getFile = new File(filePath)).getCanonicalPath().startsWith(this.webRootPath)) {
            throw new FileNotFoundException(filePath);
        }
        FileInputStream getFileStream = new FileInputStream(filePath);
        boolean xmlContent = filePart.endsWith(".xsd") || filePart.endsWith(".wsdl") || filePart.endsWith(".gwsdl");
        boolean jnlpContent = filePart.endsWith(".jnlp");
        boolean jarContent = filePart.endsWith(".jar");
        if (!xmlContent && !jnlpContent && !jarContent || (jnlpContent || jarContent) && !this.webStartEnabled) {
            throw new FileNotFoundException(filePath);
        }
        out.write(HTTP);
        out.write(OK);
        if (xmlContent) {
            out.write(XML_MIME_STUFF);
        } else if (jnlpContent) {
            out.write(JNLP_MIME_STUFF);
        } else if (jarContent) {
            out.write(JAR_MIME_STUFF);
        }
        this.putInt(out, (int)getFile.length());
        out.write(SEPARATOR);
        if (!returnContent) {
            out.flush();
            return;
        }
        byte[] fileBuffer = new byte[4096];
        while ((bytesRead = getFileStream.read(fileBuffer, 0, 4096)) > 0) {
            void var13_13;
            out.write(fileBuffer, 0, (int)var13_13);
        }
        out.flush();
    }

    protected void doPost(AxisEngine engine, MessageContext msgContext) throws AxisFault {
        String soapActionString = this.soapAction.toString();
        if (soapActionString != null) {
            msgContext.setUseSOAPAction(true);
            msgContext.setSOAPActionURI(soapActionString);
        }
        this.requestMsg = new Message((Object)this.is);
        msgContext.setRequestMessage(this.requestMsg);
        performanceLogger.start();
        engine.invoke(msgContext);
        performanceLogger.stop("Post: Engine Invoke");
        this.responseMsg = msgContext.getResponseMessage();
        if (this.responseMsg == null) {
            throw new AxisFault(Messages.getMessage((String)"nullResponse00"));
        }
    }

    protected byte[] doFault(Exception e, MessageContext msgContext, String filepart) {
        AxisFault af;
        byte[] status = OK;
        if (e instanceof AxisFault) {
            af = (AxisFault)((Object)e);
            logger.error((Object)Messages.getMessage((String)"serverFault00"), (Throwable)af);
            status = "Server.Unauthorized".equals(af.getFaultCode()) ? UNAUTH : ISE;
        } else {
            status = e instanceof IOException ? (FILE_NOT_FOUND + filepart).getBytes() : ISE;
            af = AxisFault.makeFault((Exception)e);
        }
        this.responseMsg = msgContext.getResponseMessage();
        if (this.responseMsg == null) {
            this.responseMsg = new Message((Object)af);
        } else {
            try {
                SOAPEnvelope env = this.responseMsg.getSOAPEnvelope();
                env.clearBody();
                env.addBodyElement((SOAPBodyElement)new SOAPFault((AxisFault)((Object)e)));
            }
            catch (AxisFault fault) {
                logger.error((Object)MessageUtils.toString((Exception)((Object)fault)));
            }
        }
        return status;
    }

    /*
     * WARNING - void declaration
     */
    private int readLine(InputStream is, byte[] b, int off, int len) throws IOException {
        int c;
        int count = 0;
        while ((c = is.read()) != -1) {
            void var6_6;
            b[off++] = (byte)var6_6;
            if (var6_6 == 10 || ++count == len) break;
        }
        return count > 0 ? count : -1;
    }

    /*
     * Unable to fully structure code
     */
    private int parseHeaders(InputStream is, StringBuffer soapAction, StringBuffer httpRequest, StringBuffer fileName) throws IOException {
        block16: {
            len = 0;
            n = this.readLine(is, this.buf, 0, this.buf.length);
            if (n < 0) {
                throw new IOException(Messages.getMessage((String)"unexpectedEOS00"));
            }
            httpRequest.delete(0, httpRequest.length());
            fileName.delete(0, fileName.length());
            if (this.buf[0] == ServiceThread.getHeader[0]) {
                httpRequest.append("GET");
                i = 0;
                while (i < n - 5) {
                    c = (char)(this.buf[i + 5] & 127);
                    if (c == ' ') break;
                    fileName.append(c);
                    ++i;
                }
                if (ServiceThread.logger.isDebugEnabled()) {
                    ServiceThread.logger.debug((Object)Messages.getMessage((String)"filename01", (String)"ServiceThread", (String)fileName.toString()));
                }
                return 0;
            }
            if (this.buf[0] == ServiceThread.headHeader[0]) {
                httpRequest.append("HEAD");
                i = 0;
                while (i < n - 5) {
                    c = (char)(this.buf[i + 5] & 127);
                    if (c == ' ') break;
                    fileName.append(c);
                    ++i;
                }
                if (ServiceThread.logger.isDebugEnabled()) {
                    ServiceThread.logger.debug((Object)Messages.getMessage((String)"filename01", (String)"ServiceThread", (String)fileName.toString()));
                }
                return 0;
            }
            if (this.buf[0] != ServiceThread.postHeader[0]) break block16;
            httpRequest.append("POST");
            i = 0;
            while (i < n - 6) {
                c = (char)(this.buf[i + 6] & 127);
                if (c == ' ') break;
                fileName.append(c);
                ++i;
            }
            if (ServiceThread.logger.isDebugEnabled()) {
                ServiceThread.logger.debug((Object)Messages.getMessage((String)"filename01", (String)"ServiceThread", (String)fileName.toString()));
            }
            ** GOTO lbl73
        }
        throw new IOException(Messages.getMessage((String)"badRequest00"));
        while (n > 2 || this.buf[0] != 10 && this.buf[0] != 13 || len <= 0) {
            endHeaderIndex = 0;
            while (endHeaderIndex < n && ServiceThread.toLower[this.buf[endHeaderIndex]] != ServiceThread.headerEnder[0]) {
                ++endHeaderIndex;
            }
            i = (endHeaderIndex += 2) - 1;
            if (endHeaderIndex == ServiceThread.lenLen && this.matches(this.buf, ServiceThread.lenHeader)) {
                while (++i < n && this.buf[i] >= 48 && this.buf[i] <= 57) {
                    len = len * 10 + (this.buf[i] - 48);
                }
            } else if (endHeaderIndex == ServiceThread.actionLen && this.matches(this.buf, ServiceThread.actionHeader)) {
                soapAction.delete(0, soapAction.length());
                ++i;
                while (++i < n && this.buf[i] != 34) {
                    soapAction.append((char)(this.buf[i] & 127));
                }
            }
lbl73:
            // 5 sources

            if ((n = this.readLine(is, this.buf, 0, this.buf.length)) > 0) continue;
        }
        return len;
    }

    public boolean matches(byte[] buf, byte[] target) {
        int i = 0;
        while (i < target.length) {
            if (toLower[buf[i]] != target[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean matches(byte[] buf, int bufIdx, byte[] target) {
        int i = 0;
        while (i < target.length) {
            if (toLower[buf[bufIdx + i]] != target[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void putInt(OutputStream out, int value) throws IOException {
        int len = 0;
        int offset = this.buf.length;
        if (value < 0) {
            this.buf[--offset] = 45;
            value = -value;
            ++len;
        }
        if (value == 0) {
            this.buf[--offset] = 48;
            ++len;
        }
        while (value > 0) {
            this.buf[--offset] = (byte)(value % 10 + 48);
            value /= 10;
            ++len;
        }
        out.write(this.buf, offset, len);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        int i = 0;
        while (i < 256) {
            ServiceThread.toLower[i] = (byte)i;
            ++i;
        }
        int lc = 97;
        while (lc <= 122) {
            ServiceThread.toLower[lc + 65 - 97] = (byte)lc;
            ++lc;
        }
        lenHeader = "content-length: ".getBytes();
        lenLen = lenHeader.length;
        actionHeader = "soapaction: ".getBytes();
        actionLen = actionHeader.length;
        getHeader = "GET".getBytes();
        headHeader = "HEAD".getBytes();
        postHeader = "POST".getBytes();
        headerEnder = ": ".getBytes();
    }
}

