/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.tools.utils;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.axis.utils.XMLUtils;
import org.globus.ogsa.tools.utils.MessagePrintingUtil;
import org.globus.ogsa.tools.utils.ResourceBundleUtil;
import org.globus.ogsa.tools.utils.SchemaDirectory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NormalizeSchema {
    static /* synthetic */ Class class$org$globus$ogsa$tools$utils$NormalizeSchema;

    public static void main(String[] args) {
        NormalizeSchema ns = new NormalizeSchema();
        if (args.length != 1) {
            NormalizeSchema.usage();
        }
        try {
            File wsdlDir = new File(args[0]);
            if (!wsdlDir.isDirectory()) {
                NormalizeSchema.usage();
                System.exit(1);
            }
            NormalizeSchema normalizeSchema = ns;
            normalizeSchema.getClass();
            File[] wsdlFiles = wsdlDir.listFiles(normalizeSchema.new WSDLFileFilter());
            int k = 0;
            while (k < wsdlFiles.length) {
                File file = wsdlFiles[k];
                if (file.isDirectory()) {
                    NormalizeSchema.main(new String[]{file.getCanonicalPath()});
                } else {
                    if (file.getCanonicalPath().indexOf("schema") < 0) {
                        ResourceBundleUtil.getMessage("fileNotInSchemaDir", file.getCanonicalPath());
                        System.exit(1);
                    }
                    File schemaCandidate = new File(file.getParent());
                    while (!schemaCandidate.getCanonicalPath().endsWith("schema")) {
                        schemaCandidate = new File(schemaCandidate.getParent());
                    }
                    SchemaDirectory sd = new SchemaDirectory(schemaCandidate.getCanonicalPath());
                    File currentSchemaDir = null;
                    boolean currentSchemaDirFound = false;
                    FileInputStream fis = new FileInputStream(file);
                    Document doc = XMLUtils.newDocument((InputStream)fis);
                    fis.close();
                    NodeList imports = doc.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/", "import");
                    int i = 0;
                    while (i < imports.getLength()) {
                        Node importNode = imports.item(i);
                        NamedNodeMap importAttrs = importNode.getAttributes();
                        String location = null;
                        int j = 0;
                        while (j < importAttrs.getLength()) {
                            int scIndex;
                            Node importAttr = importAttrs.item(j);
                            if (importAttr.getNodeName().equalsIgnoreCase("location") && (scIndex = (location = importAttr.getNodeValue()).indexOf("schema/ogsi")) != -1) {
                                currentSchemaDir = new File(file.getParentFile(), location.substring(0, scIndex + "schema".length()));
                                currentSchemaDirFound = true;
                                break;
                            }
                            ++j;
                        }
                        if (currentSchemaDirFound) break;
                        ++i;
                    }
                    if (currentSchemaDirFound) {
                        sd.updateImports(file, currentSchemaDir);
                    }
                }
                ++k;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(1);
        }
    }

    protected static void usage() {
        String ls = System.getProperty("line.separator");
        StringBuffer usage = new StringBuffer();
        usage.append(ResourceBundleUtil.getMessage("usage")).append("java ").append((class$org$globus$ogsa$tools$utils$NormalizeSchema == null ? (class$org$globus$ogsa$tools$utils$NormalizeSchema = NormalizeSchema.class$("org.globus.ogsa.tools.utils.NormalizeSchema")) : class$org$globus$ogsa$tools$utils$NormalizeSchema).getName()).append(ResourceBundleUtil.getMessage("normalizeSchemaCl")).append(ls);
        MessagePrintingUtil.info(true, usage.toString());
        System.exit(0);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class WSDLFileFilter
    implements FileFilter {
        private WSDLFileFilter() {
        }

        public boolean accept(File fileTest) {
            boolean isAcceptable = false;
            if (fileTest.isDirectory() || fileTest.isFile() && fileTest.getName().endsWith(".wsdl")) {
                isAcceptable = true;
            }
            return isAcceptable;
        }
    }
}

