/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.tools.utils;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.globus.ogsa.tools.utils.ToolingResourceBundle;

public class ResourceBundleUtil {
    private static ToolingResourceBundle resourceBundle = null;
    private static final String KEY_MARKER = "ResourceBundleUtil.getMessage(\"";

    private static void initializeMessages() {
        resourceBundle = new ToolingResourceBundle();
    }

    public static String getMessage(String key) {
        if (resourceBundle == null) {
            ResourceBundleUtil.initializeMessages();
        }
        return resourceBundle.getString(key);
    }

    public static String getMessage(String key, String substitution) {
        if (resourceBundle == null) {
            ResourceBundleUtil.initializeMessages();
        }
        return resourceBundle.getString(key, substitution);
    }

    public static String getMessage(String key, String substitution1, String substitution2) {
        if (resourceBundle == null) {
            ResourceBundleUtil.initializeMessages();
        }
        return resourceBundle.getString(key, substitution1, substitution2);
    }

    public static String getMessage(String key, String substitution1, String substitution2, String substitution3) {
        if (resourceBundle == null) {
            ResourceBundleUtil.initializeMessages();
        }
        return resourceBundle.getString(key, substitution1, substitution2, substitution3);
    }

    public static String getMessage(String key, String[] substitutions) {
        if (resourceBundle == null) {
            ResourceBundleUtil.initializeMessages();
        }
        return resourceBundle.getString(key, substitutions);
    }

    private static void checkForDuplicates() {
        System.out.println("================== Duplicate Keys ==================");
        if (resourceBundle == null) {
            ResourceBundleUtil.initializeMessages();
        }
        Vector<String> duplicateKeys = new Vector<String>();
        Object[][] contents = resourceBundle.getContents();
        int i = 0;
        while (i < contents.length) {
            String key = (String)contents[i][0];
            int j = 0;
            while (j < contents.length) {
                String curKey;
                if (j != i && key.equals(curKey = (String)contents[j][0]) && !duplicateKeys.contains(key)) {
                    duplicateKeys.addElement(key);
                    break;
                }
                ++j;
            }
            ++i;
        }
        if (duplicateKeys.isEmpty()) {
            System.out.println("no duplicate keys");
        } else {
            int i2 = 0;
            while (i2 < duplicateKeys.size()) {
                System.out.println("duplicate key: " + (String)duplicateKeys.elementAt(i2));
                ++i2;
            }
        }
        System.out.println("================== Duplicate Keys ==================");
    }

    private static void getAllKeys(File startingDir, HashMap allKeys) {
        File[] files = startingDir.listFiles(new JavaFileFilter());
        int i = 0;
        while (i < files.length) {
            File curFile = files[i];
            if (curFile.isDirectory()) {
                ResourceBundleUtil.getAllKeys(curFile, allKeys);
            } else {
                try {
                    FileInputStream input = new FileInputStream(curFile);
                    int available = input.available();
                    byte[] inBytes = new byte[available];
                    input.read(inBytes);
                    input.close();
                    Vector<String> keys = new Vector<String>();
                    String fileContents = new String(inBytes);
                    int startIndex = fileContents.indexOf(KEY_MARKER, 0);
                    while (startIndex != -1) {
                        int endIndex = fileContents.indexOf("\"", startIndex + KEY_MARKER.length());
                        String key = fileContents.substring(startIndex + KEY_MARKER.length(), endIndex);
                        if (!keys.contains(key)) {
                            keys.addElement(key);
                        }
                        startIndex = fileContents.indexOf(KEY_MARKER, endIndex + 1);
                    }
                    if (!keys.isEmpty()) {
                        allKeys.put(curFile.getName(), keys);
                    }
                }
                catch (Exception e) {
                    System.err.println(e.getMessage());
                    e.printStackTrace();
                    System.exit(-1);
                }
            }
            ++i;
        }
    }

    private static void printKeyStatus() {
        if (resourceBundle == null) {
            ResourceBundleUtil.initializeMessages();
        }
        System.out.println("==================== Key Status ====================");
        File startingDir = new File(System.getProperty("TOOLING_ROOT_DIR"));
        HashMap allKeys = new HashMap();
        ResourceBundleUtil.getAllKeys(startingDir, allKeys);
        Iterator keyIt = allKeys.keySet().iterator();
        while (keyIt.hasNext()) {
            String key = (String)keyIt.next();
            System.out.print(key + ": ");
            Vector keys = (Vector)allKeys.get(key);
            int i = 0;
            while (i < keys.size()) {
                if (i < keys.size() - 1) {
                    System.out.print((String)keys.elementAt(i) + ", ");
                } else {
                    System.out.println((String)keys.elementAt(i));
                }
                ++i;
            }
        }
        System.out.println("==================== Key Status ====================");
    }

    private static Vector getKeyVector() {
        if (resourceBundle == null) {
            ResourceBundleUtil.initializeMessages();
        }
        File startingDir = new File(System.getProperty("TOOLING_ROOT_DIR"));
        HashMap allKeys = new HashMap();
        ResourceBundleUtil.getAllKeys(startingDir, allKeys);
        Vector<String> allKeysVec = new Vector<String>();
        Iterator keyVecIt = allKeys.values().iterator();
        while (keyVecIt.hasNext()) {
            Vector keysInFile = (Vector)keyVecIt.next();
            int i = 0;
            while (i < keysInFile.size()) {
                String keyInFile = (String)keysInFile.elementAt(i);
                if (!allKeysVec.contains(keyInFile)) {
                    allKeysVec.addElement(keyInFile);
                }
                ++i;
            }
        }
        return allKeysVec;
    }

    private static void checkForUnusedKeys() {
        Vector allKeysVec = ResourceBundleUtil.getKeyVector();
        System.out.println("==================== Unused Keys ===================");
        Object[][] contents = resourceBundle.getContents();
        int i = 0;
        while (i < contents.length) {
            String rbKey = (String)contents[i][0];
            if (!allKeysVec.contains(rbKey)) {
                System.out.println(rbKey + " is unused");
            }
            ++i;
        }
        System.out.println("==================== Unused Keys ===================");
    }

    private static void checkForNonExistentKeys() {
        Vector allKeysVec = ResourceBundleUtil.getKeyVector();
        Object[][] contents = resourceBundle.getContents();
        Vector<String> rbContents = new Vector<String>();
        int i = 0;
        while (i < contents.length) {
            rbContents.addElement((String)contents[i][0]);
            ++i;
        }
        System.out.println("================ Non-existinent keys ===============");
        int i2 = 0;
        while (i2 < allKeysVec.size()) {
            String curKey = (String)allKeysVec.elementAt(i2);
            if (!rbContents.contains(curKey)) {
                System.out.println(curKey + " is not in the resource bundle");
            }
            ++i2;
        }
        System.out.println("================ Non-existinent keys ===============");
    }

    public static void main(String[] args) {
        ResourceBundleUtil.checkForDuplicates();
        ResourceBundleUtil.checkForUnusedKeys();
        ResourceBundleUtil.checkForNonExistentKeys();
    }

    private static class JavaFileFilter
    implements FileFilter {
        private static final String JAVA_FILE_EXTENSION = ".java";

        private JavaFileFilter() {
        }

        public boolean accept(File file) {
            return file.isDirectory() || file.isFile() && file.getName().endsWith(JAVA_FILE_EXTENSION);
        }
    }
}

