/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.tools.wsdl;

import java.io.File;
import java.util.LinkedList;

public class RelativePathUtil {
    public static String getRelativeFileName(File target, File realativeTo) {
        LinkedList targetList = RelativePathUtil.getPathList(target);
        LinkedList relativeList = RelativePathUtil.getPathList(realativeTo);
        while (!targetList.isEmpty() && !relativeList.isEmpty() && targetList.getFirst().equals(relativeList.getFirst())) {
            targetList.removeFirst();
            relativeList.removeFirst();
        }
        StringBuffer fileName = new StringBuffer();
        while (!relativeList.isEmpty()) {
            fileName.append("../");
            relativeList.removeFirst();
        }
        while (!targetList.isEmpty()) {
            fileName.append(targetList.removeFirst());
            fileName.append('/');
        }
        fileName.append(target.getName());
        return fileName.toString();
    }

    private static LinkedList getPathList(File file) {
        if (!file.isAbsolute()) {
            file = file.getAbsoluteFile();
        }
        LinkedList<String> list = new LinkedList<String>();
        if (!file.isDirectory()) {
            file = file.getParentFile();
        }
        while (file != null) {
            if (file.getName().length() > 0) {
                list.addFirst(file.getName());
            }
            file = file.getParentFile();
        }
        return list;
    }
}

