/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.tools.wsdl.toJava;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import javax.wsdl.Definition;
import javax.wsdl.Service;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.axis.wsdl.symbolTable.SymbolTable;
import org.apache.axis.wsdl.toJava.DuplicateFileException;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.JavaDeployWriter;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JavaGridServiceDeployFragmentWriter
extends JavaDeployWriter {
    protected Service m_service;
    protected String m_fullClassName;
    protected String type;
    protected Document m_wsddDoc = null;

    public JavaGridServiceDeployFragmentWriter(Emitter emitter, Definition definition, SymbolTable symbolTable, String fullClassName, String type, Service service) {
        super(emitter, definition, symbolTable);
        this.m_service = service;
        this.m_fullClassName = fullClassName;
        this.type = type;
    }

    public void generate() throws IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            if (this.emitter.isServerSide()) {
                builder = factory.newDocumentBuilder();
                this.m_wsddDoc = builder.newDocument();
                super.generate();
            }
        }
        catch (DuplicateFileException e) {
            String msg;
            String file = this.getFileName();
            try {
                builder = factory.newDocumentBuilder();
                File fileLoc = new File(file.replace('\\', '/'));
                this.m_wsddDoc = builder.parse(new InputSource(fileLoc.toURL().toString()));
            }
            catch (ParserConfigurationException pce) {
                throw new IOException(pce.getMessage());
            }
            catch (SAXException se) {
                throw new IOException(se.getMessage());
            }
            this.registerFile(file);
            if (this.emitter.isVerbose() && (msg = this.verboseMessage(file)) != null) {
                System.out.println(msg);
            }
            PrintWriter pw = this.getPrintWriter(file);
            this.writeFileHeader(pw);
            this.writeFileBody(pw);
            this.writeFileFooter(pw);
            this.closePrintWriter(pw);
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e.getMessage());
        }
    }

    protected boolean isFileGenerated(String file) {
        File possibleWSDD = new File(file);
        return possibleWSDD.exists();
    }

    protected String stripComments(String data) {
        if (data.startsWith("<!--")) {
            data = data.substring(4);
        }
        if (data.endsWith("-->")) {
            data = data.substring(0, data.lastIndexOf("-->"));
        }
        return data;
    }

    protected void closePrintWriter(PrintWriter pw) {
        OutputFormat of = new OutputFormat();
        of.setIndenting(true);
        of.setOmitXMLDeclaration(true);
        XMLSerializer ser = new XMLSerializer((Writer)pw, of);
        try {
            ser.serialize(this.m_wsddDoc);
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
        pw.close();
    }
}

