/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.axis.utils.XMLUtils;
import org.globus.ogsa.impl.core.service.ServiceDataAnnotation;
import org.globus.ogsa.utils.MessageUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GenerateSDD {
    public static final String WSDL_NS = "http://schemas.xmlsoap.org/wsdl/";
    public static final String XSD_NS = "http://www.w3.org/2001/XMLSchema";

    public static void addServiceDataDescription(Element portType, Map typeMap, ServiceDataAnnotation sd) {
        Document doc = portType.getOwnerDocument();
        String elementTypeName = (String)typeMap.get(sd.callbackMethodName + "Return");
        if (elementTypeName == null) {
            System.err.println("Error: " + sd.callbackMethodName + "Return not found in wsdl");
            return;
        }
        Element sddElement = doc.createElementNS("http://www.gridforum.org/namespaces/2003/03/serviceData", "sd:serviceData");
        sddElement.setAttribute("name", sd.name);
        sddElement.setAttribute("type", elementTypeName);
        sddElement.setAttribute("minOccurs", sd.minOccurs);
        sddElement.setAttribute("maxOccurs", sd.maxOccurs);
        sddElement.setAttribute("mutability", sd.mutability);
        sddElement.setAttribute("modifiable", sd.modifiable);
        sddElement.setAttribute("nillable", sd.nillable);
        if (sd.documentation != null) {
            Element documentationElement = doc.createElement("documentation");
            documentationElement.appendChild(doc.createTextNode(sd.documentation));
            sddElement.appendChild(documentationElement);
        }
        portType.appendChild(sddElement);
        System.out.println("generated ServiceDataDescription for " + sd.name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length < 2) {
            System.err.println("Usage: GenerateSDD <wsdl definition file> <class name with service data annotations>");
            System.exit(1);
        }
        OutputStream output = null;
        InputStream wsdlInput = null;
        try {
            NodeList portTypes;
            List sdList;
            String wsdlFileName = args[0];
            String className = args[1];
            wsdlInput = new BufferedInputStream(new FileInputStream(wsdlFileName));
            Document wsdlDoc = XMLUtils.newDocument((InputStream)wsdlInput);
            if (wsdlDoc == null) {
                System.err.println("Error: wsdl file not found: " + wsdlFileName);
                System.exit(1);
            }
            if ((sdList = ServiceDataAnnotation.getServiceDataAnnotations(className)) == null) {
                System.err.println("Error: no service data annotations found for " + className);
                System.err.println("       you must run the ServiceDataDoclet first.");
                System.exit(1);
            }
            if ((portTypes = wsdlDoc.getElementsByTagNameNS(WSDL_NS, "portType")).getLength() != 1) {
                throw new Exception(MessageUtils.getMessage("singlePortTypeError"));
            }
            Element portType = (Element)portTypes.item(0);
            NodeList gwsdlPortTypes = wsdlDoc.getElementsByTagNameNS("http://www.gridforum.org/namespaces/2003/03/gridWSDLExtensions", "portType");
            Element gwsdlPortType = null;
            if (gwsdlPortTypes.getLength() == 0) {
                gwsdlPortType = wsdlDoc.createElementNS("http://www.gridforum.org/namespaces/2003/03/gridWSDLExtensions", "gwsdl:portType");
                gwsdlPortType.setAttribute("name", portType.getAttribute("name"));
                wsdlDoc.getDocumentElement().insertBefore(gwsdlPortType, portType);
            } else {
                gwsdlPortType = (Element)gwsdlPortTypes.item(0);
            }
            NodeList partList = wsdlDoc.getElementsByTagNameNS(WSDL_NS, "part");
            HashMap typeMap = new HashMap();
            boolean wrapped = false;
            int i = 0;
            while (i < partList.getLength()) {
                NamedNodeMap attrs = partList.item(i).getAttributes();
                String name = attrs.getNamedItem("name").getNodeValue();
                Node item = attrs.getNamedItem("type");
                if (item == null) {
                    wrapped = true;
                    break;
                }
                String type = item.getNodeValue();
                typeMap.put(name, type);
                ++i;
            }
            if (wrapped) {
                typeMap = GenerateSDD.getReturnTypes(wsdlDoc);
            }
            Iterator iter = sdList.iterator();
            while (iter.hasNext()) {
                GenerateSDD.addServiceDataDescription(gwsdlPortType, typeMap, (ServiceDataAnnotation)iter.next());
            }
            wsdlInput.close();
            output = new BufferedOutputStream(new FileOutputStream(wsdlFileName));
            XMLUtils.DocumentToStream((Document)wsdlDoc, (OutputStream)output);
            output.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (Exception io) {}
            }
            if (wsdlInput != null) {
                try {
                    wsdlInput.close();
                }
                catch (Exception io) {}
            }
        }
    }

    private static HashMap getReturnTypes(Document doc) {
        HashMap<String, String> map = new HashMap<String, String>();
        NodeList nodes = doc.getElementsByTagNameNS(XSD_NS, "element");
        int i = 0;
        while (i < nodes.getLength()) {
            Element element = (Element)nodes.item(i);
            String elementName = element.getAttribute("name");
            if (elementName.endsWith("Return")) {
                map.put(elementName, element.getAttribute("type"));
            }
            ++i;
        }
        return map;
    }
}

