/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.utils;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.ogsa.encoding.ObjectSerializer;
import org.globus.ogsa.types.profiling.Timestamp;
import org.globus.ogsa.types.profiling.TimestampType;
import org.globus.ogsa.utils.MessageUtils;

public class PerformanceLog {
    private ThreadLocal local = new ThreadLocal();
    private boolean fullEnabled = false;
    private boolean shortEnabled = false;
    private Log logger;

    public PerformanceLog(String loggerName) {
        this.logger = LogFactory.getLog((String)loggerName);
        if (this.logger.isDebugEnabled()) {
            if ("full".equalsIgnoreCase(System.getProperty("org.globus.ogsa.performance.log"))) {
                this.fullEnabled = true;
            } else {
                this.shortEnabled = true;
            }
        }
    }

    public boolean enabled() {
        return this.fullEnabled || this.shortEnabled;
    }

    public void start() {
        if (!this.enabled()) {
            return;
        }
        this.local.set(new Long(System.currentTimeMillis()));
    }

    public void stop(String operation) {
        if (!this.enabled()) {
            return;
        }
        long stop = System.currentTimeMillis();
        Long startLong = (Long)this.local.get();
        if (startLong == null) {
            return;
        }
        long start = startLong;
        String threadName = Thread.currentThread().getName();
        if (this.shortEnabled) {
            this.logger.debug((Object)("[" + operation + "][" + threadName + "]" + "[" + Long.toString(stop - start) + "]"));
        } else {
            TimestampType timestampType = new TimestampType();
            Timestamp timestamp = new Timestamp();
            timestampType.setTimestamp(timestamp);
            timestamp.setStartTime(start);
            timestamp.setEndTime(stop);
            timestamp.setThreadID(threadName);
            timestamp.setOperation(operation);
            try {
                this.logger.debug((Object)ObjectSerializer.toString(timestampType));
            }
            catch (Exception e) {
                this.logger.error((Object)MessageUtils.toString(e));
            }
        }
    }
}

