/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.wsdl;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Operation;
import javax.wsdl.PortType;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.xml.namespace.QName;
import org.apache.axis.Constants;
import org.apache.axis.wsdl.symbolTable.BindingEntry;
import org.apache.axis.wsdl.symbolTable.Parameter;
import org.apache.axis.wsdl.symbolTable.Parameters;
import org.apache.axis.wsdl.toJava.JavaGeneratorFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.ogsa.GridServiceException;
import org.globus.ogsa.utils.PerformanceLog;
import org.globus.ogsa.wsdl.GSR;
import org.globus.ogsa.wsdl.GSRDescription;
import org.globus.ogsa.wsdl.OperationEntry;
import org.w3c.dom.Document;

public class SymbolTable
extends org.apache.axis.wsdl.symbolTable.SymbolTable {
    private static final String DISABLE_PROPERTY = "org.globus.ogsa.symbolTable";
    static Log logger = LogFactory.getLog((String)(class$org$globus$ogsa$wsdl$SymbolTable == null ? (class$org$globus$ogsa$wsdl$SymbolTable = SymbolTable.class$("org.globus.ogsa.wsdl.SymbolTable")) : class$org$globus$ogsa$wsdl$SymbolTable).getName());
    static PerformanceLog performanceLogger = new PerformanceLog((class$org$globus$ogsa$wsdl$SymbolTable == null ? (class$org$globus$ogsa$wsdl$SymbolTable = SymbolTable.class$("org.globus.ogsa.wsdl.SymbolTable")) : class$org$globus$ogsa$wsdl$SymbolTable).getName() + ".performance");
    static /* synthetic */ Class class$org$globus$ogsa$wsdl$SymbolTable;

    public SymbolTable() {
        super(new JavaGeneratorFactory().getBaseTypeMapping(), true, logger.isDebugEnabled(), false);
    }

    public static String getDisableProperty() {
        String disable = System.getProperty(DISABLE_PROPERTY);
        if (disable == null) {
            return "";
        }
        return "-Dorg.globus.ogsa.symbolTable=" + disable;
    }

    public GSRDescription add(Document doc) throws GridServiceException {
        try {
            GSRDescription desc = null;
            performanceLogger.start();
            GSR gsr = new GSR(doc);
            performanceLogger.stop("creating gsr");
            String disable = System.getProperty(DISABLE_PROPERTY);
            if (disable == null || !disable.equalsIgnoreCase("disable")) {
                performanceLogger.start();
                this.add("", gsr.getWSDLDefinition(), doc);
                performanceLogger.stop("parsing WSDL");
                desc = this.populateOperationInfo();
            } else {
                desc = new GSRDescription();
            }
            desc.setGSR(gsr);
            return desc;
        }
        catch (Exception e) {
            throw new GridServiceException(e);
        }
    }

    private GSRDescription populateOperationInfo() throws Exception {
        GSRDescription description = new GSRDescription();
        HashMap symbolMap = this.getHashMap();
        Iterator symbols = symbolMap.values().iterator();
        while (symbols.hasNext()) {
            Vector symbolVector = (Vector)symbols.next();
            int i = 0;
            while (i < symbolVector.size()) {
                if (symbolVector.get(i) instanceof BindingEntry) {
                    BindingEntry bindingEntry = (BindingEntry)symbolVector.get(i);
                    Binding binding = bindingEntry.getBinding();
                    PortType portType = binding.getPortType();
                    Iterator operations = portType.getOperations().iterator();
                    while (operations.hasNext()) {
                        Operation operation = (Operation)operations.next();
                        Parameters params = bindingEntry.getParameters(operation);
                        OperationEntry operationEntry = new OperationEntry();
                        if (params.returnParam != null) {
                            operationEntry.returnName = params.returnParam.getQName();
                        }
                        operationEntry.outs = new QName[params.inouts + params.outputs];
                        operationEntry.modes = new byte[operationEntry.outs.length];
                        int paramIndex = 0;
                        Enumeration enumeration = params.list.elements();
                        while (enumeration.hasMoreElements()) {
                            Parameter inoutParam = (Parameter)enumeration.nextElement();
                            byte mode = inoutParam.getMode();
                            if (mode != 3 && mode != 2) continue;
                            operationEntry.outs[paramIndex] = inoutParam.getQName();
                            operationEntry.modes[paramIndex] = mode;
                            ++paramIndex;
                        }
                        BindingOperation bindingOperation = binding.getBindingOperation(operation.getName(), null, null);
                        BindingOutput bindingOutput = bindingOperation.getBindingOutput();
                        if (bindingOutput == null) continue;
                        List extensibilityList = bindingOutput.getExtensibilityElements();
                        Iterator outputs = extensibilityList.iterator();
                        while (outputs.hasNext()) {
                            List styleList;
                            Object extension = outputs.next();
                            if (!(extension instanceof SOAPBody) || (styleList = ((SOAPBody)extension).getEncodingStyles()) == null) continue;
                            Iterator styles = styleList.iterator();
                            while (styles.hasNext()) {
                                String style = (String)styles.next();
                                if (!Constants.isSOAP_ENC((String)style)) continue;
                                operationEntry.isSOAPEncoded = true;
                            }
                        }
                        description.addOperationEntry(operation.getName(), operationEntry);
                    }
                }
                ++i;
            }
        }
        return description;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

