/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.algorithms;

import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;
import org.apache.log4j.Category;
import org.apache.xml.security.algorithms.Algorithm;
import org.apache.xml.security.algorithms.SignatureAlgorithmSpi;
import org.apache.xml.security.exceptions.AlgorithmAlreadyRegisteredException;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.XMLSignatureException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SignatureAlgorithm
extends Algorithm {
    static Category cat = Category.getInstance((String)(class$org$apache$xml$security$algorithms$SignatureAlgorithm == null ? (class$org$apache$xml$security$algorithms$SignatureAlgorithm = SignatureAlgorithm.class$("org.apache.xml.security.algorithms.SignatureAlgorithm")) : class$org$apache$xml$security$algorithms$SignatureAlgorithm).getName());
    static boolean _alreadyInitialized = false;
    static HashMap _algorithmHash = null;
    protected SignatureAlgorithmSpi _signatureAlgorithm = null;
    static /* synthetic */ Class class$org$apache$xml$security$algorithms$SignatureAlgorithm;

    public SignatureAlgorithm(Document document, String string) throws XMLSecurityException {
        super(document, string);
        try {
            String string2 = SignatureAlgorithm.getImplementingClass(string);
            cat.debug((Object)("Create URI \"" + string + "\" class \"" + string2 + "\""));
            this._signatureAlgorithm = (SignatureAlgorithmSpi)Class.forName(string2).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            Object[] objectArray = new Object[]{string, classNotFoundException.getMessage()};
            throw new XMLSignatureException("algorithms.NoSuchAlgorithm", objectArray, classNotFoundException);
        }
        catch (IllegalAccessException illegalAccessException) {
            Object[] objectArray = new Object[]{string, illegalAccessException.getMessage()};
            throw new XMLSignatureException("algorithms.NoSuchAlgorithm", objectArray, illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            Object[] objectArray = new Object[]{string, instantiationException.getMessage()};
            throw new XMLSignatureException("algorithms.NoSuchAlgorithm", objectArray, instantiationException);
        }
        catch (NullPointerException nullPointerException) {
            Object[] objectArray = new Object[]{string, ((Throwable)nullPointerException).getMessage()};
            throw new XMLSignatureException("algorithms.NoSuchAlgorithm", objectArray, nullPointerException);
        }
    }

    public SignatureAlgorithm(Document document, String string, int n) throws XMLSecurityException {
        this(document, string);
        this._signatureAlgorithm.engineSetHMACOutputLength(n);
        this._signatureAlgorithm.engineAddContextToElement(this._constructionElement);
    }

    public SignatureAlgorithm(Element element, String string) throws XMLSecurityException {
        super(element, string);
        String string2 = this.getURI();
        try {
            String string3 = SignatureAlgorithm.getImplementingClass(string2);
            cat.debug((Object)("Create URI \"" + string2 + "\" class \"" + string3 + "\""));
            this._signatureAlgorithm = (SignatureAlgorithmSpi)Class.forName(string3).newInstance();
            this._signatureAlgorithm.engineGetContextFromElement(this._constructionElement);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Object[] objectArray = new Object[]{string2, classNotFoundException.getMessage()};
            throw new XMLSignatureException("algorithms.NoSuchAlgorithm", objectArray, classNotFoundException);
        }
        catch (IllegalAccessException illegalAccessException) {
            Object[] objectArray = new Object[]{string2, illegalAccessException.getMessage()};
            throw new XMLSignatureException("algorithms.NoSuchAlgorithm", objectArray, illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            Object[] objectArray = new Object[]{string2, instantiationException.getMessage()};
            throw new XMLSignatureException("algorithms.NoSuchAlgorithm", objectArray, instantiationException);
        }
        catch (NullPointerException nullPointerException) {
            Object[] objectArray = new Object[]{string2, ((Throwable)nullPointerException).getMessage()};
            throw new XMLSignatureException("algorithms.NoSuchAlgorithm", objectArray, nullPointerException);
        }
    }

    public byte[] sign() throws XMLSignatureException {
        return this._signatureAlgorithm.engineSign();
    }

    public String getJCEAlgorithmString() {
        return this._signatureAlgorithm.engineGetJCEAlgorithmString();
    }

    public String getJCEProviderName() {
        return this._signatureAlgorithm.engineGetJCEProviderName();
    }

    public void update(byte[] byArray) throws XMLSignatureException {
        this._signatureAlgorithm.engineUpdate(byArray);
    }

    public void update(byte by) throws XMLSignatureException {
        this._signatureAlgorithm.engineUpdate(by);
    }

    public void update(byte[] byArray, int n, int n2) throws XMLSignatureException {
        this._signatureAlgorithm.engineUpdate(byArray, n, n2);
    }

    public void initSign(PrivateKey privateKey, SecureRandom secureRandom) throws XMLSignatureException {
        this._signatureAlgorithm.engineInitSign(privateKey, secureRandom);
    }

    public void initSign(PrivateKey privateKey) throws XMLSignatureException {
        this._signatureAlgorithm.engineInitSign(privateKey);
    }

    public void initSign(Key key) throws XMLSignatureException {
        this._signatureAlgorithm.engineInitSign(key);
    }

    public void initSign(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws XMLSignatureException {
        this._signatureAlgorithm.engineInitSign(key, algorithmParameterSpec);
    }

    public void setParameter(AlgorithmParameterSpec algorithmParameterSpec) throws XMLSignatureException {
        this._signatureAlgorithm.engineSetParameter(algorithmParameterSpec);
    }

    public void initVerify(PublicKey publicKey) throws XMLSignatureException {
        this._signatureAlgorithm.engineInitVerify(publicKey);
    }

    public void initVerify(Key key) throws XMLSignatureException {
        if (key instanceof PublicKey) {
            this.initVerify((PublicKey)key);
        } else {
            this._signatureAlgorithm.engineInitVerify(key);
        }
    }

    public boolean verify(byte[] byArray) throws XMLSignatureException {
        return this._signatureAlgorithm.engineVerify(byArray);
    }

    public final String getURI() {
        return this._constructionElement.getAttributeNS(null, "Algorithm");
    }

    public static void providerInit() {
        if (cat == null) {
            cat = Category.getInstance((String)(class$org$apache$xml$security$algorithms$SignatureAlgorithm == null ? (class$org$apache$xml$security$algorithms$SignatureAlgorithm = SignatureAlgorithm.class$("org.apache.xml.security.algorithms.SignatureAlgorithm")) : class$org$apache$xml$security$algorithms$SignatureAlgorithm).getName());
        }
        cat.debug((Object)"Init() called");
        if (!_alreadyInitialized) {
            _algorithmHash = new HashMap(10);
            _alreadyInitialized = true;
        }
    }

    public static void register(String string, String string2) throws AlgorithmAlreadyRegisteredException {
        cat.debug((Object)("Try to register " + string + " " + string2));
        String string3 = SignatureAlgorithm.getImplementingClass(string);
        if (string3 != null && string3.length() != 0) {
            Object[] objectArray = new Object[]{string, string3};
            throw new AlgorithmAlreadyRegisteredException("algorithm.alreadyRegistered", objectArray);
        }
        _algorithmHash.put(string, string2);
    }

    private static String getImplementingClass(String string) {
        if (_algorithmHash == null) {
            return null;
        }
        return (String)_algorithmHash.get(string);
    }

    public String getBaseNamespace() {
        return "http://www.w3.org/2000/09/xmldsig#";
    }

    public String getBaseLocalName() {
        return "SignatureMethod";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

