/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.algorithms.encryption.helper;

import java.security.InvalidKeyException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.ShortBufferException;
import org.apache.xml.security.algorithms.encryption.helper.InvalidCipherTextException;
import org.apache.xml.security.exceptions.XMLSecurityException;

public class AESWrapper {
    static final byte[] DEFAULT_IV = new byte[]{-90, -90, -90, -90, -90, -90, -90, -90};
    Cipher _cipher;

    public AESWrapper(Cipher cipher) {
        this._cipher = cipher;
    }

    public byte[] wrap(Key key, Key key2, byte[] byArray) throws XMLSecurityException {
        try {
            byte[] byArray2 = key.getEncoded();
            if (byArray == null) {
                byArray = new byte[DEFAULT_IV.length];
                System.arraycopy(DEFAULT_IV, 0, byArray, 0, DEFAULT_IV.length);
            }
            if (byArray.length != 8) {
                throw new XMLSecurityException("empty");
            }
            int n = byArray2.length;
            int n2 = n / 8;
            if (byArray2.length % 8 != 0) {
                throw new XMLSecurityException("wrap data must be a multiple of 8 bytes");
            }
            byte[] byArray3 = new byte[byArray2.length + byArray.length];
            byte[] byArray4 = new byte[8 + byArray.length];
            System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
            System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
            this._cipher.init(1, key2);
            int n3 = 0;
            while (n3 != 6) {
                int n4 = 1;
                while (n4 <= n2) {
                    System.arraycopy(byArray3, 0, byArray4, 0, byArray.length);
                    System.arraycopy(byArray3, 8 * n4, byArray4, byArray.length, 8);
                    this._cipher.update(byArray4, 0, byArray4.length, byArray4, 0);
                    int n5 = n2 * n3 + n4;
                    int n6 = 1;
                    while (n5 != 0) {
                        byte by = (byte)n5;
                        int n7 = byArray.length - n6;
                        byArray4[n7] = (byte)(byArray4[n7] ^ by);
                        n5 >>>= 8;
                        ++n6;
                    }
                    System.arraycopy(byArray4, 0, byArray3, 0, 8);
                    System.arraycopy(byArray4, 8, byArray3, 8 * n4, 8);
                    ++n4;
                }
                ++n3;
            }
            return byArray3;
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new XMLSecurityException("empty", invalidKeyException);
        }
        catch (ShortBufferException shortBufferException) {
            throw new XMLSecurityException("empty", shortBufferException);
        }
    }

    public byte[] unwrap(byte[] byArray, Key key) throws InvalidCipherTextException, XMLSecurityException {
        try {
            int n;
            int n2 = byArray.length / 8;
            if (n2 * 8 != byArray.length) {
                throw new InvalidCipherTextException("unwrap data must be a multiple of 8 bytes");
            }
            byte[] byArray2 = new byte[DEFAULT_IV.length];
            byte[] byArray3 = new byte[byArray.length - byArray2.length];
            byte[] byArray4 = new byte[8 + byArray2.length];
            System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
            System.arraycopy(byArray, byArray2.length, byArray3, 0, byArray.length - byArray2.length);
            this._cipher.init(2, key);
            --n2;
            int n3 = 5;
            while (n3 >= 0) {
                n = n2;
                while (n >= 1) {
                    System.arraycopy(byArray2, 0, byArray4, 0, byArray2.length);
                    System.arraycopy(byArray3, 8 * (n - 1), byArray4, byArray2.length, 8);
                    int n4 = n2 * n3 + n;
                    int n5 = 1;
                    while (n4 != 0) {
                        byte by = (byte)n4;
                        int n6 = byArray2.length - n5;
                        byArray4[n6] = (byte)(byArray4[n6] ^ by);
                        n4 >>>= 8;
                        ++n5;
                    }
                    this._cipher.update(byArray4, 0, byArray4.length, byArray4, 0);
                    System.arraycopy(byArray4, 0, byArray2, 0, 8);
                    System.arraycopy(byArray4, 8, byArray3, 8 * (n - 1), 8);
                    --n;
                }
                --n3;
            }
            n = 0;
            while (n != byArray2.length) {
                if (byArray2[n] != DEFAULT_IV[n]) {
                    throw new InvalidCipherTextException("checksum failed");
                }
                ++n;
            }
            return byArray3;
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new XMLSecurityException("empty", invalidKeyException);
        }
        catch (ShortBufferException shortBufferException) {
            throw new XMLSecurityException("empty", shortBufferException);
        }
    }
}

