/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.algorithms.encryption.helper;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import org.apache.xml.security.algorithms.encryption.helper.InvalidCipherTextException;

public class PKCS15Cipher {
    private static int HEADER_LENGTH = 10;
    Cipher _cipher;
    int _cipherMode;
    SecureRandom _secureRandom;

    public PKCS15Cipher(Cipher cipher) {
        this._cipher = cipher;
    }

    public void init(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        this._cipherMode = n;
        this._secureRandom = secureRandom;
        this._cipher.init(this._cipherMode, key, this._secureRandom);
    }

    public int getInputBlockSize() {
        int n = this._cipher.getBlockSize();
        if (this._cipherMode == 1) {
            return n - HEADER_LENGTH;
        }
        return n;
    }

    public int getOutputBlockSize() {
        int n = this._cipher.getBlockSize();
        if (this._cipherMode == 1) {
            return n;
        }
        return n - HEADER_LENGTH - 1;
    }

    public byte[] processBlock(byte[] byArray, int n, int n2) throws InvalidCipherTextException, IllegalBlockSizeException, BadPaddingException {
        if (this._cipherMode == 1) {
            return this.encodeBlock(byArray, n, n2);
        }
        if (this._cipherMode == 2) {
            return this.decodeBlock(byArray, n, n2);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public byte[] encodeBlock(byte[] var1_1, int var2_2, int var3_3) throws InvalidCipherTextException, IllegalBlockSizeException, BadPaddingException {
        var4_4 = new byte[this.getInputBlockSize()];
        this._secureRandom.nextBytes(var4_4);
        var4_4[0] = 2;
        var5_5 = 1;
        ** GOTO lbl10
        {
            var4_4[var5_5] = (byte)this._secureRandom.nextInt();
            do {
                if (var4_4[var5_5] == 0) continue block0;
                ++var5_5;
lbl10:
                // 2 sources

            } while (var5_5 != var4_4.length - var3_3 - 1);
        }
        var4_4[var4_4.length - var3_3 - 1] = 0;
        System.arraycopy(var1_1, var2_2, var4_4, var4_4.length - var3_3, var3_3);
        return this._cipher.doFinal(var4_4, 0, var4_4.length);
    }

    public byte[] decodeBlock(byte[] byArray, int n, int n2) throws InvalidCipherTextException, IllegalBlockSizeException, BadPaddingException {
        byte[] byArray2 = this._cipher.doFinal(byArray, n, n2);
        if (byArray2.length < this.getOutputBlockSize()) {
            throw new InvalidCipherTextException("encryption.RSAPKCS15.blockTruncated");
        }
        if (byArray2[0] != 2) {
            throw new InvalidCipherTextException("encryption.RSAPKCS15.unknownBlockType");
        }
        int n3 = 1;
        while (n3 != byArray2.length) {
            if (byArray2[n3] == 0) break;
            ++n3;
        }
        if (++n3 >= byArray2.length || n3 < HEADER_LENGTH) {
            throw new InvalidCipherTextException("encryption.RSAPKCS15.noDataInBlock");
        }
        byte[] byArray3 = new byte[byArray2.length - n3];
        System.arraycopy(byArray2, n3, byArray3, 0, byArray3.length);
        return byArray3;
    }
}

