/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.algorithms.encryption.implementations.BC;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import org.apache.xml.security.algorithms.JCEMapper;
import org.apache.xml.security.algorithms.encryption.EncryptionMethodSpi;
import org.apache.xml.security.algorithms.encryption.params.EncryptionMethodParams;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.utils.PRNG;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class BlockEncryptionImpl
extends EncryptionMethodSpi {
    Cipher _cipher;
    public static final boolean ENCRYPT_IV_IN_ECB = false;

    public abstract String getRequiredProviderName();

    public abstract String getImplementedAlgorithmURI();

    public int getImplementedAlgorithmType() {
        return 1;
    }

    public int engineGetBlockSize() {
        try {
            Cipher cipher = Cipher.getInstance(this.getImplementedAlgorithmJCE(), this.getRequiredProviderName());
            return cipher.getBlockSize();
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public abstract int engineGetIvLength();

    public EncryptionMethodParams engineInit(Document document, EncryptionMethodParams encryptionMethodParams) throws XMLSecurityException {
        if (encryptionMethodParams != null) {
            throw new XMLSecurityException("encryption.algorithmCannotEatInitParams");
        }
        try {
            this._cipher = Cipher.getInstance(this.getImplementedAlgorithmJCE(), this.getRequiredProviderName());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new XMLSecurityException("empty", noSuchAlgorithmException);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new XMLSecurityException("empty", noSuchProviderException);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new XMLSecurityException("empty", noSuchPaddingException);
        }
        return encryptionMethodParams;
    }

    public EncryptionMethodParams engineInit(Element element) throws XMLSecurityException {
        if (element.getChildNodes().getLength() != 0) {
            throw new XMLSecurityException("encryption.algorithmCannotEatInitParams");
        }
        try {
            this._cipher = Cipher.getInstance(this.getImplementedAlgorithmJCE(), this.getRequiredProviderName());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new XMLSecurityException("empty", noSuchAlgorithmException);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new XMLSecurityException("empty", noSuchProviderException);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new XMLSecurityException("empty", noSuchPaddingException);
        }
        return null;
    }

    public byte[] engineWrap(Key key, Key key2) throws XMLSecurityException {
        throw new XMLSecurityException("encryption.algorithmCannotWrapUnWrap");
    }

    public byte[] engineWrap(Key key, Key key2, byte[] byArray) throws XMLSecurityException {
        throw new XMLSecurityException("encryption.algorithmCannotWrapUnWrap");
    }

    public Key engineUnwrap(byte[] byArray, Key key, String string) throws XMLSecurityException {
        throw new XMLSecurityException("encryption.algorithmCannotWrapUnWrap");
    }

    public byte[] engineEncrypt(byte[] byArray, Key key) throws XMLSecurityException {
        return this.engineEncrypt(byArray, key, null);
    }

    private String getImplementedIVAlgorithmJCE() {
        return JCEMapper.getJCEIVAlgorithmFromURI(this.getImplementedAlgorithmURI(), this.getRequiredProviderName());
    }

    public byte[] engineEncrypt(byte[] byArray, Key key, byte[] byArray2) throws XMLSecurityException {
        try {
            int n = this.engineGetIvLength();
            Cipher cipher = Cipher.getInstance(this.getImplementedAlgorithmJCE(), this.getRequiredProviderName());
            if (byArray2 == null) {
                byArray2 = PRNG.createBytes(n);
            }
            IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray2);
            cipher.init(1, key, ivParameterSpec);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length);
            byteArrayOutputStream.write(byArray2);
            byte[] byArray3 = cipher.update(byArray);
            if (byArray3 != null) {
                byteArrayOutputStream.write(byArray3);
            }
            if ((byArray3 = cipher.doFinal()) != null) {
                byteArrayOutputStream.write(byArray3);
            }
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new XMLSecurityException("empty", iOException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new XMLSecurityException("empty", noSuchAlgorithmException);
        }
        catch (BadPaddingException badPaddingException) {
            throw new XMLSecurityException("empty", badPaddingException);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new XMLSecurityException("empty", noSuchProviderException);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new XMLSecurityException("empty", noSuchPaddingException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new XMLSecurityException("empty", invalidKeyException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new XMLSecurityException("empty", invalidAlgorithmParameterException);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new XMLSecurityException("empty", illegalBlockSizeException);
        }
    }

    public byte[] engineDecrypt(byte[] byArray, Key key) throws XMLSecurityException {
        try {
            int n = this.engineGetIvLength();
            byte[] byArray2 = new byte[n];
            System.arraycopy(byArray, 0, byArray2, 0, n);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray2);
            this._cipher.init(2, key, ivParameterSpec);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length);
            byte[] byArray3 = this._cipher.update(byArray, n, byArray.length - n);
            if (byArray3 != null) {
                byteArrayOutputStream.write(byArray3);
            }
            if ((byArray3 = this._cipher.doFinal()) != null) {
                byteArrayOutputStream.write(byArray3);
            }
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new XMLSecurityException("empty", iOException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new XMLSecurityException("empty", invalidKeyException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new XMLSecurityException("empty", invalidAlgorithmParameterException);
        }
        catch (BadPaddingException badPaddingException) {
            throw new XMLSecurityException("empty", badPaddingException);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new XMLSecurityException("empty", illegalBlockSizeException);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new XMLSecurityException("empty", noSuchPaddingException);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new XMLSecurityException("empty", noSuchProviderException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new XMLSecurityException("empty", noSuchAlgorithmException);
        }
    }
}

