/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.algorithms.encryption.implementations.BC;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.apache.xml.security.algorithms.JCEMapper;
import org.apache.xml.security.algorithms.MessageDigestAlgorithm;
import org.apache.xml.security.algorithms.encryption.helper.OAEPCipher;
import org.apache.xml.security.algorithms.encryption.implementations.BC.KeyTransportImpl;
import org.apache.xml.security.algorithms.encryption.params.EncryptionMethodParams;
import org.apache.xml.security.algorithms.encryption.params.OAEPParams;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.utils.PRNG;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class KeyTransportImpl_RSAOAEP_BC
extends KeyTransportImpl {
    OAEPParams _params = null;
    OAEPCipher _cipher = null;

    public int engineGetIvLength() {
        return -1;
    }

    public String getImplementedAlgorithmURI() {
        return "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p";
    }

    public int engineGetBlockSize() {
        if (this._cipher != null) {
            return this._cipher.getInputBlockSize();
        }
        return 0;
    }

    public EncryptionMethodParams engineInit(Document document, EncryptionMethodParams encryptionMethodParams) throws XMLSecurityException {
        this._doc = document;
        if (encryptionMethodParams == null) {
            this._params = new OAEPParams(null, null);
        } else if (encryptionMethodParams instanceof OAEPParams) {
            this._params = (OAEPParams)encryptionMethodParams;
        } else {
            throw new XMLSecurityException("empty");
        }
        try {
            Cipher cipher = Cipher.getInstance(this.getImplementedAlgorithmJCE(), this.getRequiredProviderName());
            MessageDigestAlgorithm messageDigestAlgorithm = MessageDigestAlgorithm.getInstance(this._doc, this._params.getDigestMethodURI());
            MessageDigest messageDigest = messageDigestAlgorithm.getAlgorithm();
            this._cipher = new OAEPCipher(cipher, messageDigest, this._params.getOAEPParamBytes());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new XMLSecurityException("empty", noSuchAlgorithmException);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new XMLSecurityException("empty", noSuchProviderException);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new XMLSecurityException("empty", noSuchPaddingException);
        }
        return this._params;
    }

    public EncryptionMethodParams engineInit(Element element) throws XMLSecurityException {
        this._params = new OAEPParams(element);
        try {
            Cipher cipher = Cipher.getInstance(this.getImplementedAlgorithmJCE(), this.getRequiredProviderName());
            MessageDigestAlgorithm messageDigestAlgorithm = MessageDigestAlgorithm.getInstance(this._doc, this._params.getDigestMethodURI());
            MessageDigest messageDigest = messageDigestAlgorithm.getAlgorithm();
            this._cipher = new OAEPCipher(cipher, messageDigest, this._params.getOAEPParamBytes());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new XMLSecurityException("empty", noSuchAlgorithmException);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new XMLSecurityException("empty", noSuchProviderException);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new XMLSecurityException("empty", noSuchPaddingException);
        }
        return this._params;
    }

    public byte[] engineWrap(Key key, Key key2) throws XMLSecurityException {
        try {
            this._cipher.init(1, key2, PRNG.getInstance().getSecureRandom());
            byte[] byArray = key.getEncoded();
            return this._cipher.encodeBlock(byArray, 0, byArray.length);
        }
        catch (BadPaddingException badPaddingException) {
            throw new XMLSecurityException("empty", badPaddingException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new XMLSecurityException("empty", invalidKeyException);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new XMLSecurityException("empty", illegalBlockSizeException);
        }
    }

    public Key engineUnwrap(byte[] byArray, Key key, String string) throws XMLSecurityException {
        try {
            this._cipher.init(2, key, null);
            String string2 = JCEMapper.translateURItoJCEID(string, this.getRequiredProviderName()).getAlgorithmID();
            int n = JCEMapper.getKeyTypeFromURI(string);
            byte[] byArray2 = this._cipher.decodeBlock(byArray, 0, byArray.length);
            if (n == 3) {
                return new SecretKeySpec(byArray2, string2);
            }
            try {
                KeyFactory keyFactory = KeyFactory.getInstance(string2, this.getRequiredProviderName());
                if (n == 1) {
                    return keyFactory.generatePublic(new X509EncodedKeySpec(byArray2));
                }
                if (n == 2) {
                    return keyFactory.generatePrivate(new PKCS8EncodedKeySpec(byArray2));
                }
            }
            catch (NoSuchProviderException noSuchProviderException) {
                throw new InvalidKeyException("Unknown key type " + noSuchProviderException.getMessage());
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new InvalidKeyException("Unknown key type " + noSuchAlgorithmException.getMessage());
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
                throw new InvalidKeyException("Unknown key type " + invalidKeySpecException.getMessage());
            }
            throw new InvalidKeyException("Unknown key type " + n);
        }
        catch (BadPaddingException badPaddingException) {
            throw new XMLSecurityException("empty", badPaddingException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new XMLSecurityException("empty", invalidKeyException);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new XMLSecurityException("empty", illegalBlockSizeException);
        }
    }
}

