/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.algorithms.implementations;

import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import org.apache.log4j.Category;
import org.apache.xml.security.algorithms.JCEMapper;
import org.apache.xml.security.algorithms.SignatureAlgorithmSpi;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.utils.Base64;

public class SignatureDSA
extends SignatureAlgorithmSpi {
    static Category cat = Category.getInstance((String)(class$org$apache$xml$security$algorithms$implementations$SignatureDSA == null ? (class$org$apache$xml$security$algorithms$implementations$SignatureDSA = SignatureDSA.class$("org.apache.xml.security.algorithms.implementations.SignatureDSA")) : class$org$apache$xml$security$algorithms$implementations$SignatureDSA).getName());
    public static final String _URI = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
    private Signature _signatureAlgorithm = null;
    static /* synthetic */ Class class$org$apache$xml$security$algorithms$implementations$SignatureDSA;

    protected String engineGetURI() {
        return _URI;
    }

    public SignatureDSA() throws XMLSignatureException {
        JCEMapper.ProviderIdClass providerIdClass = JCEMapper.translateURItoJCEID(_URI);
        cat.debug((Object)("Created SignatureDSA using " + providerIdClass.getAlgorithmID() + " " + providerIdClass.getProviderId()));
        try {
            this._signatureAlgorithm = Signature.getInstance(providerIdClass.getAlgorithmID(), providerIdClass.getProviderId());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Object[] objectArray = new Object[]{providerIdClass.getAlgorithmID(), noSuchAlgorithmException.getLocalizedMessage()};
            throw new XMLSignatureException("algorithms.NoSuchAlgorithm", objectArray);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            Object[] objectArray = new Object[]{providerIdClass.getProviderId(), noSuchProviderException.getLocalizedMessage()};
            throw new XMLSignatureException("algorithms.NoSuchProvider", objectArray);
        }
    }

    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws XMLSignatureException {
        try {
            this._signatureAlgorithm.setParameter(algorithmParameterSpec);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new XMLSignatureException("empty", invalidAlgorithmParameterException);
        }
    }

    protected boolean engineVerify(byte[] byArray) throws XMLSignatureException {
        try {
            cat.debug((Object)("Called DSA.verify() on " + Base64.encode(byArray)));
            byte[] byArray2 = SignatureDSA.convertXMLDSIGtoASN1(byArray);
            return this._signatureAlgorithm.verify(byArray2);
        }
        catch (SignatureException signatureException) {
            throw new XMLSignatureException("empty", signatureException);
        }
        catch (IOException iOException) {
            throw new XMLSignatureException("empty", iOException);
        }
    }

    protected void engineInitVerify(PublicKey publicKey) throws XMLSignatureException {
        try {
            this._signatureAlgorithm.initVerify(publicKey);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new XMLSignatureException("empty", invalidKeyException);
        }
    }

    protected byte[] engineSign() throws XMLSignatureException {
        try {
            byte[] byArray = this._signatureAlgorithm.sign();
            return SignatureDSA.convertASN1toXMLDSIG(byArray);
        }
        catch (IOException iOException) {
            throw new XMLSignatureException("empty", iOException);
        }
        catch (SignatureException signatureException) {
            throw new XMLSignatureException("empty", signatureException);
        }
    }

    protected void engineInitSign(PrivateKey privateKey, SecureRandom secureRandom) throws XMLSignatureException {
        try {
            this._signatureAlgorithm.initSign(privateKey, secureRandom);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new XMLSignatureException("empty", invalidKeyException);
        }
    }

    protected void engineInitSign(PrivateKey privateKey) throws XMLSignatureException {
        try {
            this._signatureAlgorithm.initSign(privateKey);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new XMLSignatureException("empty", invalidKeyException);
        }
    }

    protected void engineUpdate(byte[] byArray) throws XMLSignatureException {
        try {
            this._signatureAlgorithm.update(byArray);
        }
        catch (SignatureException signatureException) {
            throw new XMLSignatureException("empty", signatureException);
        }
    }

    protected void engineUpdate(byte by) throws XMLSignatureException {
        try {
            this._signatureAlgorithm.update(by);
        }
        catch (SignatureException signatureException) {
            throw new XMLSignatureException("empty", signatureException);
        }
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) throws XMLSignatureException {
        try {
            this._signatureAlgorithm.update(byArray, n, n2);
        }
        catch (SignatureException signatureException) {
            throw new XMLSignatureException("empty", signatureException);
        }
    }

    protected String engineGetJCEAlgorithmString() {
        return this._signatureAlgorithm.getAlgorithm();
    }

    protected String engineGetJCEProviderName() {
        return this._signatureAlgorithm.getProvider().getName();
    }

    private static byte[] convertASN1toXMLDSIG(byte[] byArray) throws IOException {
        int n;
        int n2;
        int n3 = n2 = byArray[3];
        while (n3 > 0 && byArray[4 + n2 - n3] == 0) {
            --n3;
        }
        int n4 = n = byArray[5 + n2];
        while (n4 > 0 && byArray[6 + n2 + n - n4] == 0) {
            --n4;
        }
        if (byArray[0] != 48 || byArray[1] != byArray.length - 2 || byArray[2] != 2 || n3 > 20 || byArray[4 + n2] != 2 || n4 > 20) {
            throw new IOException("Invalid ASN.1 format of DSA signature");
        }
        byte[] byArray2 = new byte[40];
        System.arraycopy(byArray, 4 + n2 - n3, byArray2, 20 - n3, n3);
        System.arraycopy(byArray, 6 + n2 + n - n4, byArray2, 40 - n4, n4);
        return byArray2;
    }

    private static byte[] convertXMLDSIGtoASN1(byte[] byArray) throws IOException {
        if (byArray.length != 40) {
            throw new IOException("Invalid XMLDSIG format of DSA signature");
        }
        int n = 20;
        while (n > 0 && byArray[20 - n] == 0) {
            --n;
        }
        int n2 = n;
        if (byArray[20 - n] < 0) {
            ++n2;
        }
        int n3 = 20;
        while (n3 > 0 && byArray[40 - n3] == 0) {
            --n3;
        }
        int n4 = n3;
        if (byArray[40 - n3] < 0) {
            ++n4;
        }
        byte[] byArray2 = new byte[6 + n2 + n4];
        byArray2[0] = 48;
        byArray2[1] = (byte)(4 + n2 + n4);
        byArray2[2] = 2;
        byArray2[3] = (byte)n2;
        System.arraycopy(byArray, 20 - n, byArray2, 4 + n2 - n, n);
        byArray2[4 + n2] = 2;
        byArray2[5 + n2] = (byte)n4;
        System.arraycopy(byArray, 40 - n3, byArray2, 6 + n2 + n4 - n3, n3);
        return byArray2;
    }

    protected void engineSetHMACOutputLength(int n) throws XMLSignatureException {
        throw new XMLSignatureException("algorithms.HMACOutputLengthOnlyForHMAC");
    }

    protected void engineInitVerify(Key key) throws XMLSignatureException {
        throw new XMLSignatureException("algorithms.operationOnlyForMAC");
    }

    protected void engineInitSign(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws XMLSignatureException {
        throw new XMLSignatureException("algorithms.operationOnlyForMAC");
    }

    protected void engineInitSign(Key key) throws XMLSignatureException {
        throw new XMLSignatureException("algorithms.operationOnlyForMAC");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

