/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.c14n.implementations;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.CanonicalizerSpi;
import org.apache.xml.security.c14n.helper.C14nHelper;
import org.apache.xml.security.c14n.helper.NSAttrCompare;
import org.apache.xml.security.c14n.helper.NonNSAttrCompare;
import org.apache.xml.security.transforms.params.InclusiveNamespaces;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;

public abstract class Canonicalizer20010315Excl
extends CanonicalizerSpi {
    boolean _includeComments = false;
    Set _xpathNodeSet = null;
    Set _inclusiveNSSet = null;
    Document _doc = null;
    Element _documentElement = null;
    Node _rootNodeOfC14n = null;
    Writer _writer = null;
    private static final int NODE_BEFORE_DOCUMENT_ELEMENT = -1;
    private static final int NODE_NOT_BEFORE_OR_AFTER_DOCUMENT_ELEMENT = 0;
    private static final int NODE_AFTER_DOCUMENT_ELEMENT = 1;

    public Canonicalizer20010315Excl(boolean bl) {
        this._includeComments = bl;
    }

    public byte[] engineCanonicalizeSubTree(Node node) throws CanonicalizationException {
        return this.engineCanonicalizeSubTree(node, "");
    }

    public byte[] engineCanonicalizeSubTree(Node node, String string) throws CanonicalizationException {
        this._rootNodeOfC14n = node;
        this._doc = XMLUtils.getOwnerDocument(this._rootNodeOfC14n);
        this._documentElement = this._doc.getDocumentElement();
        try {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                this._writer = new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF8");
                this._inclusiveNSSet = InclusiveNamespaces.prefixStr2Set(string);
                Map map = this.getInscopeNamespaces(node);
                HashMap hashMap = new HashMap();
                this.canonicalizeSubTree(node, map, hashMap);
                this._writer.flush();
                this._writer.close();
                byte[] byArray = byteArrayOutputStream.toByteArray();
                Object var8_9 = null;
                this._xpathNodeSet = null;
                this._inclusiveNSSet = null;
                this._rootNodeOfC14n = null;
                this._doc = null;
                this._documentElement = null;
                this._writer = null;
                return byArray;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new CanonicalizationException("empty", unsupportedEncodingException);
            }
            catch (IOException iOException) {
                throw new CanonicalizationException("empty", iOException);
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this._xpathNodeSet = null;
            this._inclusiveNSSet = null;
            this._rootNodeOfC14n = null;
            this._doc = null;
            this._documentElement = null;
            this._writer = null;
            throw throwable;
        }
    }

    void canonicalizeSubTree(Node node, Map map, Map map2) throws CanonicalizationException, IOException {
        short s = node.getNodeType();
        switch (s) {
            default: {
                break;
            }
            case 2: 
            case 6: 
            case 11: 
            case 12: {
                throw new CanonicalizationException("empty");
            }
            case 9: {
                Node node2 = node.getFirstChild();
                while (node2 != null) {
                    this.canonicalizeSubTree(node2, map, map2);
                    node2 = node2.getNextSibling();
                }
                break;
            }
            case 8: {
                if (!this._includeComments) break;
                int n = Canonicalizer20010315Excl.getPositionRelativeToDocumentElement(node);
                if (n == 1) {
                    this._writer.write("\n");
                }
                this.outputCommentToWriter((Comment)node);
                if (n != -1) break;
                this._writer.write("\n");
                break;
            }
            case 7: {
                int n = Canonicalizer20010315Excl.getPositionRelativeToDocumentElement(node);
                if (n == 1) {
                    this._writer.write("\n");
                }
                this.outputPItoWriter((ProcessingInstruction)node);
                if (n != -1) break;
                this._writer.write("\n");
                break;
            }
            case 3: 
            case 4: {
                this.outputTextToWriter(node.getNodeValue());
                break;
            }
            case 1: {
                Element element = (Element)node;
                this._writer.write("<");
                this._writer.write(element.getTagName());
                List list = this.updateInscopeNamespacesAndReturnVisibleAttrs(element, map, map2);
                int n = 0;
                while (n < list.size()) {
                    this.outputAttrToWriter(((Attr)list.get(n)).getNodeName(), ((Attr)list.get(n)).getNodeValue());
                    ++n;
                }
                this._writer.write(">");
                Node node3 = node.getFirstChild();
                while (node3 != null) {
                    if (node3.getNodeType() == 1) {
                        this.canonicalizeSubTree(node3, new HashMap(map), new HashMap(map2));
                    } else {
                        this.canonicalizeSubTree(node3, map, map2);
                    }
                    node3 = node3.getNextSibling();
                }
                this._writer.write("</");
                this._writer.write(element.getTagName());
                this._writer.write(">");
            }
        }
    }

    List updateInscopeNamespacesAndReturnVisibleAttrs(Element element, Map map, Map map2) throws CanonicalizationException {
        String string;
        String string2;
        Object object;
        Vector<Object> vector = new Vector<Object>();
        Vector<Object> vector2 = new Vector<Object>();
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = namedNodeMap.getLength();
        int n2 = 0;
        while (n2 < n) {
            object = (Attr)namedNodeMap.item(n2);
            string2 = object.getNodeName();
            string = object.getValue();
            if (string2.equals("xmlns") && string.equals("")) {
                map.remove("xmlns");
            } else if (string2.startsWith("xmlns") && !string.equals("")) {
                map.put(string2, string);
            } else if (string2.startsWith("xml:")) {
                map.put(string2, string);
            } else {
                vector2.add(object);
            }
            ++n2;
        }
        if (map2.containsKey("xmlns") && !map.containsKey("xmlns")) {
            map2.remove("xmlns");
            object = this._doc.createAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns");
            object.setValue("");
            vector.add(object);
        }
        object = map.keySet().iterator();
        while (object.hasNext()) {
            Object[] objectArray;
            string2 = (String)object.next();
            string = (String)map.get(string2);
            if (!(!string2.startsWith("xml:") || map2.containsKey(string2) && map2.get(string2).equals(string))) {
                map2.put(string2, string);
                objectArray = this._doc.createAttributeNS("http://www.w3.org/XML/1998/namespace", string2);
                objectArray.setValue(string);
                vector2.add(objectArray);
                continue;
            }
            if (!this.utilizedOrIncluded(element, string2) || map2.containsKey(string2) && (!map2.containsKey(string2) || map2.get(string2).equals(string))) continue;
            if (C14nHelper.namespaceIsRelative(string)) {
                objectArray = new Object[]{element.getTagName(), string2, string};
                throw new CanonicalizationException("c14n.Canonicalizer.RelativeNamespace", objectArray);
            }
            map2.put(string2, string);
            objectArray = this._doc.createAttributeNS("http://www.w3.org/2000/xmlns/", string2);
            objectArray.setValue(string);
            vector.add(objectArray);
        }
        Collections.sort(vector, new NSAttrCompare());
        Collections.sort(vector2, new NonNSAttrCompare());
        vector.addAll(vector2);
        return vector;
    }

    Map getInscopeNamespaces(Node node) throws CanonicalizationException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (node.getNodeType() != 1) {
            return hashMap;
        }
        Element element = (Element)node;
        Node node2 = element.getParentNode();
        while (node2 != null && node2.getNodeType() == 1) {
            NamedNodeMap namedNodeMap = node2.getAttributes();
            int n = namedNodeMap.getLength();
            int n2 = 0;
            while (n2 < n) {
                Attr attr = (Attr)namedNodeMap.item(n2);
                String string = attr.getNodeName();
                String string2 = attr.getValue();
                if (string.equals("xmlns") && string2.equals("")) {
                    hashMap.remove(string);
                } else if (string.startsWith("xmlns") && !string2.equals("") && !hashMap.containsKey(string)) {
                    hashMap.put(string, string2);
                }
                ++n2;
            }
            node2 = node2.getParentNode();
        }
        return hashMap;
    }

    static int getPositionRelativeToDocumentElement(Node node) {
        if (node == null) {
            return 0;
        }
        Document document = node.getOwnerDocument();
        if (node.getParentNode() != document) {
            return 0;
        }
        Element element = document.getDocumentElement();
        if (element == null) {
            return 0;
        }
        if (element == node) {
            return 0;
        }
        Node node2 = node;
        while (node2 != null) {
            if (node2 == element) {
                return -1;
            }
            node2 = node2.getNextSibling();
        }
        return 1;
    }

    public byte[] engineCanonicalizeXPathNodeSet(Set set) throws CanonicalizationException {
        return this.engineCanonicalizeXPathNodeSet(set, "");
    }

    public byte[] engineCanonicalizeXPathNodeSet(Set set, String string) throws CanonicalizationException {
        this._xpathNodeSet = set;
        if (this._xpathNodeSet.size() == 0) {
            return new byte[0];
        }
        Object object = (Node)this._xpathNodeSet.iterator().next();
        this._doc = XMLUtils.getOwnerDocument((Node)object);
        this._documentElement = this._doc.getDocumentElement();
        try {
            try {
                object = new ByteArrayOutputStream();
                this._writer = new OutputStreamWriter((OutputStream)object, "UTF8");
                this._inclusiveNSSet = InclusiveNamespaces.prefixStr2Set(string);
                this.canonicalizeXPathNodeSet(this._doc, true, new EC14nCtx());
                this._writer.close();
                byte[] byArray = ((ByteArrayOutputStream)object).toByteArray();
                Object var6_7 = null;
                this._xpathNodeSet = null;
                this._inclusiveNSSet = null;
                this._rootNodeOfC14n = null;
                this._doc = null;
                this._documentElement = null;
                this._writer = null;
                return byArray;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new CanonicalizationException("empty", unsupportedEncodingException);
            }
            catch (IOException iOException) {
                throw new CanonicalizationException("empty", iOException);
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this._xpathNodeSet = null;
            this._inclusiveNSSet = null;
            this._rootNodeOfC14n = null;
            this._doc = null;
            this._documentElement = null;
            this._writer = null;
            throw throwable;
        }
    }

    void canonicalizeXPathNodeSet(Node node, boolean bl, EC14nCtx eC14nCtx) throws CanonicalizationException, IOException {
        short s = node.getNodeType();
        boolean bl2 = this._xpathNodeSet.contains(node);
        switch (s) {
            default: {
                break;
            }
            case 2: 
            case 6: 
            case 11: 
            case 12: {
                throw new CanonicalizationException("empty");
            }
            case 9: {
                Node node2 = node.getFirstChild();
                while (node2 != null) {
                    this.canonicalizeXPathNodeSet(node2, true, eC14nCtx);
                    node2 = node2.getNextSibling();
                }
                break;
            }
            case 8: {
                if (!this._includeComments || !this._xpathNodeSet.contains(node)) break;
                int n = Canonicalizer20010315Excl.getPositionRelativeToDocumentElement(node);
                if (n == 1) {
                    this._writer.write("\n");
                }
                this.outputCommentToWriter((Comment)node);
                if (n != -1) break;
                this._writer.write("\n");
                break;
            }
            case 7: {
                if (!this._xpathNodeSet.contains(node)) break;
                int n = Canonicalizer20010315Excl.getPositionRelativeToDocumentElement(node);
                if (n == 1) {
                    this._writer.write("\n");
                }
                this.outputPItoWriter((ProcessingInstruction)node);
                if (n != -1) break;
                this._writer.write("\n");
                break;
            }
            case 3: 
            case 4: {
                if (!this._xpathNodeSet.contains(node)) break;
                this.outputTextToWriter(node.getNodeValue());
                Node node3 = node.getNextSibling();
                while (node3 != null && (node3.getNodeType() == 3 || node3.getNodeType() == 4)) {
                    this.outputTextToWriter(node3.getNodeValue());
                    node3 = node3.getNextSibling();
                }
                break;
            }
            case 1: {
                Node node4;
                Element element = (Element)node;
                if (bl2) {
                    this._writer.write("<");
                    this._writer.write(element.getTagName());
                }
                List list = this.getAttrs(element, bl, eC14nCtx);
                int n = list.size();
                int n2 = 0;
                while (n2 < n) {
                    node4 = (Attr)list.get(n2);
                    this.outputAttrToWriter(node4.getNodeName(), node4.getNodeValue());
                    ++n2;
                }
                if (bl2) {
                    this._writer.write(">");
                }
                node4 = node.getFirstChild();
                while (node4 != null) {
                    if (node4.getNodeType() == 1) {
                        this.canonicalizeXPathNodeSet(node4, bl2, eC14nCtx.copy());
                    } else {
                        this.canonicalizeXPathNodeSet(node4, bl2, eC14nCtx);
                    }
                    node4 = node4.getNextSibling();
                }
                if (!bl2) break;
                this._writer.write("</");
                this._writer.write(element.getTagName());
                this._writer.write(">");
            }
        }
    }

    List getAttrs(Element element, boolean bl, EC14nCtx eC14nCtx) throws CanonicalizationException {
        Object object;
        Object object2;
        Object object3;
        HashSet<String> hashSet = new HashSet<String>();
        boolean bl2 = this._xpathNodeSet.contains(element);
        if (bl2 && element.getNamespaceURI() != null) {
            object3 = element.getPrefix();
            if (object3 == null) {
                hashSet.add("xmlns");
            } else {
                hashSet.add("xmlns:" + (String)object3);
            }
        }
        object3 = new Vector();
        Vector<Object> vector = new Vector<Object>();
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = namedNodeMap.getLength();
        int n2 = 0;
        while (n2 < n) {
            object2 = (Attr)namedNodeMap.item(n2);
            if (this._xpathNodeSet.contains(object2)) {
                String string = object2.getNamespaceURI();
                if (string != null && "http://www.w3.org/2000/xmlns/".equals(string)) {
                    object = object2.getValue();
                    if (C14nHelper.namespaceIsRelative((String)object)) {
                        Object[] objectArray = new Object[]{element.getTagName(), object2.getNodeName(), object};
                        throw new CanonicalizationException("c14n.Canonicalizer.RelativeNamespace", objectArray);
                    }
                    ((Vector)object3).add(object2);
                } else {
                    vector.add(object2);
                    object = object2.getPrefix();
                    if (object != null) {
                        hashSet.add("xmlns:" + (String)object);
                    }
                }
            }
            ++n2;
        }
        Collections.sort(object3, new NSAttrCompare());
        Collections.sort(vector, new NonNSAttrCompare());
        object2 = new Vector();
        int n3 = 0;
        while (n3 < ((Vector)object3).size()) {
            boolean bl3;
            object = (Attr)((Vector)object3).get(n3);
            String string = object.getNodeName();
            String string2 = object.getValue();
            if (string.equals("xmlns") && string2.equals("")) {
                bl3 = eC14nCtx.n.containsKey(string);
                if (bl3) {
                    eC14nCtx.n.remove(string);
                    ((Vector)object2).add(object);
                }
            } else {
                boolean bl4;
                bl3 = hashSet.contains(string) || this._inclusiveNSSet.contains(string);
                boolean bl5 = eC14nCtx.n.containsKey(string);
                boolean bl6 = bl4 = bl5 && !eC14nCtx.n.get(string).equals(string2);
                if (bl2 && bl3 && (!bl5 || bl4)) {
                    eC14nCtx.n.put(string, string2);
                    ((Vector)object2).add(object);
                }
            }
            ++n3;
        }
        ((Vector)object2).addAll(vector);
        return object2;
    }

    void outputAttrToWriter(String string, String string2) throws IOException {
        this._writer.write(" ");
        this._writer.write(string);
        this._writer.write("=\"");
        int n = string2.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string2.charAt(n2);
            switch (c) {
                case '&': {
                    this._writer.write("&amp;");
                    break;
                }
                case '<': {
                    this._writer.write("&lt;");
                    break;
                }
                case '\"': {
                    this._writer.write("&quot;");
                    break;
                }
                case '\t': {
                    this._writer.write("&#x9;");
                    break;
                }
                case '\n': {
                    this._writer.write("&#xA;");
                    break;
                }
                case '\r': {
                    this._writer.write("&#xD;");
                    break;
                }
                default: {
                    this._writer.write(c);
                }
            }
            ++n2;
        }
        this._writer.write("\"");
    }

    void outputPItoWriter(ProcessingInstruction processingInstruction) throws IOException {
        if (processingInstruction == null) {
            return;
        }
        this._writer.write("<?");
        String string = processingInstruction.getTarget();
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            switch (c) {
                case '\r': {
                    this._writer.write("&#xD;");
                    break;
                }
                default: {
                    this._writer.write(c);
                }
            }
            ++n2;
        }
        String string2 = processingInstruction.getData();
        n = string2.length();
        if (string2 != null && n > 0) {
            this._writer.write(" ");
            int n3 = 0;
            while (n3 < n) {
                char c = string2.charAt(n3);
                switch (c) {
                    case '\r': {
                        this._writer.write("&#xD;");
                        break;
                    }
                    default: {
                        this._writer.write(c);
                    }
                }
                ++n3;
            }
        }
        this._writer.write("?>");
    }

    void outputCommentToWriter(Comment comment) throws IOException {
        if (comment == null) {
            return;
        }
        this._writer.write("<!--");
        String string = comment.getData();
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            switch (c) {
                case '\r': {
                    this._writer.write("&#xD;");
                    break;
                }
                default: {
                    this._writer.write(c);
                }
            }
            ++n2;
        }
        this._writer.write("-->");
    }

    void outputTextToWriter(String string) throws IOException {
        if (string == null) {
            return;
        }
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            switch (c) {
                case '&': {
                    this._writer.write("&amp;");
                    break;
                }
                case '<': {
                    this._writer.write("&lt;");
                    break;
                }
                case '>': {
                    this._writer.write("&gt;");
                    break;
                }
                case '\r': {
                    this._writer.write("&#xD;");
                    break;
                }
                default: {
                    this._writer.write(c);
                }
            }
            ++n2;
        }
    }

    public boolean utilizedOrIncluded(Element element, String string) {
        if (this._inclusiveNSSet.contains(string)) {
            return true;
        }
        boolean bl = this.visiblyUtilized(element).contains(string);
        return bl;
    }

    public Set visiblyUtilized(Element element) {
        HashSet<String> hashSet;
        block11: {
            Object object;
            block10: {
                Object object2;
                hashSet = new HashSet<String>();
                if (this._xpathNodeSet != null) break block10;
                if (element.getNamespaceURI() != null) {
                    object2 = element.getPrefix();
                    if (object2 == null) {
                        hashSet.add("xmlns");
                    } else {
                        hashSet.add("xmlns:" + (String)object2);
                    }
                }
                object2 = element.getAttributes();
                int n = object2.getLength();
                int n2 = 0;
                while (n2 < n) {
                    String string;
                    Attr attr = (Attr)object2.item(n2);
                    if (attr.getNamespaceURI() != null && (string = attr.getPrefix()) != null && !string.equals("xml") && !string.equals("xmlns")) {
                        hashSet.add("xmlns:" + string);
                    }
                    ++n2;
                }
                break block11;
            }
            if (this._xpathNodeSet == null || !this._xpathNodeSet.contains(element)) break block11;
            if (element.getNamespaceURI() != null) {
                object = element.getPrefix();
                if (object == null || ((String)object).length() == 0) {
                    hashSet.add("xmlns");
                } else {
                    hashSet.add("xmlns:" + (String)object);
                }
            }
            object = element.getAttributes();
            int n = object.getLength();
            int n3 = 0;
            while (n3 < n) {
                String string;
                Attr attr = (Attr)object.item(n3);
                if (this._xpathNodeSet.contains(attr) && attr.getNamespaceURI() != null && (string = attr.getPrefix()) != null && !string.equals("xml") && !string.equals("xmlns")) {
                    hashSet.add("xmlns:" + string);
                }
                ++n3;
            }
        }
        return hashSet;
    }

    class EC14nCtx {
        Map n;

        public EC14nCtx() {
            this.n = new HashMap();
        }

        public EC14nCtx(Map map) {
            this.n = map;
        }

        public EC14nCtx copy() {
            EC14nCtx eC14nCtx = new EC14nCtx();
            eC14nCtx.n = new HashMap(this.n);
            return eC14nCtx;
        }
    }
}

