/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.keys;

import java.io.PrintStream;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.keys.content.KeyName;
import org.apache.xml.security.keys.content.KeyValue;
import org.apache.xml.security.keys.content.MgmtData;
import org.apache.xml.security.keys.content.X509Data;

public class KeyUtils {
    private KeyUtils() {
    }

    public static void prinoutKeyInfo(KeyInfo keyInfo, PrintStream printStream) throws NoSuchAlgorithmException, InvalidKeySpecException, XMLSecurityException {
        Object object;
        int n = 0;
        while (n < keyInfo.lengthKeyName()) {
            KeyName keyName = keyInfo.itemKeyName(n);
            printStream.println("KeyName(" + n + ")=\"" + keyName.getKeyName() + "\"");
            ++n;
        }
        int n2 = 0;
        while (n2 < keyInfo.lengthKeyValue()) {
            KeyValue keyValue = keyInfo.itemKeyValue(n2);
            object = keyValue.getPublicKey();
            printStream.println("KeyValue Nr. " + n2);
            printStream.println(object);
            ++n2;
        }
        int n3 = 0;
        while (n3 < keyInfo.lengthMgmtData()) {
            object = keyInfo.itemMgmtData(n3);
            printStream.println("MgmtData(" + n3 + ")=\"" + ((MgmtData)object).getMgmtData() + "\"");
            ++n3;
        }
        int n4 = 0;
        while (n4 < keyInfo.lengthX509Data()) {
            X509Data x509Data = keyInfo.itemX509Data(n4);
            printStream.println("X509Data(" + n4 + ")=\"" + (x509Data.containsCertificate() ? "Certificate " : "") + (x509Data.containsIssuerSerial() ? "IssuerSerial " : "") + "\"");
            ++n4;
        }
    }
}

