/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.keys.provider;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.provider.Alias;
import org.apache.xml.security.utils.ElementProxy;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class KeyBaseType
extends ElementProxy {
    static final String DATE_STR = "yyyy-MM-dd'T'HH:mm:ss'Z'";

    public KeyBaseType(Document document, String string) {
        super(document);
        Alias alias = new Alias(document, string);
        XMLUtils.addReturnToElement(this);
        this._constructionElement.appendChild(alias.getElement());
        XMLUtils.addReturnToElement(this);
        this.setDate(new Date(System.currentTimeMillis()));
    }

    public KeyBaseType(Element element, String string) throws XMLSecurityException {
        super(element, string);
    }

    public String getBaseNamespace() {
        return "http://xml.apache.org/security/#KeyStore";
    }

    public void setDate(Date date) {
        if (this._state == 0) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATE_STR);
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            String string = simpleDateFormat.format(date);
            this._constructionElement.setAttributeNS(null, "Date", string);
        }
    }

    public Date getDate() throws XMLSecurityException {
        try {
            String string = this._constructionElement.getAttributeNS(null, "Date");
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATE_STR);
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            return simpleDateFormat.parse(string.trim());
        }
        catch (ParseException parseException) {
            throw new XMLSecurityException("empty", parseException);
        }
    }

    public String getAlias() throws XMLSecurityException {
        Alias alias = new Alias(this.getChildElementLocalName(0, "http://xml.apache.org/security/#KeyStore", "Alias"), this._baseURI);
        return alias.getAlias();
    }
}

