/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.signature;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.apache.xml.security.c14n.implementations.Canonicalizer20010315OmitComments;
import org.apache.xml.security.utils.IgnoreAllErrorHandler;
import org.apache.xml.security.utils.JavaUtils;
import org.apache.xml.security.utils.XMLUtils;
import org.apache.xpath.CachedXPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLSignatureInput {
    InputStream _inputOctetStreamProxy = null;
    Set _inputNodeSet = null;
    CachedXPathAPI _cxpathAPI;
    private String _MIMEType = null;
    private String _SourceURI = null;

    public XMLSignatureInput(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        this._inputOctetStreamProxy = new ByteArrayInputStream(byArray2);
        this._cxpathAPI = new CachedXPathAPI();
    }

    public XMLSignatureInput(InputStream inputStream) throws IOException {
        this(JavaUtils.getBytesFromStream(inputStream));
        inputStream = null;
    }

    public XMLSignatureInput(String string) {
        this(string.getBytes());
    }

    public XMLSignatureInput(String string, String string2) throws UnsupportedEncodingException {
        this(string.getBytes(string2));
    }

    public XMLSignatureInput(Node node, CachedXPathAPI cachedXPathAPI) throws TransformerException {
        this._cxpathAPI = cachedXPathAPI;
        Document document = XMLUtils.getOwnerDocument(node);
        XMLUtils.circumventBug2650(document);
        NodeList nodeList = this._cxpathAPI.selectNodeList(node, "(.//. | .//@* | .//namespace::*)");
        this._inputNodeSet = XMLUtils.convertNodelistToSet(nodeList);
    }

    public XMLSignatureInput(Node node) throws TransformerException {
        this(node, new CachedXPathAPI());
    }

    public XMLSignatureInput(Set set, CachedXPathAPI cachedXPathAPI) {
        this._inputNodeSet = set;
        this._cxpathAPI = cachedXPathAPI;
    }

    public XMLSignatureInput(Set set) {
        this(set, new CachedXPathAPI());
    }

    public Set getNodeSet() throws ParserConfigurationException, IOException, SAXException, CanonicalizationException, InvalidCanonicalizerException {
        if (this.isNodeSet()) {
            return this._inputNodeSet;
        }
        if (this.isOctetStream()) {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(false);
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            try {
                documentBuilder.setErrorHandler(new IgnoreAllErrorHandler());
                Document document = documentBuilder.parse(this.getOctetStream());
                XMLUtils.circumventBug2650(document);
                NodeList nodeList = this._cxpathAPI.selectNodeList((Node)document, "(.//. | .//@* | .//namespace::*)");
                return XMLUtils.convertNodelistToSet(nodeList);
            }
            catch (TransformerException transformerException) {
                throw new CanonicalizationException("generic.EmptyMessage", transformerException);
            }
            catch (SAXException sAXException) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byteArrayOutputStream.write("<container>".getBytes());
                byteArrayOutputStream.write(this.getBytes());
                byteArrayOutputStream.write("</container>".getBytes());
                byte[] byArray = byteArrayOutputStream.toByteArray();
                Document document = documentBuilder.parse(new ByteArrayInputStream(byArray));
                XMLUtils.circumventBug2650(document);
                try {
                    NodeList nodeList = this._cxpathAPI.selectNodeList((Node)document, "(//. | //@* | //namespace::*)[not(self::node()=/) and not(self::node=/container)]");
                    return XMLUtils.convertNodelistToSet(nodeList);
                }
                catch (TransformerException transformerException) {
                    throw new CanonicalizationException("generic.EmptyMessage", transformerException);
                }
            }
        }
        throw new RuntimeException("getNodeSet() called but no input data present");
    }

    public InputStream getOctetStream() throws IOException, CanonicalizationException, InvalidCanonicalizerException {
        if (this.isOctetStream()) {
            this._inputOctetStreamProxy.reset();
            return this._inputOctetStreamProxy;
        }
        if (this.isNodeSet()) {
            Canonicalizer20010315OmitComments canonicalizer20010315OmitComments = new Canonicalizer20010315OmitComments();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            if (this._inputNodeSet.size() == 0) {
                return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            }
            try {
                Set set = this.getNodeSet();
                byte[] byArray = canonicalizer20010315OmitComments.engineCanonicalizeXPathNodeSet(set);
                byteArrayOutputStream.write(byArray);
                return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            }
            catch (SAXException sAXException) {
                throw new CanonicalizationException("empty", sAXException);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new CanonicalizationException("empty", parserConfigurationException);
            }
        }
        throw new RuntimeException("getOctetStream() called but no input data present");
    }

    public byte[] getBytes() throws IOException, CanonicalizationException, InvalidCanonicalizerException {
        InputStream inputStream = this.getOctetStream();
        int n = inputStream.available();
        byte[] byArray = new byte[n];
        inputStream.read(byArray);
        if (n != byArray.length) {
            throw new IOException("Not enough bytes read");
        }
        return byArray;
    }

    public boolean isNodeSet() {
        return this._inputOctetStreamProxy == null && this._inputNodeSet != null;
    }

    public boolean isOctetStream() {
        return this._inputOctetStreamProxy != null && this._inputNodeSet == null;
    }

    public boolean isInitialized() {
        return this.isOctetStream() || this.isNodeSet();
    }

    public String getMIMEType() {
        return this._MIMEType;
    }

    public void setMIMEType(String string) {
        this._MIMEType = string;
    }

    public String getSourceURI() {
        return this._SourceURI;
    }

    public void setSourceURI(String string) {
        this._SourceURI = string;
    }

    public CachedXPathAPI getCachedXPathAPI() {
        return this._cxpathAPI;
    }

    public String toString() {
        if (this.isNodeSet()) {
            try {
                return "XMLSignatureInput/NodeSet/" + this._inputNodeSet.size() + " nodes/" + this.getSourceURI();
            }
            catch (Exception exception) {
                return "XMLSignatureInput/NodeSet//" + this.getSourceURI();
            }
        }
        try {
            return "XMLSignatureInput/OctetStream/" + this.getBytes().length + " octets/" + this.getSourceURI();
        }
        catch (Exception exception) {
            return "XMLSignatureInput/OctetStream//" + this.getSourceURI();
        }
    }
}

