/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.utils;

import javax.xml.transform.TransformerException;
import org.apache.log4j.Category;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xml.security.utils.XMLUtils;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class IdResolver {
    static Category cat = Category.getInstance((String)(class$org$apache$xml$security$utils$IdResolver == null ? (class$org$apache$xml$security$utils$IdResolver = IdResolver.class$("org.apache.xml.security.utils.IdResolver")) : class$org$apache$xml$security$utils$IdResolver).getName());
    static /* synthetic */ Class class$org$apache$xml$security$utils$IdResolver;

    private IdResolver() {
    }

    public static void registerElementById(Element element, String string) {
        Document document = element.getOwnerDocument();
        ((DocumentImpl)document).putIdentifier(string, element);
    }

    public static void registerElementById(Element element, Attr attr) {
        IdResolver.registerElementById(element, attr.getNodeValue());
    }

    public static Element getElementById(Document document, String string) {
        Element element = null;
        element = IdResolver.getElementByIdType(document, string);
        if (element != null) {
            cat.debug((Object)("I could find an Element using the simple getElementById method: " + element.getTagName()));
            return element;
        }
        element = IdResolver.getElementByIdInDSNamespace(document, string);
        if (element != null) {
            cat.debug((Object)("I could find an Element using the advanced ds:Namespace searcher method: " + element.getTagName()));
            IdResolver.registerElementById(element, string);
            return element;
        }
        element = IdResolver.getElementByIdInXENCNamespace(document, string);
        if (element != null) {
            cat.debug((Object)("I could find an Element using the advanced xenc:Namespace searcher method: " + element.getTagName()));
            IdResolver.registerElementById(element, string);
            return element;
        }
        element = IdResolver.getElementByIdInSOAPSignatureNamespace(document, string);
        if (element != null) {
            cat.debug((Object)("I could find an Element using the advanced SOAP-SEC:id searcher method: " + element.getTagName()));
            IdResolver.registerElementById(element, string);
            return element;
        }
        element = IdResolver.getElementByIdInXKMSNamespace(document, string);
        if (element != null) {
            cat.debug((Object)("I could find an Element using the XKMS searcher method: " + element.getTagName()));
            IdResolver.registerElementById(element, string);
            return element;
        }
        element = IdResolver.getElementByIdUnsafeMatchByIdName(document, string);
        if (element != null) {
            cat.warn((Object)("I could find an Element using the totally stupid and insecure Id/ID/id searcher method: " + element.getTagName()));
            return element;
        }
        return null;
    }

    private static Element getElementByIdType(Document document, String string) {
        cat.debug((Object)("getElementByIdType() Search for ID " + string));
        return document.getElementById(string);
    }

    private static Element getElementByIdInDSNamespace(Document document, String string) {
        cat.debug((Object)("getElementByIdInDSNamespace() Search for ID " + string));
        try {
            Element element = XMLUtils.createDSctx(document, "ds", "http://www.w3.org/2000/09/xmldsig#");
            Element element2 = (Element)XPathAPI.selectSingleNode((Node)document, (String)("//ds:*[@Id='" + string + "']"), (Node)element);
            return element2;
        }
        catch (TransformerException transformerException) {
            cat.fatal((Object)"empty", (Throwable)transformerException);
            return null;
        }
    }

    private static Element getElementByIdInXENCNamespace(Document document, String string) {
        cat.debug((Object)("getElementByIdInXENCNamespace() Search for ID " + string));
        try {
            Element element = XMLUtils.createDSctx(document, "xenc", "http://www.w3.org/2001/04/xmlenc#");
            Element element2 = (Element)XPathAPI.selectSingleNode((Node)document, (String)("//xenc:*[@Id='" + string + "']"), (Node)element);
            return element2;
        }
        catch (TransformerException transformerException) {
            cat.fatal((Object)"empty", (Throwable)transformerException);
            return null;
        }
    }

    private static Element getElementByIdInSOAPSignatureNamespace(Document document, String string) {
        cat.debug((Object)("getElementByIdInSOAPSignatureNamespace() Search for ID " + string));
        try {
            Element element = XMLUtils.createDSctx(document, "SOAP-SEC", "http://schemas.xmlsoap.org/soap/security/2000-12");
            Element element2 = (Element)XPathAPI.selectSingleNode((Node)document, (String)("//*[@SOAP-SEC:id='" + string + "']"), (Node)element);
            return element2;
        }
        catch (TransformerException transformerException) {
            cat.fatal((Object)"empty", (Throwable)transformerException);
            return null;
        }
    }

    private static Element getElementByIdInXKMSNamespace(Document document, String string) {
        cat.debug((Object)("getElementByIdInXKMSNamespace() Search for ID " + string));
        try {
            Element element = XMLUtils.createDSctx(document, "xkms", "http://www.w3.org/2002/03/xkms#");
            String[] stringArray = new String[]{"ID", "OriginalRequestID", "RequestID", "ResponseID"};
            int n = 0;
            while (n < stringArray.length) {
                String string2 = stringArray[n];
                Element element2 = (Element)XPathAPI.selectSingleNode((Node)document, (String)("//xkms:*[@" + string2 + "='" + string + "']"), (Node)element);
                if (element2 != null) {
                    return element2;
                }
                ++n;
            }
            return null;
        }
        catch (TransformerException transformerException) {
            cat.fatal((Object)"empty", (Throwable)transformerException);
            return null;
        }
    }

    private static Element getElementByIdUnsafeMatchByIdName(Document document, String string) {
        cat.debug((Object)("getElementByIdUnsafeMatchByIdName() Search for ID " + string));
        try {
            Element element = (Element)XPathAPI.selectSingleNode((Node)document, (String)("//*[@Id='" + string + "']"));
            if (element != null) {
                return element;
            }
            Element element2 = (Element)XPathAPI.selectSingleNode((Node)document, (String)("//*[@ID='" + string + "']"));
            if (element2 != null) {
                return element2;
            }
            Element element3 = (Element)XPathAPI.selectSingleNode((Node)document, (String)("//*[@id='" + string + "']"));
            if (element3 != null) {
                return element3;
            }
        }
        catch (TransformerException transformerException) {
            cat.fatal((Object)"empty", (Throwable)transformerException);
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

