/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.io.IOException;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.BaseCharFilter;
import org.apache.lucene.analysis.CharStream;

public class PatternReplaceCharFilter
extends BaseCharFilter {
    private final Pattern pattern;
    private final String replacement;
    private final int maxBlockChars;
    private final String blockDelimiters;
    public static final int DEFAULT_MAX_BLOCK_CHARS = 10000;
    private LinkedList<Character> buffer;
    private int nextCharCounter;
    private char[] blockBuffer;
    private int blockBufferLength;
    private String replaceBlockBuffer;
    private int replaceBlockBufferOffset;

    public PatternReplaceCharFilter(Pattern pattern, String replacement, CharStream in) {
        this(pattern, replacement, 10000, null, in);
    }

    public PatternReplaceCharFilter(Pattern pattern, String replacement, int maxBlockChars, CharStream in) {
        this(pattern, replacement, maxBlockChars, null, in);
    }

    public PatternReplaceCharFilter(Pattern pattern, String replacement, String blockDelimiters, CharStream in) {
        this(pattern, replacement, 10000, blockDelimiters, in);
    }

    public PatternReplaceCharFilter(Pattern pattern, String replacement, int maxBlockChars, String blockDelimiters, CharStream in) {
        super(in);
        this.pattern = pattern;
        this.replacement = replacement;
        if (maxBlockChars < 1) {
            throw new IllegalArgumentException("maxBlockChars should be greater than 0, but it is " + maxBlockChars);
        }
        this.maxBlockChars = maxBlockChars;
        this.blockDelimiters = blockDelimiters;
        this.blockBuffer = new char[maxBlockChars];
    }

    private boolean prepareReplaceBlock() throws IOException {
        while (this.replaceBlockBuffer == null || this.replaceBlockBuffer.length() <= this.replaceBlockBufferOffset) {
            int c;
            this.blockBufferLength = 0;
            while ((c = this.nextChar()) != -1) {
                boolean foundDelimiter;
                this.blockBuffer[this.blockBufferLength++] = (char)c;
                boolean bl = foundDelimiter = this.blockDelimiters != null && this.blockDelimiters.length() > 0 && this.blockDelimiters.indexOf(c) >= 0;
                if (!foundDelimiter && this.blockBufferLength < this.maxBlockChars) continue;
                break;
            }
            if (this.blockBufferLength == 0) {
                return false;
            }
            this.replaceBlockBuffer = this.getReplaceBlock(this.blockBuffer, 0, this.blockBufferLength);
            this.replaceBlockBufferOffset = 0;
        }
        return true;
    }

    public int read() throws IOException {
        if (this.prepareReplaceBlock()) {
            return this.replaceBlockBuffer.charAt(this.replaceBlockBufferOffset++);
        }
        return -1;
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        int c;
        int i;
        char[] tmp = new char[len];
        int l = this.input.read(tmp, 0, len);
        if (l != -1) {
            for (i = 0; i < l; ++i) {
                this.pushLastChar(tmp[i]);
            }
        }
        l = 0;
        for (i = off; i < off + len && (c = this.read()) != -1; ++i) {
            cbuf[i] = (char)c;
            ++l;
        }
        return l == 0 ? -1 : l;
    }

    private int nextChar() throws IOException {
        if (this.buffer != null && !this.buffer.isEmpty()) {
            ++this.nextCharCounter;
            return this.buffer.removeFirst().charValue();
        }
        int c = this.input.read();
        if (c != -1) {
            ++this.nextCharCounter;
        }
        return c;
    }

    private void pushLastChar(int c) {
        if (this.buffer == null) {
            this.buffer = new LinkedList();
        }
        this.buffer.addLast(new Character((char)c));
    }

    String getReplaceBlock(String block) {
        char[] blockChars = block.toCharArray();
        return this.getReplaceBlock(blockChars, 0, blockChars.length);
    }

    String getReplaceBlock(char[] block, int offset, int length) {
        StringBuffer replaceBlock = new StringBuffer();
        String sourceBlock = new String(block, offset, length);
        Matcher m = this.pattern.matcher(sourceBlock);
        int lastMatchOffset = 0;
        int lastDiff = 0;
        while (m.find()) {
            m.appendReplacement(replaceBlock, this.replacement);
            int diff = replaceBlock.length() - lastMatchOffset - lastDiff - (m.end(0) - lastMatchOffset);
            if (diff != 0) {
                int prevCumulativeDiff = this.getLastCumulativeDiff();
                if (diff > 0) {
                    for (int i = 0; i < diff; ++i) {
                        this.addOffCorrectMap(this.nextCharCounter - length + m.end(0) + i - prevCumulativeDiff, prevCumulativeDiff - 1 - i);
                    }
                } else {
                    this.addOffCorrectMap(this.nextCharCounter - length + m.end(0) + diff - prevCumulativeDiff, prevCumulativeDiff - diff);
                }
            }
            lastMatchOffset = m.end(0);
            lastDiff = diff;
        }
        m.appendTail(replaceBlock);
        return replaceBlock.toString();
    }
}

