/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.indexer.parser.utility;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.lang.StringUtils;
import org.dataone.cn.indexer.parser.utility.LeafElement;
import org.dataone.cn.indexer.parser.utility.TemplateStringProcessor;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RootElement {
    private String name;
    private String xPath;
    private XPathExpression xPathExpression = null;
    private String delimiter = " ";
    private String template;
    private List<LeafElement> leafs = new ArrayList<LeafElement>();
    private List<RootElement> subRoots = new ArrayList<RootElement>();
    private TemplateStringProcessor templateProcessor = new TemplateStringProcessor();

    public List<String> getRootValues(Object docOrNode, boolean multipleValues) throws XPathExpressionException {
        NodeList nodeList = (NodeList)this.getxPathExpression().evaluate(docOrNode, XPathConstants.NODESET);
        ArrayList<String> resultValues = new ArrayList<String>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            HashMap<String, String> valueMap = new HashMap<String, String>();
            Node node = nodeList.item(i);
            for (LeafElement leaf : this.getLeafs()) {
                valueMap.put(leaf.getName(), leaf.getLeafValue(node));
            }
            for (RootElement subRoot : this.getSubRoots()) {
                List<String> subRootResults = subRoot.getRootValues(node, multipleValues);
                StringBuilder delimitedResult = new StringBuilder();
                for (String result : subRootResults) {
                    delimitedResult.append(result);
                    delimitedResult.append(subRoot.getDelimiter());
                }
                valueMap.put(subRoot.getName(), StringUtils.removeEnd((String)delimitedResult.toString(), (String)this.delimiter));
            }
            String templateResult = this.templateProcessor.process(this.getTemplate(), valueMap);
            resultValues.add(templateResult);
            if (!multipleValues) break;
        }
        return resultValues;
    }

    public void initXPathExpressions(XPath xPathObject) {
        try {
            if (this.xPathExpression == null) {
                this.xPathExpression = xPathObject.compile(this.xPath);
            }
            for (LeafElement leaf : this.leafs) {
                leaf.initXPathExpression(xPathObject);
            }
            for (RootElement subRoot : this.subRoots) {
                subRoot.initXPathExpressions(xPathObject);
            }
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getxPath() {
        return this.xPath;
    }

    public void setxPath(String xPath) {
        this.xPath = xPath;
    }

    public XPathExpression getxPathExpression() {
        return this.xPathExpression;
    }

    public void setxPathExpression(XPathExpression xPathExpression) {
        this.xPathExpression = xPathExpression;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public List<LeafElement> getLeafs() {
        return this.leafs;
    }

    public void setLeafs(List<LeafElement> leafs) {
        this.leafs = leafs;
    }

    public List<RootElement> getSubRoots() {
        return this.subRoots;
    }

    public void setSubRoots(List<RootElement> subRoots) {
        this.subRoots = subRoots;
    }
}

