/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lsid.client.conf;

import com.ibm.lsid.LSID;
import com.ibm.lsid.LSIDException;
import com.ibm.lsid.MalformedLSIDException;
import com.ibm.lsid.client.LSIDAuthority;
import com.ibm.lsid.client.cache.LSIDCache;
import com.ibm.lsid.client.cache.LSIDCacheException;
import com.ibm.lsid.client.conf.castor.AcceptedFormats;
import com.ibm.lsid.client.conf.castor.Caching;
import com.ibm.lsid.client.conf.castor.ForeignAuthorities;
import com.ibm.lsid.client.conf.castor.ForeignAuthoritiesItem;
import com.ibm.lsid.client.conf.castor.HostMapping;
import com.ibm.lsid.client.conf.castor.HostMappings;
import com.ibm.lsid.client.conf.castor.ImportMap;
import com.ibm.lsid.client.conf.castor.ImportMapChoice;
import com.ibm.lsid.client.conf.castor.Lsid;
import com.ibm.lsid.client.conf.castor.LsidClient;
import com.ibm.lsid.client.conf.castor.MetadataStore;
import com.ibm.lsid.client.conf.castor.MetadataStores;
import com.ibm.lsid.client.conf.castor.Param;
import com.ibm.lsid.client.conf.castor.Pattern;
import com.ibm.lsid.client.conf.castor.PortFactory;
import com.ibm.lsid.client.conf.castor.PortMap;
import com.ibm.lsid.client.conf.castor.WsdlExtensions;
import com.ibm.lsid.client.metadata.LSIDMetadataException;
import com.ibm.lsid.client.metadata.LSIDMetadataFactory;
import com.ibm.lsid.client.metadata.rdf.xslt.XSLTMetadataFactory;
import com.ibm.lsid.wsdl.LSIDPortFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import javax.wsdl.PortType;
import org.exolab.castor.xml.CastorException;
import org.exolab.castor.xml.Unmarshaller;

public class LSIDResolverConfig {
    public static final String LSID_CLIENT_HOME = "LSID_CLIENT_HOME";
    private static final String CONFIG_FILE_NAME = "lsid-client.xml";
    private static final String SCHEMA_FILE_NAME = "lsid-client.xsd";
    private static final String CREDENTIAL_FILE_NAME = "lsid-client.credentials";
    private static final String LSID_CLIENT_HOME_DEFAULT_WIN32 = "/lsid-client";
    private static final String LSID_CLIENT_HOME_DEFAULT_UNIX = ".lsid-client";
    private static final boolean USE_CACHE_DEFAULT = false;
    private static final String LSID_CACHE_DIR_DEFAULT = "/cache";
    private static final Hashtable DEFAULT_METADATA_FACTORIES = new Hashtable();
    private static final String[] DEFAULT_METADATA_FORMATS;
    private File lsidHome = null;
    private boolean useCache = false;
    private String lsidCacheDir = null;
    private LSIDCache cache = null;
    private String[] acceptedFormats = null;
    private Hashtable hostMappings = new Hashtable();
    private Hashtable metadataFactories = new Hashtable();
    private Hashtable foreignAuthorities = new Hashtable();
    private Hashtable portFactories = new Hashtable();
    private Hashtable importMaps = new Hashtable();
    static /* synthetic */ Class class$com$ibm$lsid$client$conf$castor$LsidClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public LSIDResolverConfig() {
        File file;
        String string = System.getProperty(LSID_CLIENT_HOME);
        if (string == null) {
            char c = File.separatorChar;
            string = c == '/' ? LSID_CLIENT_HOME_DEFAULT_UNIX : LSID_CLIENT_HOME_DEFAULT_WIN32;
            System.err.println("No LSID_CLIENT_HOME specified, using default: " + string);
        }
        this.lsidHome = new File(string);
        if (!this.lsidHome.exists()) {
            this.lsidHome.mkdirs();
        }
        if ((file = new File(this.lsidHome, CONFIG_FILE_NAME)).exists()) {
            FileReader fileReader = null;
            fileReader = new FileReader(file);
            LsidClient lsidClient = (LsidClient)Unmarshaller.unmarshal((Class)(class$com$ibm$lsid$client$conf$castor$LsidClient == null ? (class$com$ibm$lsid$client$conf$castor$LsidClient = LSIDResolverConfig.class$("com.ibm.lsid.client.conf.castor.LsidClient")) : class$com$ibm$lsid$client$conf$castor$LsidClient), (Reader)fileReader);
            this.loadConfig(lsidClient);
            Object var7_7 = null;
            if (fileReader == null) return;
            try {
                ((Reader)fileReader).close();
                return;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return;
            {
                catch (CastorException castorException) {
                    System.err.println("Castor Error loading config file, using default settings, exception trace follows");
                    castorException.printStackTrace();
                    this.loadConfig(null);
                    Object var7_8 = null;
                    if (fileReader == null) return;
                    try {
                        ((Reader)fileReader).close();
                        return;
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    return;
                }
                catch (IOException iOException) {
                    System.err.println("IO Error loading config file, using default settings, exception trace follows");
                    iOException.printStackTrace();
                    this.loadConfig(null);
                    Object var7_9 = null;
                    if (fileReader == null) return;
                    try {
                        ((Reader)fileReader).close();
                        return;
                    }
                    catch (IOException iOException2) {
                        iOException2.printStackTrace();
                    }
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                if (fileReader == null) throw throwable;
                try {
                    ((Reader)fileReader).close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                throw throwable;
            }
        }
        System.err.println("Config file: " + file + " does not exist, using default settings");
        this.loadConfig(null);
        this.writeDefaultConfig();
    }

    public LSIDCache getCache() {
        return this.cache;
    }

    public Hashtable getHostMappings() {
        return this.hostMappings;
    }

    public LSIDAuthority[] getForeignAuthorities(LSID lSID) {
        String[] stringArray = new String[]{lSID.toString(), lSID.getAuthority().toString() + ":" + lSID.getNamespace(), lSID.getAuthority().toString() + ":*", "*:" + lSID.getNamespace(), "*:*"};
        LSIDAuthority[] lSIDAuthorityArray = null;
        int n = 0;
        while (n < stringArray.length) {
            lSIDAuthorityArray = (LSIDAuthority[])this.foreignAuthorities.get(stringArray[n]);
            if (lSIDAuthorityArray != null) {
                return lSIDAuthorityArray;
            }
            ++n;
        }
        return null;
    }

    public File getLsidHome() {
        return this.lsidHome;
    }

    public String[] getAcceptedFormats() {
        if (this.acceptedFormats == null) {
            return DEFAULT_METADATA_FORMATS;
        }
        return this.acceptedFormats;
    }

    public LSIDMetadataFactory getMetadataFactory(String string) {
        LSIDMetadataFactory lSIDMetadataFactory = (LSIDMetadataFactory)this.metadataFactories.get(string);
        if (lSIDMetadataFactory == null) {
            lSIDMetadataFactory = (LSIDMetadataFactory)DEFAULT_METADATA_FACTORIES.get(string);
        }
        return lSIDMetadataFactory;
    }

    public LSIDPortFactory getLSIDPortFactory(PortType portType) throws LSIDException {
        String string = portType.getQName().getNamespaceURI() + ":" + portType.getQName().getLocalPart();
        Object v = this.portFactories.get(string);
        if (v == null) {
            return null;
        }
        if (v instanceof LSIDPortFactory) {
            return (LSIDPortFactory)v;
        }
        try {
            PortFactory portFactory = (PortFactory)v;
            LSIDPortFactory lSIDPortFactory = (LSIDPortFactory)Class.forName(portFactory.getClassname()).newInstance();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            int n = 0;
            while (n < portFactory.getParamCount()) {
                Param param = portFactory.getParam(n);
                hashMap.put(param.getName(), param.getValue());
                ++n;
            }
            lSIDPortFactory.init(hashMap);
            this.portFactories.put(string, lSIDPortFactory);
            return lSIDPortFactory;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new LSIDException(classNotFoundException, "Error loading lsid port factory for port: " + portType);
        }
        catch (InstantiationException instantiationException) {
            throw new LSIDException(instantiationException, "Error loading lsid port factory for port: " + portType);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new LSIDException(illegalAccessException, "Error loading lsid port factory for port: " + portType);
        }
    }

    public ImportMapChoice getImportMap(String string) {
        return (ImportMapChoice)this.importMaps.get(string);
    }

    public boolean useCache() {
        return this.useCache;
    }

    public void setUseCache(boolean bl) {
        if (this.useCache == bl) {
            return;
        }
        if (!bl) {
            this.useCache = false;
        } else {
            if (this.cache == null) {
                File file = null;
                String string = this.lsidCacheDir;
                file = string != null ? new File(string) : new File(this.lsidHome, LSID_CACHE_DIR_DEFAULT);
                try {
                    System.setProperty("LSID_CACHE_DIR", file.getCanonicalPath());
                }
                catch (IOException iOException) {
                    System.err.println("Error setting cache dir path: " + file + ", stack trace follows, will use default");
                    iOException.printStackTrace();
                }
                try {
                    this.cache = LSIDCache.load();
                }
                catch (LSIDCacheException lSIDCacheException) {
                    System.err.println("Error loading LSID Cache, will continue without caching, stack trace follows");
                    lSIDCacheException.printStackTrace();
                }
            }
            this.useCache = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDefaultConfig() {
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            inputStream = this.getClass().getResourceAsStream(CONFIG_FILE_NAME);
            if (inputStream == null) {
                System.err.println("Non fatal error: no default config exists in client installation");
                return;
            }
            outputStream = new FileOutputStream(new File(this.lsidHome, CONFIG_FILE_NAME));
            byte[] byArray = new byte[1024];
            int n = inputStream.read(byArray);
            while (n != -1) {
                outputStream.write(byArray, 0, n);
                n = inputStream.read(byArray);
            }
            outputStream.flush();
        }
        catch (IOException iOException) {
            System.err.println("No fatal error: could not write default config file, stack trace follows");
            iOException.printStackTrace();
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    private void loadConfig(LsidClient lsidClient) {
        block34: {
            this.useCache = false;
            File file = new File(this.lsidHome, LSID_CACHE_DIR_DEFAULT);
            if (lsidClient != null) {
                ForeignAuthorities foreignAuthorities;
                Object[] objectArray;
                Object object;
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                Object object6;
                Object object7;
                Object object8;
                Caching caching = lsidClient.getCaching();
                if (caching != null) {
                    object8 = caching.getUseCache();
                    if (object8 != null) {
                        this.useCache = new Boolean((String)object8);
                    }
                    if ((object7 = caching.getLsidCacheDir()) != null) {
                        file = new File((String)object7);
                    }
                }
                if ((object8 = lsidClient.getAcceptedFormats()) != null) {
                    this.acceptedFormats = ((AcceptedFormats)object8).getFormat();
                }
                if ((object7 = lsidClient.getMetadataStores()) != null) {
                    int n = ((MetadataStores)object7).getMetadataStoreCount();
                    int n2 = 0;
                    while (n2 < n) {
                        object6 = ((MetadataStores)object7).getMetadataStore(n2);
                        if (object6 != null) {
                            object5 = ((MetadataStore)object6).getMetadataFactory();
                            object4 = ((MetadataStore)object6).getFormat();
                            try {
                                object3 = (PortMap[])Class.forName((String)object5).newInstance();
                                object2 = new Hashtable();
                                object = ((MetadataStore)object6).getProperties().enumerateProperty();
                                while (object.hasMoreElements()) {
                                    objectArray = (LSIDAuthority[])object.nextElement();
                                    String string = objectArray.getName();
                                    String string2 = objectArray.getValue();
                                    ((Hashtable)object2).put(string, string2);
                                }
                                try {
                                    object3.setProperties((Hashtable)object2);
                                }
                                catch (LSIDMetadataException lSIDMetadataException) {
                                    System.err.println("Error setting properties on meta data factory, stack trace follows: " + lSIDMetadataException.getMessage());
                                    lSIDMetadataException.printStackTrace();
                                }
                                this.metadataFactories.put(object4, object3);
                            }
                            catch (Exception exception) {
                                System.err.println("Error instantiating class: " + (String)object5 + ", using default");
                                exception.printStackTrace();
                            }
                        }
                        ++n2;
                    }
                }
                this.hostMappings = new Hashtable();
                HostMappings hostMappings = lsidClient.getHostMappings();
                if (hostMappings != null) {
                    Enumeration enumeration = hostMappings.enumerateHostMapping();
                    while (enumeration.hasMoreElements()) {
                        object6 = (HostMapping)enumeration.nextElement();
                        object5 = ((HostMapping)object6).getAuthority();
                        object4 = ((HostMapping)object6).getEndpoint();
                        this.hostMappings.put(object5, object4);
                    }
                }
                if ((foreignAuthorities = lsidClient.getForeignAuthorities()) != null) {
                    object6 = foreignAuthorities.enumerateForeignAuthoritiesItem();
                    while (object6.hasMoreElements()) {
                        object5 = (ForeignAuthoritiesItem)object6.nextElement();
                        object4 = ((ForeignAuthoritiesItem)object5).enumerateLsid();
                        while (object4.hasMoreElements()) {
                            object3 = (Lsid)object4.nextElement();
                            object2 = null;
                            try {
                                object2 = new LSID(((Lsid)object3).getLsid());
                            }
                            catch (MalformedLSIDException malformedLSIDException) {
                                System.err.println("Bad lsid for foreign authority: " + ((Lsid)object3).getLsid() + ", ignoring");
                                malformedLSIDException.printStackTrace();
                                continue;
                            }
                            object = ((Lsid)object3).getAuthority();
                            objectArray = new LSIDAuthority[((String[])object).length];
                            int n = 0;
                            while (n < objectArray.length) {
                                try {
                                    objectArray[n] = new LSIDAuthority(object[n]);
                                }
                                catch (MalformedLSIDException malformedLSIDException) {
                                    System.err.println("Bad foreign authority: " + object[n] + ", ignoring");
                                    malformedLSIDException.printStackTrace();
                                }
                                ++n;
                            }
                            this.foreignAuthorities.put(((LSID)object2).toString(), objectArray);
                        }
                        object3 = ((ForeignAuthoritiesItem)object5).enumeratePattern();
                        while (object3.hasMoreElements()) {
                            object2 = (Pattern)object3.nextElement();
                            object = ((Pattern)object2).getAuth() + ":" + ((Pattern)object2).getNs();
                            objectArray = ((Pattern)object2).getAuthority();
                            LSIDAuthority[] lSIDAuthorityArray = new LSIDAuthority[objectArray.length];
                            int n = 0;
                            while (n < lSIDAuthorityArray.length) {
                                try {
                                    lSIDAuthorityArray[n] = new LSIDAuthority((String)objectArray[n]);
                                }
                                catch (MalformedLSIDException malformedLSIDException) {
                                    System.err.println("Bad foreign authority: " + (String)objectArray[n] + ", ignoring");
                                    malformedLSIDException.printStackTrace();
                                }
                                ++n;
                            }
                            this.foreignAuthorities.put(object, lSIDAuthorityArray);
                        }
                    }
                }
                if ((object6 = lsidClient.getWsdlExtensions()) != null) {
                    object5 = ((WsdlExtensions)object6).getImportMap();
                    int n = 0;
                    while (n < ((Object)object5).length) {
                        object3 = object5[n];
                        this.importMaps.put(((ImportMap)object3).getLocation(), ((ImportMap)object3).getImportMapChoice());
                        ++n;
                    }
                    object3 = ((WsdlExtensions)object6).getPortMap();
                    int n3 = 0;
                    while (n3 < ((Object)object3).length) {
                        object = object3[n3];
                        this.portFactories.put(object.getPortType(), object.getPortFactory());
                        ++n3;
                    }
                }
            }
            if (!this.useCache) break block34;
            try {
                System.setProperty("LSID_CACHE_DIR", file.getCanonicalPath());
            }
            catch (IOException iOException) {
                System.err.println("Error setting cache dir path: " + file + ", stack trace follows, will use default");
                iOException.printStackTrace();
            }
            try {
                this.cache = LSIDCache.load();
            }
            catch (LSIDCacheException lSIDCacheException) {
                System.err.println("Error loading LSID Cache, will continue without caching, stack trace follows");
                lSIDCacheException.printStackTrace();
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        DEFAULT_METADATA_FACTORIES.put("application/xml+rdf", new XSLTMetadataFactory());
        DEFAULT_METADATA_FORMATS = new String[]{"application/xml+rdf"};
    }
}

