/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lsid.client.testing;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.ibm.lsid.LSID;
import com.ibm.lsid.MalformedLSIDException;
import com.ibm.lsid.client.LSIDResolver;
import com.ibm.lsid.client.async.utils.WorkPool;
import com.ibm.lsid.wsdl.LSIDMetadataPort;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;

class Launcher {
    private static Map hitlist;
    private static int hits;
    private static int missed;
    private static Map misslist;
    protected static WorkPool pool;
    private LSID lsid;
    private static PrintWriter fout;
    private static PrintWriter ferr;
    private static PrintWriter fmiss;

    public Launcher(LSID lSID) {
        hitlist = Collections.synchronizedMap(new TreeMap());
        misslist = Collections.synchronizedMap(new TreeMap());
        pool = new WorkPool(10);
        this.lsid = lSID;
        try {
            fout = new PrintWriter(new BufferedWriter(new FileWriter("c:\\lsid\\temp\\crawler.txt", true)));
            ferr = new PrintWriter(new BufferedWriter(new FileWriter("c:\\lsid\\temp\\crawler-err.txt", true)));
            fmiss = new PrintWriter(new BufferedWriter(new FileWriter("c:\\lsid\\temp\\crawler-missed.txt", true)));
        }
        catch (IOException iOException) {
            System.err.println("could not open output file");
            System.exit(0);
        }
    }

    public void beginTest() {
        Resolver resolver = new Resolver(this.lsid, null);
        hitlist.put(this.lsid.toString(), "stress");
        pool.addJob(resolver);
    }

    public synchronized void writeError(String string) {
        ferr.println(string);
        ferr.flush();
    }

    public synchronized void writeStatus(String string) {
        fout.println(string);
        fout.flush();
        System.err.println("[" + hits + "]completed [" + missed + "]missed : hit    :" + string);
    }

    public synchronized void writeMiss(String string) {
        fmiss.println(string);
        fmiss.flush();
        System.err.println("[" + hits + "]completed [" + missed + "]missed : missed :" + string);
    }

    private class Resolver
    implements Runnable {
        private LSID parentLSID;
        private LSID lsid;
        private Launcher parent;

        public Resolver(LSID lSID, LSID lSID2) {
            this.lsid = lSID;
            this.parentLSID = lSID2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Model getModel(LSID lSID) {
            LSIDMetadataPort lSIDMetadataPort;
            LSIDResolver lSIDResolver;
            InputStream inputStream;
            Model model;
            block10: {
                model = null;
                inputStream = null;
                lSIDResolver = new LSIDResolver(this.lsid);
                lSIDMetadataPort = lSIDResolver.getWSDLWrapper().getMetadataPortForProtocol("http");
                if (lSIDMetadataPort != null) break block10;
                Model model2 = null;
                Object var8_8 = null;
                if (inputStream == null) return model2;
                try {
                    inputStream.close();
                    return model2;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                return model2;
            }
            inputStream = lSIDResolver.getMetadata(lSIDMetadataPort).getMetadata();
            model = ModelFactory.createDefaultModel();
            model.read(inputStream, "http://stress.org/");
            inputStream.close();
            Object var8_9 = null;
            if (inputStream == null) return model;
            try {
                inputStream.close();
                return model;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return model;
            {
                catch (Exception exception) {
                    exception.printStackTrace();
                    Object var8_10 = null;
                    if (inputStream == null) return model;
                    try {
                        inputStream.close();
                        return model;
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    return model;
                }
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                if (inputStream == null) throw throwable;
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                throw throwable;
            }
        }

        public void run() {
            Model model = this.getModel(this.lsid);
            if (model == null && !misslist.containsKey(this.lsid.toString()) && (model = this.getModel(this.lsid)) == null) {
                if (this.parentLSID != null) {
                    Launcher.this.writeMiss("could not download metadata from parent " + this.parentLSID.toString() + " for: " + this.lsid.toString());
                } else {
                    Launcher.this.writeMiss("could not download metadata from parent Unknown for: " + this.lsid.toString());
                }
                misslist.put(this.lsid.toString(), "stress");
                missed++;
                return;
            }
            Launcher.this.writeStatus("retrieved metadata for: " + this.lsid.toString());
            hits++;
            StmtIterator stmtIterator = model.listStatements(null, null, (RDFNode)null);
            while (stmtIterator.hasNext()) {
                Object object;
                Object object2;
                Object object3;
                Statement statement = stmtIterator.nextStatement();
                String string = statement.getSubject().toString();
                if (string.startsWith("urn") && !hitlist.containsKey(string)) {
                    hitlist.put(string, "stress");
                    if (statement.getSubject() instanceof Resource) {
                        try {
                            object3 = new LSID(string);
                            object2 = new Resolver((LSID)object3, this.lsid);
                            pool.addJob((Runnable)object2);
                        }
                        catch (MalformedLSIDException malformedLSIDException) {
                            Launcher.this.writeError("invalid lsid : " + string);
                        }
                    }
                }
                if (((String)(object3 = statement.getPredicate().toString())).startsWith("urn") && !hitlist.containsKey(object3)) {
                    hitlist.put(object3, "stress");
                    if (statement.getPredicate() instanceof Resource) {
                        try {
                            object2 = new LSID((String)object3);
                            object = new Resolver((LSID)object2, this.lsid);
                            pool.addJob((Runnable)object);
                        }
                        catch (MalformedLSIDException malformedLSIDException) {
                            Launcher.this.writeError("invalid lsid : " + (String)object3);
                        }
                    }
                }
                if (!((String)(object2 = statement.getObject().toString())).startsWith("urn") || hitlist.containsKey(object2)) continue;
                hitlist.put(object2, "stress");
                if (!(statement.getObject() instanceof Resource)) continue;
                try {
                    object = new LSID((String)object2);
                    Resolver resolver = new Resolver((LSID)object, this.lsid);
                    pool.addJob(resolver);
                }
                catch (MalformedLSIDException malformedLSIDException) {
                    Launcher.this.writeError("invalid lsid : " + (String)object2);
                }
            }
        }
    }
}

