/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lsid.soap;

import com.ibm.lsid.LSIDCredentials;
import com.ibm.lsid.LSIDException;
import com.ibm.lsid.http.HTTPConstants;
import com.ibm.lsid.soap.SOAPConstants;
import com.ibm.lsid.wsdl.LSIDStandardPort;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import javax.xml.namespace.QName;
import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.encoding.XMLType;
import org.apache.axis.message.SOAPHeaderElement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SOAPUtils
implements SOAPConstants,
HTTPConstants {
    private static SimpleDateFormat DATE_TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private static SimpleDateFormat DATE_TIME_FORMAT_131 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");

    public static LSIDException processAxisFault(AxisFault axisFault) {
        Node node;
        int n;
        Object object;
        Object object2;
        Object object3;
        Element element = axisFault.lookupFaultDetail(new QName("http://xml.apache.org/axis/", "HttpErrorCode"));
        int n2 = -1;
        if (element != null) {
            object3 = element.getChildNodes();
            int n3 = 0;
            while (n3 < object3.getLength()) {
                object2 = object3.item(n3);
                if (object2.getNodeType() == 3) {
                    n2 = Integer.parseInt(object2.getNodeValue());
                }
                ++n3;
            }
        }
        if (n2 == 401) {
            object3 = axisFault.lookupFaultDetail(new QName(null, "string"));
            NodeList nodeList = object3.getChildNodes();
            object2 = null;
            int n4 = 0;
            while (n4 < nodeList.getLength()) {
                Node node2 = nodeList.item(n4);
                if (node2.getNodeType() == 3) {
                    object2 = node2.getNodeValue();
                }
                ++n4;
            }
            return new LSIDException(700, (String)object2);
        }
        object3 = axisFault.lookupFaultDetail(new QName("errorcode"));
        Element element2 = axisFault.lookupFaultDetail(new QName("description"));
        object2 = axisFault.lookupFaultDetail(Constants.QNAME_FAULTDETAIL_EXCEPTIONNAME);
        int n5 = -1;
        String string = null;
        String string2 = null;
        if (object3 != null) {
            object = object3.getChildNodes();
            n = 0;
            while (n < object.getLength()) {
                node = object.item(n);
                if (node.getNodeType() == 3) {
                    n5 = Integer.parseInt(node.getNodeValue());
                }
                ++n;
            }
        }
        if (element2 != null) {
            object = element2.getChildNodes();
            n = 0;
            while (n < object.getLength()) {
                node = object.item(n);
                if (node.getNodeType() == 3) {
                    string = node.getNodeValue();
                }
                ++n;
            }
        }
        if (object2 != null) {
            object = object2.getChildNodes();
            n = 0;
            while (n < object.getLength()) {
                node = object.item(n);
                if (node.getNodeType() == 3) {
                    string2 = node.getNodeValue();
                }
                ++n;
            }
        }
        if (n5 == -1) {
            n5 = 500;
        }
        object = "";
        if (string != null) {
            object = (String)object + string;
        }
        return new LSIDException((Exception)((Object)axisFault), n5, (String)object);
    }

    public static Call createCall(LSIDStandardPort lSIDStandardPort, LSIDCredentials lSIDCredentials) throws LSIDException {
        try {
            return SOAPUtils.createCall(new URL(lSIDStandardPort.getLocation()), lSIDStandardPort.getProtocolHeaders(), lSIDCredentials);
        }
        catch (MalformedURLException malformedURLException) {
            throw new LSIDException(711, "Malformed endpoint");
        }
    }

    public static Call createCall(URL uRL, Map map, LSIDCredentials lSIDCredentials) throws LSIDException {
        try {
            Service service = new Service();
            Call call = (Call)service.createCall();
            call.setEncodingStyle(null);
            call.setReturnType(XMLType.AXIS_VOID);
            call.setProperty("attachment_encapsulation_format", (Object)"axis.attachment.style.mime");
            call.setProperty("send_type_attr", (Object)Boolean.FALSE);
            call.setProperty("sendMultiRefs", (Object)Boolean.FALSE);
            if (lSIDCredentials != null) {
                call.setUsername((String)lSIDCredentials.getProperty("basicUsername"));
                call.setPassword((String)lSIDCredentials.getProperty("basicPassword"));
            }
            call.setTargetEndpointAddress(uRL);
            Object[] objectArray = map.keySet().toArray();
            int n = 0;
            while (n < objectArray.length) {
                String string = (String)objectArray[n];
                String string2 = (String)map.get(string);
                SOAPHeaderElement sOAPHeaderElement = new SOAPHeaderElement(null, string, (Object)string2);
                call.addHeader(sOAPHeaderElement);
                ++n;
            }
            return call;
        }
        catch (Exception exception) {
            throw new LSIDException(exception, "Error creating call object");
        }
    }

    public static String writeDate(Date date) {
        try {
            return DATE_TIME_FORMAT.format(date);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return DATE_TIME_FORMAT_131.format(date);
        }
    }

    public static Date parseDate(String string) throws LSIDException {
        try {
            try {
                return DATE_TIME_FORMAT.parse(string);
            }
            catch (Exception exception) {
                return DATE_TIME_FORMAT_131.parse(string);
            }
        }
        catch (ParseException parseException) {
            throw new LSIDException(parseException, "Error parsing date: " + string);
        }
    }

    static {
        DATE_TIME_FORMAT.setTimeZone(TimeZone.getTimeZone("GMT"));
        DATE_TIME_FORMAT_131.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

