/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.Packet;
import com.hazelcast.core.Member;
import com.hazelcast.util.ResponseQueueFactory;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

public class Call {
    private final Long id;
    private final Packet request;
    private volatile Object response;
    private final BlockingQueue<Object> responseQueue = ResponseQueueFactory.newResponseQueue();
    volatile long sent = 0L;
    volatile long written = 0L;
    volatile long received = 0L;
    volatile long replied = 0L;
    private boolean fireNforget;

    public Call(Long id, Packet request) {
        this.id = id;
        this.request = request;
        if (request != null) {
            this.request.setCallId(id);
        }
    }

    public Packet getRequest() {
        return this.request;
    }

    public Long getId() {
        return this.id;
    }

    public Object getResponse() {
        try {
            Object res = this.response != null ? this.response : this.responseQueue.take();
            return this.handleResponse(res);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private Object handleResponse(Object response) {
        if (response == null) {
            return null;
        }
        if (response instanceof RuntimeException) {
            throw (RuntimeException)response;
        }
        return response;
    }

    public Object getResponse(long timeout, TimeUnit unit) {
        try {
            Object res = this.response != null ? this.response : this.responseQueue.poll(timeout, unit);
            return this.handleResponse(res);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void onDisconnect(Member member) {
    }

    public boolean hasResponse() {
        return this.response != null || this.responseQueue.size() > 0;
    }

    public void setResponse(Object response) {
        this.response = response;
        this.responseQueue.offer(response);
    }

    public boolean isFireNforget() {
        return this.fireNforget;
    }

    public void setFireNforget(boolean fireNforget) {
        this.fireNforget = fireNforget;
    }

    public String toString() {
        return "Call [" + this.id + "] operation=" + (this.request != null ? this.request.getOperation() : null);
    }
}

