/* RecIDCM3 actor wraps the RecIDCM3 CORBA service in the CIPRes software package.

 Copyright (c) 1998-2003 The Regents of the University of California.
 All rights reserved.
 Permission is hereby granted, without written agreement and without
 license or royalty fees, to use, copy, modify, and distribute this
 software and its documentation for any purpose, provided that the above
 copyright notice and the following two paragraphs appear in all copies
 of this software.

 IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF
 THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF
 SUCH DAMAGE.

 THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
 CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
 ENHANCEMENTS, OR MODIFICATIONS.

                                        PT_COPYRIGHT_VERSION_2
                                        COPYRIGHTENDKEY
*/

package org.cipres.kepler;

import ptolemy.actor.TypedAtomicActor;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.*;
import ptolemy.actor.IOPort;
import ptolemy.actor.TypedIOPort;
import ptolemy.data.Token;
import ptolemy.data.ObjectToken;
import ptolemy.data.StringToken;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.data.expr.Parameter;

import javax.swing.JOptionPane;

import org.cipres.CipresIDL.Rid3TreeImprove;
import org.cipres.CipresIDL.Tree;
import org.cipres.CipresIDL.DataMatrix;
import org.cipres.helpers.CipresRegistry;
import org.cipres.helpers.RegistryEntryWrapper;
import org.cipres.helpers.CipresServiceDialog;

//////////////////////////////////////////////////////////////////////////
//// RecIDCM3
/**
 * This is the implementation of the RecIDCM3 actor using Kepler.
 * This actor wraps RecIDCM3 CORBA service in the CIPRes software package.
 * 
 * @author Zhijie Guan  
 * guan@sdsc.edu
*/

public class RecIDCM3 extends TypedAtomicActor {

	/** Construct RecIDCM3 source with the given container and name.
     *  @param name The name of this actor.
     *  @exception IllegalActionException If the entity cannot be contained
     *   by the proposed container.
     *  @exception NameDuplicationException If the container already has an
     *   actor with this name.
     */
	
    public RecIDCM3(CompositeEntity container, String name)
            throws NameDuplicationException, IllegalActionException  {
        super(container, name);
        
		inputDataMatrix = new TypedIOPort(this, "Data Matrix", true, false);
		inputTree = new TypedIOPort(this, "Tree", true, false);
		
        outputTree = new TypedIOPort(this, "Final Tree", false, true);
        // Set the type constraint.
        outputTree.setTypeEquals(BaseType.GENERAL);

        _attachText("_iconDescription", "<svg>\n" +
                "<rect x=\"0\" y=\"0\" "
                + "width=\"60\" height=\"20\" "
                + "style=\"fill:white\"/>\n" +
                "</svg>\n");
		
    }

    ///////////////////////////////////////////////////////////////////
    ////                     ports and parameters                  ////
	public TypedIOPort inputDataMatrix = null; 
	public TypedIOPort inputTree = null;

	public TypedIOPort outputTree = null;    
	
	///////////////////////////////////////////////////////////////////
	////                    functional variables                   ////
	private org.cipres.CipresIDL.Tree finalTree = null;

    ///////////////////////////////////////////////////////////////////
    ////                         public methods                    ////

    /** Improve the tree using RecIDCM3 CORBA service.
     *  @exception IllegalActionException If it is thrown by the
     *   send() method sending out the token.
     */
    public void fire() throws IllegalActionException {
        super.fire();
		
		if ( (inputTree.hasToken(0)) && (inputDataMatrix.hasToken(0)) ) {		
			
			RegistryEntryWrapper rid3Wrapper = null;
			try {
				rid3Wrapper = CipresRegistry.getCipresServiceWrapper(Rid3TreeImprove.class, null, null);
				// with GuiGen
				CipresServiceDialog dialog = rid3Wrapper.getServiceDialog(null);
				int status = dialog.showAndInitialize();
				if (status == CipresServiceDialog.OK)
				{
					Rid3TreeImprove service = (Rid3TreeImprove)rid3Wrapper.getService();
					service.setTree( (Tree)((ObjectToken)inputTree.get(0)).getValue() );
					service.setMatrix( (DataMatrix)((ObjectToken)inputDataMatrix.get(0)).getValue() );
					finalTree = service.improveTree(null);
				} else if (status == CipresServiceDialog.ERROR)
				{
					JOptionPane.showMessageDialog(null, "error initializing service");
				}
				
			}
			catch (Exception e) {
				e.printStackTrace();
			}
			finally {
				if (rid3Wrapper != null) {
					rid3Wrapper.releaseService();
				}
			}
			
			outputTree.send(0, new ObjectToken( finalTree ));
		}
    }


	/** Post fire the actor. Return false to indicated that the
	 *  process has finished. If it returns true, the process will
	 *  continue indefinitely.
	 */
/*	
	public boolean postfire() {
		return false;
	}	
*/
}

