/* TreeVizForester actor displays a tree in Forester.

 Copyright (c) 1998-2003 The Regents of the University of California.
 All rights reserved.
 Permission is hereby granted, without written agreement and without
 license or royalty fees, to use, copy, modify, and distribute this
 software and its documentation for any purpose, provided that the above
 copyright notice and the following two paragraphs appear in all copies
 of this software.

 IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF
 THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF
 SUCH DAMAGE.

 THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
 CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
 ENHANCEMENTS, OR MODIFICATIONS.

                                        PT_COPYRIGHT_VERSION_2
                                        COPYRIGHTENDKEY
*/

package org.cipres.kepler;

import ptolemy.actor.TypedAtomicActor;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.*;
import ptolemy.actor.IOPort;
import ptolemy.actor.TypedIOPort;
import ptolemy.data.Token;
import ptolemy.data.ObjectToken;
import ptolemy.data.StringToken;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.data.expr.Parameter;

import org.cipres.CipresIDL.Tree;
import org.cipres.datatypes.TreeWrapper;

import forester.tree.*;
import forester.atv.*;


//////////////////////////////////////////////////////////////////////////
//// TreeVizForester
/**
 * This is the implementation of the TreeVizForester actor using Ptolemy II.
 * This actor displays a tree in Forester.
 * 
 * @author Zhijie Guan  
 * guan@sdsc.edu
*/

public class TreeVizForester extends TypedAtomicActor {

	/** Construct TreeVizForester source with the given container and name.
     *  @param name The name of this actor.
     *  @exception IllegalActionException If the entity cannot be contained
     *   by the proposed container.
     *  @exception NameDuplicationException If the container already has an
     *   actor with this name.
     */
	
    public TreeVizForester(CompositeEntity container, String name)
            throws NameDuplicationException, IllegalActionException  {
        super(container, name);
        
		inputTreeString = new TypedIOPort(this, "Tree String", true, false);
		inputTreeString.setTypeEquals(BaseType.GENERAL);
		
        _attachText("_iconDescription", "<svg>\n" +
                "<rect x=\"0\" y=\"0\" "
                + "width=\"60\" height=\"20\" "
                + "style=\"fill:white\"/>\n" +
                "</svg>\n");
		
    }

    ///////////////////////////////////////////////////////////////////
    ////                     ports and parameters                  ////

	public TypedIOPort inputTreeString = null;
	
	///////////////////////////////////////////////////////////////////
	////                    functional variables                   ////

	
    ///////////////////////////////////////////////////////////////////
    ////                         public methods                    ////

    /** Display a tree in Forester.
     *  @exception IllegalActionException If it is thrown by the
     *   send() method sending out the token.
     */
    public void fire() throws IllegalActionException {
        super.fire();
		
		if (inputTreeString.hasToken(0)) {
			String treeDescription = ((StringToken)inputTreeString.get(0)).stringValue();
			try {
				forester.tree.Tree displayedTree = new forester.tree.Tree(treeDescription);
				ATVjframe atvframe = new ATVjframe(displayedTree);
				//atvframe.setTitle(treeDescription);
				atvframe.showWhole();
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		
    }
}

