/**
 *  '$RCSfile: ServicesDisplayFrame.java,v $' '$Author: ruland $' '$Date:
 *  2004/11/16 23:36:32 $' '$Revision: 1.13 $' For Details:
 *  http://kepler.ecoinformatics.org Copyright (c) 2004 The Regents of the
 *  University of California. All rights reserved. Permission is hereby granted,
 *  without written agreement and without license or royalty fees, to use, copy,
 *  modify, and distribute this software and its documentation for any purpose,
 *  provided that the above copyright notice and the following two paragraphs
 *  appear in all copies of this software. IN NO EVENT SHALL THE UNIVERSITY OF
 *  CALIFORNIA BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL,
 *  OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS
 *  DOCUMENTATION, EVEN IF THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE. THE UNIVERSITY OF CALIFORNIA SPECIFICALLY
 *  DISCLAIMS ANY WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE
 *  SOFTWARE PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
 *  CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
 *  ENHANCEMENTS, OR MODIFICATIONS.
 */

package org.ecoinformatics.seek.ecogrid;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Point;
import java.util.Vector;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


/**
 *  Class reprents a frame which will display a service panel
 *
 *@author     not attributable
 *@created    February 17, 2005
 */

public class ServicesDisplayFrame extends JFrame
{
  private JPanel mainPanel = new JPanel();
  private JPanel textPanel = new JPanel();
  private JLabel textLabel = new JLabel();
  private JPanel buttonPanel = new JPanel();
  private Point location = null;
  private ServicesDisplayPanel servicesDisplayPanel = null;
  private String displayText = "";
  private Vector selectedServiceList = null;
  /**
   *  Description of the Field
   */
  protected EcoGridServicesController controller = null;
  private Vector originalServiceList = new Vector();

  /**
   *  Description of the Field
   */
  public final static int MARGINGSIZE = 20;
  /**
   *  Description of the Field
   */
  public final static int GAP = 30;
  /**
   *  Description of the Field
   */
  public final static int HEIGHT = 400;
  /**
   *  Description of the Field
   */
  public final static Dimension BUTTONDIMENSION = new Dimension(83, 25);
  private final static int ROWNUMBER = 5;

  protected final static Log log;
  static {
  	log = LogFactory.getLog( "org.ecoinformatics.seek.ecogrid.ServicesDisplayFrame" );
  }

  /**
   *  Constructor of the frame
   *
   *@param  frameTitle             Description of the Parameter
   *@param  selectedServiceList    Description of the Parameter
   *@param  controller             Description of the Parameter
   *@param  location               Description of the Parameter
   *@exception  HeadlessException  Description of the Exception
   *@throws  HeadlessException
   */
  public ServicesDisplayFrame(String frameTitle, Vector selectedServiceList,
                              EcoGridServicesController controller,
                              Point location)
    throws HeadlessException
  {
    super(frameTitle);
    this.selectedServiceList = selectedServiceList;
    this.controller = controller;
    this.location = location;
    this.setLocation(location);
    initOriginalServiceList();
    initFrameSize();
    initMainPanel();
    getContentPane().add(Box.createVerticalStrut(MARGINGSIZE), BorderLayout.NORTH);
    getContentPane().add(Box.createHorizontalStrut(MARGINGSIZE), BorderLayout.EAST);
    getContentPane().add(mainPanel, BorderLayout.CENTER);
    getContentPane().add(Box.createVerticalStrut(MARGINGSIZE), BorderLayout.SOUTH);
    getContentPane().add(Box.createHorizontalStrut(MARGINGSIZE), BorderLayout.WEST);
    setVisible(true);

  }
  //ServicesDisplayFrame


  /*
   *  Method to initial frame size
   */
  /**
   *  Description of the Method
   */
  private void initFrameSize()
  {
    Insets insets = getInsets();
    int width = 2 * MARGINGSIZE + insets.left + insets.right +
        ServicesDisplayPanel.HEADNAME.length * ServicesDisplayPanel.CELLPREFERREDWIDTH;
    int height = HEIGHT;
    setSize(new Dimension(width, height));
  }


  /*
   *  Method to initPanles (box layout)
   */
  /**
   *  Description of the Method
   */
  private void initMainPanel()
  {
    mainPanel.setLayout(new BorderLayout());

    //init text panel and add it to main panel
    initTextPanel();
    mainPanel.add(textPanel, BorderLayout.NORTH);
    //add gap between text and servicepanel

    // init service dispaly panel and add it to main panel
    initServiceDisplayPanel();
    mainPanel.add(servicesDisplayPanel, BorderLayout.CENTER);
    mainPanel.add(buttonPanel, BorderLayout.SOUTH);

  }
  //initMainPanel


  /*
   *  Init text panel (border Layout and box layout)
   */
  /**
   *  Description of the Method
   */
  private void initTextPanel()
  {
    //text part of text panel
    JPanel textTopPanel = new JPanel();
    textTopPanel.setLayout(new BoxLayout(textTopPanel, BoxLayout.X_AXIS));
    textTopPanel.add(textLabel);
    textTopPanel.add(Box.createHorizontalGlue());
    // y box layout
    textPanel.setLayout(new BoxLayout(textPanel, BoxLayout.Y_AXIS));
    textPanel.add(textTopPanel);
    textPanel.add(Box.createVerticalStrut(GAP));
  }
  //initTextPanel


  /*
   *  Init service display panel(border layout)
   */
  /**
   *  Description of the Method
   */
  private void initServiceDisplayPanel()
  {
    servicesDisplayPanel = new ServicesDisplayPanel(selectedServiceList);
  }
  //initServiceDisplayPanel


  /*
   *  Method to initialize the orginal service, it will copy the service list in
   *  controller to another vector(it will create a new EcoGridService object,
   *  not a pointer)
   */
  /**
   *  Description of the Method
   */
  private void initOriginalServiceList()
  {
    Vector serviceList = controller.getServicesList();
    if (serviceList != null)
    {

      int size = serviceList.size();
      for (int i = 0; i < size; i++)
      {
        SelectableEcoGridService service = (SelectableEcoGridService) serviceList.elementAt(i);
        try
        {
          SelectableEcoGridService newServcie = SelectableEcoGridService.copySelectableEcoGridService(service);
          originalServiceList.add(newServcie);

        }
        catch (Exception e)
        {
          log.debug("Error for copy a servie in initOrignialServiceList ", e);
        }

      }
      //for
    }
    //if
  }
  //


  /**
   *  Method to get the main panel.
   *
   *@return    JPanel
   */
  public JPanel getMainPanel()
  {
    return this.mainPanel;
  }
  //getMainPanel


  /**
   *  Method to get service display panel
   *
   *@return    JPanel
   */
  public ServicesDisplayPanel getServicesDisplayPanel()
  {
    return this.servicesDisplayPanel;
  }
  //getServiceDisplayPanel()


  /**
   *  Method to set up a new service dipaly panel panel
   *
   *@param  servicesDisplayPanel  ServicesDisplayPanel
   */
  public void setServiceDisplayPanel(ServicesDisplayPanel servicesDisplayPanel)
  {
    mainPanel.remove(this.servicesDisplayPanel);
    this.servicesDisplayPanel = servicesDisplayPanel;
    mainPanel.add(this.servicesDisplayPanel, BorderLayout.CENTER);
    mainPanel.validate();

  }
  //setServiceDisplayPanel


  /**
   *  Method to get button panel
   *
   *@return    JPanel
   */
  public JPanel getButtonPanel()
  {
    return this.buttonPanel;
  }
  //get button panel


  /**
   *  Method to reset buttion panel
   *
   *@param  buttonPanel  JPanel
   */
  public void setButtonPanel(JPanel buttonPanel)
  {
    mainPanel.remove(this.buttonPanel);
    this.buttonPanel = buttonPanel;
    mainPanel.add(this.buttonPanel, BorderLayout.SOUTH);
    mainPanel.validate();
  }
  //setButtonPanel


  /**
   *  Method to get display text
   *
   *@return    String
   */
  public String getDisplayText()
  {
    return this.displayText;
  }
  //getDisplayText


  /**
   *  Method to set the display string
   *
   *@param  displayText  String
   */
  public void setDisplayText(String displayText)
  {
    this.displayText = displayText;
    textLabel.setText(this.displayText);
  }
  //setDislayText


  /**
   *  Method to get controller
   *
   *@return    EcoGridServicesController
   */
  public EcoGridServicesController getEcoGridServicesController()
  {
    return this.controller;
  }
  //getecogridcontroller


  /**
   *  Method to set controller
   *
   *@param  controller  EcoGridServicesController
   */
  public void setEcoGridServicesController(EcoGridServicesController controller)
  {

    this.controller = controller;
  }
  //setEcoGridServicesController


  /**
   *  Method to get original service list(this list is for cancel button)
   *
   *@return    Vector
   */
  public Vector getOriginalServiceList()
  {
    return this.originalServiceList;
  }
  //getOriginalServiceList


  /**
   *  Set original service list
   *
   *@param  originalServiceList  Vector
   */
  public void setOriginalServiceList(Vector originalServiceList)
  {
    this.originalServiceList = originalServiceList;
  }
  //setOriginalServiceList
 
  
  /**
   * Method to update service in controller base on the user selection
   * in the panel
   */
  public void updateController()
  {
      //currently we just set new service into controller(memory), later will need to
      //save to jar configure file
      if (servicesDisplayPanel != null && controller != null)
      {
        // removed the all unselected serivce
        Vector allUnSelectedList = servicesDisplayPanel.getAllUnSelectedServicesList();
        if (allUnSelectedList != null)
        {
          int size = allUnSelectedList.size();
          for (int i=0; i<size; i++)
          {
            SelectableEcoGridService service = (SelectableEcoGridService)allUnSelectedList.elementAt(i);
            controller.removeService(service);
          }
        }
        //updated partial selected services
        // this vector is a service list with the selected document type
        Vector partialSelectedList = servicesDisplayPanel.getPartialSelectedServicesList();
        if (partialSelectedList != null)
        {
          int length = partialSelectedList.size();
          for (int j=0; j<length; j++)
          {
            SelectableEcoGridService service = (SelectableEcoGridService)partialSelectedList.elementAt(j);
            try
            {
              controller.updateService(service);
            }
            catch(Exception ee)
            {
              log.debug("Could not update a service "+service.getServiceName(),ee );
            }
          }//for
        }//if
      }
  }

  /**
   *  The main program for the ServicesDisplayFrame class
   *
   *@param  args  The command line arguments
   */
  public static void main(String[] args)
  {

    EcoGridQueryServicesController controller = EcoGridQueryServicesController.getInstance();
    Vector unSelectedserviceList = controller.getServicesList();
    //transfer to selectedSerive list(object is SelectedEcoGridService now)
    Vector selectedServicesLists =
        SelectableEcoGridService.transferServiceVectToDefaultSelectedServiceVect(unSelectedserviceList);
    //Vector selectedServicesLists = new Vector();
    ServicesDisplayFrame frame = new ServicesDisplayFrame("SwingApplication", selectedServicesLists, null, null);
    frame.setDisplayText("The service is:");

  }
  //main

}
