/**
 *    '$RCSfile: HullJniGlue.java,v $'
 *
 *     '$Author: berkley $'
 *       '$Date: 2004/11/30 23:29:25 $'
 *   '$Revision: 1.4 $'
 *
 *  For Details: http://kepler.ecoinformatics.org
 *
 * Copyright (c) 2003 The Regents of the University of California.
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 * FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 *
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY
 * OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
 * UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */

package org.ecoinformatics.seek.gis.grass;

/**
 *
 */
class HullJniGlue
{
  public native int GISHull(
    String pointDataFileName /*char *pointDataFile*/,
    String hullDataFileName /*char *hullDataFile*/
  );

  /**
   * load the library
   */
  static
  {
    System.loadLibrary("gishull");
  }

  /**
   * test the jni glue
   */
  public static void main( String[] args)
  {
    //System.setProperty("java.library.path","c:\\kepler");
    System.out.println(System.getProperty("java.library.path"));
    //System.loadLibrary("GISHull");
    HullJniGlue g = new HullJniGlue();
    System.out.println("calling GISHull");
    System.out.println(g.GISHull("DataPoints.txt","HullPoint.txt"));
  }
}
