/**
 *  Copyright: 2000 Regents of the University of California and the
 *             National Center for Ecological Analysis and Synthesis
 *
 * ********This class was auto-generated by the SEEK AMS engine.********
 * This software is governed by the following license:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package org.geon;
//tokens
import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.data.DoubleToken;
import ptolemy.data.StringToken;
import ptolemy.data.expr.FileParameter;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.StringParameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;

import com.numericsolutions.geomodeltools.invdist_power_isosearch2d;

/** A grid interpolation actor. Currently only inverse distance is supported.
 * 
 * @author Efrat Jaeger, John Harris
 * @version $Id: Interpolate.java,v 1.5 2006/04/04 17:23:49 altintas Exp $
 */
public class Interpolate extends TypedAtomicActor
{
  public Interpolate(CompositeEntity container, String name)
    throws NameDuplicationException, IllegalActionException
  {
    super(container, name);
    input = new TypedIOPort(this, "input", true, false);
    input.setTypeEquals(BaseType.STRING);  //Push or Pull
    output = new TypedIOPort(this, "output", false, true);
    output.setTypeEquals(BaseType.STRING);
    interploationAlg = new StringParameter(this, "interpolationAlg");
    interploationAlg.setExpression("inverse distance");
    interploationAlg.addChoice("inverse distance");
    interploationAlg.addChoice("minimum curvature");
    interploationAlg.addChoice("nearest neighbor");
    interploationAlg.addChoice("surface");
    outputFormat = new StringParameter(this, "outputFormat");
    outputFormat.setExpression("ESRI ascii grid");
    outputFormat.addChoice("ESRI ascii grid");
    outFile = new FileParameter(this, "output file");
    latMin = new Parameter(this, "latMin");
    latMin.setTypeEquals(BaseType.DOUBLE);
    latMax = new Parameter(this, "latMax");
    latMax.setTypeEquals(BaseType.DOUBLE);
    longMin = new Parameter(this, "longMin");
    longMin.setTypeEquals(BaseType.DOUBLE);
    longMax = new Parameter(this, "longMax");
    longMax.setTypeEquals(BaseType.DOUBLE);
    xSpace = new Parameter(this, "x grid spacing");
    xSpace.setTypeEquals(BaseType.DOUBLE);
    ySpace = new Parameter(this, "y grid spacing");
    ySpace.setTypeEquals(BaseType.DOUBLE);
    coefficient = new Parameter(this, "coefficient");
    coefficient.setTypeEquals(BaseType.DOUBLE);
    nullVal = new Parameter(this, "null value representation");
    nullVal.setTypeEquals(BaseType.DOUBLE);
    searchRadius = new Parameter(this, "search radius");
    searchRadius.setTypeEquals(BaseType.DOUBLE);

  }

  /** A string representation of the dataset */
  public TypedIOPort input;

  /** A string representation of the gridded output */
  public TypedIOPort output;

  // FIXME: currently supports only IDW.
  /** The selected algorithm */
  public StringParameter interploationAlg;

  //NOTE: so far only esri ascii grid is supported.
  /** The format of the interpolated result */
  public StringParameter outputFormat;

  public FileParameter outFile;
  /** Minimum latitude */
  public Parameter latMin;

  /** Maximum latitude */
  public Parameter latMax;

  /** Minimum longitude */
  public Parameter longMin;

  /** Maximum longitude */
  public Parameter longMax;

  /** Spacing between the grid cells */
  public Parameter xSpace;

  /** Spacing between the grid cells */
  public Parameter ySpace;

  /** Weight coefficient */
  public Parameter coefficient;

  /** Representation of null values */
  public Parameter nullVal;

  /** The search space */
  public Parameter searchRadius;

  public void initialize()
    throws IllegalActionException
  {
  }

  public boolean prefire()
    throws IllegalActionException
  {
    return super.prefire();
  }

  public void fire()
    throws IllegalActionException
  {
    try {
    	//TODO: take care of other algorithm and output format selection.
        float xmin = (float)((DoubleToken)latMin.getToken()).doubleValue();
    	float xmax = (float)((DoubleToken)latMax.getToken()).doubleValue();
    	float ymin = (float)((DoubleToken)longMin.getToken()).doubleValue();
        float ymax = (float)((DoubleToken)longMax.getToken()).doubleValue();

        float dx = (float)((DoubleToken)xSpace.getToken()).doubleValue();
        float dy = (float)((DoubleToken)ySpace.getToken()).doubleValue();
        float nullval = (float)((DoubleToken)nullVal.getToken()).doubleValue();


        float weight = (float)((DoubleToken)coefficient.getToken()).doubleValue();
        float searchradius = (float)((DoubleToken)searchRadius.getToken()).doubleValue();


        String dataFile = ((StringToken)input.get(0)).stringValue();
        dataFile = dataFile.trim();
        String gridFile = ((StringToken)outFile.getToken()).stringValue();

        invdist_power_isosearch2d gridder = new invdist_power_isosearch2d();

        gridder.execute(dataFile, gridFile, xmin, xmax, ymin, ymax, dx, dy,  nullval, weight, searchradius);


        output.broadcast(new StringToken(gridFile));

    } catch (
      		Exception ex) {ex.printStackTrace();
    }

  }
}
