/* An actor that writes the value of string tokens to a file, one per line.

@Copyright (c) 2002-2004 The Regents of the University of California.
All rights reserved.

Permission is hereby granted, without written agreement and without
license or royalty fees, to use, copy, modify, and distribute this
software and its documentation for any purpose, provided that the
above copyright notice and the following two paragraphs appear in all
copies of this software.

IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF
THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF
SUCH DAMAGE.

THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
ENHANCEMENTS, OR MODIFICATIONS.

PT_COPYRIGHT_VERSION 2
COPYRIGHTENDKEY
*/

package org.geon;

import java.io.File;
import java.io.PrintWriter;
import java.util.Iterator;

import ptolemy.actor.IOPort;
import ptolemy.actor.IORelation;
import ptolemy.actor.TypedIOPort;
import ptolemy.actor.lib.io.LineWriter;
import ptolemy.data.BooleanToken;
import ptolemy.data.StringToken;
import ptolemy.data.Token;
import ptolemy.data.expr.StringParameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Workspace;
import ptolemy.util.MessageHandler;

//////////////////////////////////////////////////////////////////////////
//// LoggingActor
/**
   This actor is used to save workflow parameter and execution results.
*/
public class LoggingActor extends LineWriter {

    /** Construct an actor with the given container and name.
     *  @param container The container.
     *  @param name The name of this actor.
     *  @exception IllegalActionException If the actor cannot be contained
     *   by the proposed container.
     *  @exception NameDuplicationException If the container already has an
     *   actor with this name.
     */
    public LoggingActor(CompositeEntity container, String name)
            throws IllegalActionException, NameDuplicationException {
        super(container, name);

        input.setMultiport(true);

        operation = new StringParameter(this, "operation");
        operation.setExpression("forward input");
        operation.addChoice("forward input");
        operation.addChoice("write to file");

/*        fileName = new FileParameter(this, "fileName");
        fileName.setExpression("System.out");

        append = new Parameter(this, "append");
        append.setTypeEquals(BaseType.BOOLEAN);
        append.setToken(BooleanToken.FALSE);

        confirmOverwrite = new Parameter(this, "confirmOverwrite");
        confirmOverwrite.setTypeEquals(BaseType.BOOLEAN);
  */      

        output = new TypedIOPort(this, "output", false, true);
        output.setTypeEquals(BaseType.STRING);
	    output.setContainer(this);
        
        _attachText("_iconDescription", "<svg>\n"
                + "<rect x=\"-25\" y=\"-20\" "
                + "width=\"50\" height=\"40\" "
                + "style=\"fill:white\"/>\n"
                + "<polygon points=\"-15,-10 -12,-10 -8,-14 -1,-14 3,-10"
                + " 15,-10 15,10, -15,10\" "
                + "style=\"fill:red\"/>\n"
                + "</svg>\n");
    }

    public StringParameter operation;
    
	/** Overriding the parent attributes to take care of their order. */
    /*public Parameter append;
    public FileParameter fileName;
    public Parameter confirmOverwrite;
    */
    public TypedIOPort output;
    
    ///////////////////////////////////////////////////////////////////
    ////                         public methods                    ////

    /** If the specified attribute is <i>operation</i>, if the value is 
     * set to forward then add an output port to forward the input strings.
     * Else write to a file specified by <i>fileName<i>. If the specified 
     * attribute is <i>fileName</i> or append value, it will be handled by 
     * the parent class
     * @see LineWriter
     */
    public void attributeChanged(Attribute attribute)
            throws IllegalActionException {
        if (attribute == operation) {
            String strOperation = operation.getExpression();
            if (strOperation.equals("forward input")) {
                _operation = _FWD;
				try {
					output.setContainer(this);
					output.setTypeEquals(BaseType.STRING);
				} catch (NameDuplicationException e) {
					e.printStackTrace();
				}
            } else if (strOperation.equals("write to file")) {
                _operation = _WRT;
                Iterator outPorts = this.outputPortList().iterator();
                while (outPorts.hasNext()) {
                	IOPort p = (IOPort) outPorts.next();
                	if (p.isOutput()) {
                		try {
                			if (p.getName().equals("output")) {
                				p.setContainer(null);
                			}
                		} catch (Exception ex) { 
                			_debug("unable to remove output port");
                		}
                  	}
                }
            } else {
                throw new IllegalActionException(this,
                        "Unrecognized operation: " + strOperation);
            }
        } else { // if this attribute is fileName or append value, etc..
            super.attributeChanged(attribute);
        }
    }

    
    /** Clone the actor into the specified workspace.
     *  @return A new actor.
     *  @exception CloneNotSupportedException If a derived class contains
     *   an attribute that cannot be cloned.
     */
    public Object clone(Workspace workspace)
            throws CloneNotSupportedException {
        LoggingActor newObject = (LoggingActor)super.clone(workspace);
        newObject._writer = null;
        return newObject;
    }

    /** Sets first to true.
     *  @exception IllegalActionException 
     */
    public void initialize() throws IllegalActionException {
        super.initialize();
        _first = true;
    }
    /** Read an input string token and write it to the file.
     *  If there is no input, do nothing.
     *  If the file is not open for writing then open it. If the file
     *  does not exist, then create it.  If the file already exists,
     *  then query the user for overwrite, unless the <i>append</i>
     *  parameter has value <i>true</i>.
     *  @exception IllegalActionException If the file cannot be opened
     *   or created, or if the user refuses to overwrite an existing file.
     */
    public boolean postfire() throws IllegalActionException {
	
		if (_operation == _WRT) {
			if (fileName.getExpression() == "") {
            	throw new IllegalActionException(this, 
          			"No fileName specified!");
			}
			if (_writer == null) {
	            // Open the file.
	            File file = fileName.asFile();
	            boolean appendValue
	                = ((BooleanToken)append.getToken()).booleanValue();
	            boolean confirmOverwriteValue
	                = ((BooleanToken)confirmOverwrite.getToken())
	                .booleanValue();
	            // Don't ask for confirmation in append mode, since there
	            // will be no loss of data.
	            if (file.exists() && !appendValue && confirmOverwriteValue) {
	                // Query for overwrite.
	                // FIXME: This should be called in the event thread!
	                // There is a chance of deadlock since it is not.
	                if (!MessageHandler.yesNoQuestion(
	                            "OK to overwrite " + file + "?")) {
	                    throw new IllegalActionException(this,
	                            "Please select another file name.");
	                }
	            }
	            _writer = new PrintWriter(
	                    fileName.openForWriting(appendValue), true);
	        }
	    }
    	String send ="";
    	if (_first) {
    		_first = false;
    		NamedObj _topLevel = this.toplevel();
    		send = _topLevel.exportMoML();
//    		_writer.println(_topLevel.exportMoML());
       	}
    	Iterator _conRels = input.linkedRelationList().iterator();
        for (int i = 0; i < input.getWidth(); i++) {
            if (input.hasToken(i)) {
            	String inputStr = ((StringToken)input.get(i)).stringValue();
            	//get connected actor name.
				IORelation rel = ((IORelation) _conRels.next());
				Iterator _conPorts = rel.linkedPortList().iterator();
            	while (_conPorts.hasNext()) {
            		IOPort p = (IOPort)_conPorts.next();
            		System.out.println(p.getName() + " --> output ? " + p.isOutput() );
            		if (p.isOutput()) {
            			send +=  "\n" + p.getContainer().getFullName();
            		}
            	}
            	//_writer.println(p.getContainer().getFullName());
            	//add time stamp.
                //_writer.println(getDirector().getCurrentTime());   	
                send += "\n" + this.getDirector().getCurrentTime();
                // add value.
                send += "\n" + inputStr;
                //System.out.println(send);
            	//_writer.println(inputStr);
	        }
        }
        if (_operation == _FWD)  {
        	output.broadcast(new StringToken(send));
        }
        else {
        	_writer.print(send);
        }
        return super.postfire();
    }

    /** Close the writer if there is one.
     *  @exception IllegalActionException If an IO error occurs.
     */
    public void wrapup() throws IllegalActionException {
        fileName.close();
        _writer = null;
    }

    ///////////////////////////////////////////////////////////////////
    ////                         protected methods                 ////

    /** Write the specified token to the current writer.
     *  This is protected so that derived classes can modify the
     *  format in which the token is written.
     *  @param token The token to write.
     */
    protected void _writeToken(Token token) {
        
    }

    ///////////////////////////////////////////////////////////////////
    ////                         protected members                 ////

    /** The current writer. */
    protected PrintWriter _writer;

    ///////////////////////////////////////////////////////////////////
    ////                         private members                   ////

    /** Previous value of fileName parameter. */
    private String _previousFileName;
    
    private boolean _first = false;

    /** Operation to be performed on the input: forward or write to file */
    private int _operation;
    
    // Constants used for more efficient execution.
    private static final int _FWD = 0;
    private static final int _WRT = 1;
    
}
