/* Translating a moml description into actor relations axioms.

@Copyright (c) 2002-2003 The Regents of the University of California.
All rights reserved.

Permission is hereby granted, without written agreement and without
license or royalty fees, to use, copy, modify, and distribute this
software and its documentation for any purpose, provided that the
above copyright notice and the following two paragraphs appear in all
copies of this software.

IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF
THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF
SUCH DAMAGE.

THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
ENHANCEMENTS, OR MODIFICATIONS.

                                                PT_COPYRIGHT_VERSION 2
                                                COPYRIGHTENDKEY
*/

package org.geon;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import ptolemy.actor.IOPort;
import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedCompositeActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.data.StringToken;
import ptolemy.data.expr.FileParameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.ComponentEntity;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Relation;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.moml.MoMLParser;


//////////////////////////////////////////////////////////////////////////
////MomlToGraph
/**

@author Efrat Jaeger
@version $Id: MomlToGraph.java,v 1.8 2005/11/01 20:39:08 ruland Exp $
@since Ptolemy II 3.0.2
*/
public class MomlToGraph extends TypedAtomicActor {

	 /** Construct an actor with the given container and name.
	 *  @param container The container.
	 *  @param name The name of this actor.
	 *  @exception IllegalActionException If the actor cannot be contained
	 *   by the proposed container.
	 *  @exception NameDuplicationException If the container already has an
	 *   actor with this name.
	 */

	public MomlToGraph(CompositeEntity container, String name)
	        throws NameDuplicationException, IllegalActionException  {

	    super(container, name);

	    axiom = new TypedIOPort(this, "axiom", false, true);
	    // Set the type constraint.
	    axiom.setTypeEquals(BaseType.STRING);

	    momlFile = new FileParameter(this, "momlFile");

	}

	public TypedIOPort axiom;

	public FileParameter momlFile;

	public String getEntities(CompositeEntity CE) {
        	Iterator ents = CE.entityList().iterator();
        	String axiom = "";
        	while (ents.hasNext()) {
        		Object obj = ents.next();
        		ComponentEntity CA = (ComponentEntity) obj;
        		System.out.println(obj.getClass().getName());
        		if (CA instanceof TypedCompositeActor) {
        			CompositeEntity inner = (CompositeEntity) CA;
        			axiom += getEntities(inner);
        			//TODO: add composite entity name??
        		}
        		System.out.println(CA.getClass());
        		System.out.println(CA.getName());
        		axiom += "actor('" + CA.getName() + "','";
        		axiom += obj.getClass().getName() + "').\r\n";
        	}
        	return axiom;

        }

        public String getRelations() {
        	//TODO: TAKE CARE OF MOML COMPOSITE ENTITIES (LIKE IN SINEWAVE)
        	_workspace = _toplevel.getFullName();
        	_workspaceLen = _workspace.length()+1;
        	CompositeEntity CE = (CompositeEntity) _toplevel;
        	String axiom = "";
        	axiom = _relations(CE);
    /*    	Iterator rels = CE.relationList().iterator();
        	while (rels.hasNext()) {
        		Relation rel = (Relation) rels.next();
        		Iterator ports = rel.linkedPortList().iterator();
        		while (ports.hasNext()) {
        			IOPort p = (IOPort)ports.next();
        			System.out.println(p.getName());
        			System.out.println("containing entity" + p.getContainer().getName());
        			//Take care of composite entities.
        			if (p.getContainer() instanceof TypedCompositeActor
        					&& !_compEnts.contains(p.getContainer().getName())) {
        				//recall the function and the container is not in the list
        				System.out.println(p.getContainer().getName() + " is a composite actor");
        				_compEnts.add(p.getContainer().getName());
        				CompositeEntity inner = (CompositeEntity) p.getContainer();
        				axiom += _relations(inner);
        			}
        				//add to list.
        				//recursion.
        			// connect all input ports to output ports.
        			if (p.isOutput()) {
        				Iterator connected = p.connectedPortList().iterator();
        				while (connected.hasNext()) {
        					// relations between ports.
        					IOPort inPort = (IOPort) connected.next();
        					String outP = p.getFullName().substring(_workspaceLen);
        					String inP = inPort.getFullName().substring(_workspaceLen);
            				axiom += "PortRelation(" + outP + "," + inP + ").\r\n";
            				//relations between actors.
            				int dotInd = outP.lastIndexOf(".");
            				if (dotInd > -1) {
            					axiom += "relation('" + outP.substring(0,dotInd) + "','";
            				} else {
            					axiom += "relation('" + outP + "','";
            				}
            				dotInd = inP.lastIndexOf(".");
            				if (dotInd > -1) {
            					axiom += inP.substring(0,dotInd) + "').";
            				} else {
            					axiom += inP + "').";
            				}
            				axiom += "\r\n";
            				//TODO: TAKE CARE OF COMPOSITE ENTITIES.
        				}
        			}
        		}*/
        	return axiom;
        }

        public NamedObj parse(URL _momlUrl) {
        	MoMLParser parser = new MoMLParser();
        	parser.reset();
        	try {
        		_toplevel = parser.parse(_momlUrl, _momlUrl);
        	} catch (Exception ex) {
        		System.out.println("moml parser exception" + ex.getMessage());        	}
        	return _toplevel;
        }

        //TODO: USE A GLOBAL COMPONENT ENITY VAR??
        public String _relations(CompositeEntity CE) {
	        String axiom = "";
	        Iterator rels = CE.relationList().iterator();
	    	while (rels.hasNext()) {
	    		Relation rel = (Relation) rels.next();
	    		Iterator ports = rel.linkedPortList().iterator();
	    		while (ports.hasNext()) {
	    			IOPort p = (IOPort)ports.next();
	    			System.out.println(p.getName());
	    			System.out.println("containing entity" + p.getContainer().getName());
	    			//Take care of composite entities that have not been processed yet.
	    			if (p.getContainer() instanceof TypedCompositeActor
	    					&& !_compEnts.contains(p.getContainer().getName())) {
	    				//recall the function and the container is not in the list
	    				System.out.println(p.getContainer().getName() + " is a composite actor");
	    				_compEnts.add(p.getContainer().getName());
	    				CompositeEntity inner = (CompositeEntity) p.getContainer();
	    				axiom += _relations(inner);
	    			}
	    				//add to list.
	    				//recursion.
	    			// connect all input ports to output ports.
	    			if (p.isOutput()) {
	    				Iterator connected = p.connectedPortList().iterator();
	    				while (connected.hasNext()) {
    					// relations between ports.
    					IOPort inPort = (IOPort) connected.next();
    					String outP = p.getFullName().substring(_workspaceLen);
    					String inP = inPort.getFullName().substring(_workspaceLen);
        				axiom += "portRelation('" + outP + "','" + inP + "').\r\n";
        				//relations between actors.
        				int dotInd = outP.lastIndexOf(".");
        				if (dotInd > -1) {
        					axiom += "relation('" + outP.substring(0,dotInd) + "','";
        				} else {
        					axiom += "relation('" + outP + "','";
        				}
        				dotInd = inP.lastIndexOf(".");
        				if (dotInd > -1) {
        					axiom += inP.substring(0,dotInd) + "').";
        				} else {
        					axiom += inP + "').";
        				}
        				axiom += "\r\n";
        				//TODO: TAKE CARE OF COMPOSITE ENTITIES.
    				}
    			}
    		}
    	}
    	return axiom;
    }

        public void fire() throws IllegalActionException {


        	String _momlFileStr = momlFile.getExpression();
        	System.out.println(_momlFileStr);
        	_compEnts = new LinkedList();
        	int ind = _momlFileStr.lastIndexOf("\\");
        	String base = "", fileName = "";
        	if (ind > -1) {
        		base =  _momlFileStr.substring(0,ind);
        		fileName = _momlFileStr.substring(ind+1);
        	}
        	ind = fileName.indexOf(".");
        	String outputName = "";
        	if (ind > -1) {
        		outputName = fileName.substring(0,ind) + ".pl";
        	} else {
      //  		System.out.println("file name exception");
        	}

            try {
            //	File outputFile = new File(base+"/"+outputName);
	          //  BufferedWriter out = new BufferedWriter(new FileWriter(outputFile.getAbsolutePath(), false));
	            //System.out.println(outputFile.getAbsolutePath());
	        	File _momlFile = momlFile.asFile();
	        	String path = _momlFile.getAbsolutePath();
	        	URL _momlUrl = _momlFile.toURL();

	        	_toplevel = parse(_momlUrl);

	        	String desc = _toplevel.description();
	        //	out.write(desc);

	           	CompositeEntity CE = (CompositeEntity) _toplevel;
	        	String entities = getEntities(CE);
	        //	out.write(entities);
	        	//axiom.broadcast(new StringToken(entities));

	        	String relations = getRelations();
	       // 	out.write(relations);
	        	String result =  entities + relations;
	        	axiom.broadcast(new StringToken(result));

	     //   	out.close();
	        	_toplevel = null;
	        	_compEnts = null;
	        	System.out.println("get toplevel here!");
            } catch (IOException io) {

            }
        }

        private NamedObj _toplevel = null;

        private TypedCompositeActor TCA = null;

        private List _compEnts = null;

        private String _workspace;

        private int _workspaceLen;


  ///////////////////////////////////////////////////////////////////
  ////                        public methods                     ////

    public boolean postfire() {
      return false;
    }
}