/* A thread for validating the number of processing points. 
*/

package org.geon;

import java.lang.Thread;

//////////////////////////////////////////////////////////////////////////
//// ValidationThread
/**
* Thread for validating the number of Lidar points with a user selected query attributes.
@author Efrat Jaeger  
*/
public class ValidationThread extends Thread {
    
    public ValidationThread(StringBuffer threadResp, String configFile, String MinX, String MinY, String MaxX, 
                            String MaxY, String[] classification) {
        super(); 		
        this.threadResp = threadResp;
	this.configFile = configFile;
        this.MinX = MinX;
        this.MinY = MinY;
        this.MaxX = MaxX;
        this.MaxY = MaxY;
        this.classification = classification;
        header = "";
        footer ="";
    }	

    private String configFile;
    private String header;
    private String footer;   
    private String MinX;   
    private String MinY;   
    private String MaxX;   
    private String MaxY;   
    private String[] classification;
    public long count;
    public StringBuffer threadResp;

    public void run() {

        
        LidarUtilities lutil = new LidarUtilities(threadResp, header, footer, "1005");
	lutil.setProperties(configFile);
    
        count = -1;
        count = lutil.calculateNumRows(MinX, MinY, MaxX, MaxY, classification, "0");
        
    }
}
