/* A constant source.

Copyright (c) 1998-2003 The Regents of the University of California.
All rights reserved.
Permission is hereby granted, without written agreement and without
license or royalty fees, to use, copy, modify, and distribute this
software and its documentation for any purpose, provided that the above
copyright notice and the following two paragraphs appear in all copies
of this software.

IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF
THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF
SUCH DAMAGE.

THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
ENHANCEMENTS, OR MODIFICATIONS.

                                       PT_COPYRIGHT_VERSION_2
                                       COPYRIGHTENDKEY
*/

package org.geon;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import ptolemy.actor.CompositeActor;
import ptolemy.actor.IOPort;
import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.data.ArrayToken;
import ptolemy.data.BooleanMatrixToken;
import ptolemy.data.DoubleMatrixToken;
import ptolemy.data.DoubleToken;
import ptolemy.data.IntMatrixToken;
import ptolemy.data.IntToken;
import ptolemy.data.LongMatrixToken;
import ptolemy.data.LongToken;
import ptolemy.data.RecordToken;
import ptolemy.data.StringToken;
import ptolemy.data.Token;
import ptolemy.data.UnsignedByteToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.Variable;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Port;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.moml.MoMLParser;

//////////////////////////////////////////////////////////////////////////
////XMLToOutputs
/**
Produce a constant output once. The value of the
output is that of the token contained by the <i>value</i> parameter,
which by default is an IntToken with value 1. The type of the output
is that of <i>value</i> parameter.

@author Efrat Jaeger
@version $Id: XMLToOutputs.java,v 1.4 2005/11/01 20:39:08 ruland Exp $
@since Ptolemy II 3.0.2
*/

public class XMLToOutputs extends TypedAtomicActor {

 	/** Construct an actor with the given container and name.
	  *  @param container The container.
	  *  @param name The name of this actor.
	  *  @exception IllegalActionException If the actor cannot be contained
	  *   by the proposed container.
	  *  @exception NameDuplicationException If the container already has an
	  *   actor with this name.
	  */
   	public XMLToOutputs(CompositeEntity container, String name)
           throws NameDuplicationException, IllegalActionException  {
       	super(container, name);

		input = new TypedIOPort(this, "output", true, false);
       	input.setTypeEquals(BaseType.STRING);
       	modelURL = new Parameter(this, "modelURL");
   	}

	TypedIOPort input;
   	Parameter modelURL;

   	///////////////////////////////////////////////////////////////////
   	////                         public methods                    ////


    public void attributeChanged(Attribute at) throws IllegalActionException {
    	if (at == modelURL) {
    		try {
    			String modelStr = "";
    			StringToken urlToken = null;
    			try {
	    			urlToken = ((StringToken)(modelURL.getToken()));
	    			modelStr = urlToken.stringValue();
	    			System.out.println(modelStr);
    			} catch (Exception ex) {}
    			if (modelStr == "") {
    				_prevURL = modelStr;
    			}
    	        if (modelStr != ""
    	                  && !modelStr.equals(_prevURL)) {
    	              _prevURL = modelStr;
    	            deleteOutputPorts();
    				URL url = new URL(modelStr);
	                MoMLParser parser = new MoMLParser();
	                NamedObj model;
	                try {
	                    model = parser.parse(null, url);
	                } catch (Exception ex) {
	                    throw new IllegalActionException(
	                        ex +
	                        "Failed to pass the model URL." +
	                        url.toString());
	                }
	                _workspace = model.getFullName();
	        		_workspaceLen = _workspace.length()+1;

	                CompositeActor CA = (CompositeActor) model;
	                _setOutputs(CA);

	            }
    		} catch (Exception ex) {
    			ex.printStackTrace();
    		}
      	} else {
        	super.attributeChanged(at);
      	}
    }



   	public void fire() throws IllegalActionException {
	   	try {
	   		String xml = ((StringToken) input.get(0)).stringValue();
	   		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
	        factory.setValidating(false);
	        DocumentBuilder builder = factory.newDocumentBuilder();
	        byte[] xmlBytes = xml.getBytes();
	        InputStream is = new ByteArrayInputStream(xmlBytes);
	        Document doc = builder.parse(is);

	        NodeList outputs = doc.getElementsByTagName("output");
	        for (int i = 0; i < outputs.getLength(); i++) {
	            NodeList childs = outputs.item(i).getChildNodes();
	            Token dataToken = new Token();
	            String portName = "";
	            for (int j=0; j<childs.getLength(); j++) {
	            	Node child = childs.item(j);
	            	if (child instanceof Element) {
	            		Element elem = (Element) child;
	            		String tag = elem.getTagName();
	            		if (tag.toLowerCase().trim().equals("name")) {
	            			portName = elem.getFirstChild().getNodeValue().trim();
	            		} else {
	            			dataToken = process(elem);
	            		}
	            	}
	            }
	            Port port = this.getPort(portName);
	            if (port instanceof IOPort && port != null) {
	            	IOPort p = (IOPort) port;
	            	p.broadcast(dataToken);
	            }
	        }
	   	} catch(Exception ex) {
	   		ex.printStackTrace();
	   	}
   	}

    private Token process(Element tag) throws IllegalActionException { //elem = channel..
	    String tagName = tag.getTagName();

	    if (tagName.equals("unsignedbyte")) {
	    	String val =tag.getFirstChild().getNodeValue().trim();
	    	UnsignedByteToken t = new UnsignedByteToken(val);
	    	return t;
	    }

		if (tagName.equals("int")) {
	    	String val =tag.getFirstChild().getNodeValue().trim();
	    	IntToken t = new IntToken(val);
	    	return t;
	    }

	    if (tagName.equals("double")) {
	    	String val =tag.getFirstChild().getNodeValue().trim();
	    	DoubleToken t = new DoubleToken(val);
	    	return t;
	    }

	    if (tagName.equals("long")) {
	    	String val =tag.getFirstChild().getNodeValue().trim();
	    	LongToken t = new LongToken(val);
	    	return t;
	    }

	    if (tagName.equals("intmatrix")) {
	    	NodeList rows = tag.getElementsByTagName("row");
	    	int rowNum = rows.getLength();
	    	if (rowNum>0) {
	    		NodeList tempCols = ((Element)rows.item(0)).getElementsByTagName("value");
	    		int colNum = tempCols.getLength();
	    		int[][] Mat = new int[rowNum][colNum];
	    		for (int j=0; j<rowNum; j++) {
	    			NodeList Cols = ((Element) rows.item(j)).getElementsByTagName("value");
	    			for (int k=0; k<colNum; k++) {
	    				String val = Cols.item(k).getFirstChild().getNodeValue().trim();
	    				Mat[j][k] = Integer.parseInt(val);
	    			}
	    		}
	    		IntMatrixToken t = new IntMatrixToken(Mat);
	    		return t;
	    	} else return new IntMatrixToken();
	    }

		if (tagName.equals("doublematrix")) {
	    	NodeList rows = tag.getElementsByTagName("row");
	    	int rowNum = rows.getLength();
	    	if (rowNum>0) {
	    		NodeList tempCols = ((Element)rows.item(0)).getElementsByTagName("value");
	    		int colNum = tempCols.getLength();
	    		double[][] Mat = new double[rowNum][colNum];
	    		for (int j=0; j<rowNum; j++) {
	    			NodeList Cols = ((Element) rows.item(j)).getElementsByTagName("value");
	    			for (int k=0; k<colNum; k++) {
	    				String val = Cols.item(k).getFirstChild().getNodeValue().trim();
	    				Mat[j][k] = Double.parseDouble(val);
	    			}
	    		}
	    		DoubleMatrixToken t = new DoubleMatrixToken(Mat);
	    		return t;
	    	} else return new DoubleMatrixToken();
	    }

	    if (tagName.equals("longmatrix")) {
	    	NodeList rows = tag.getElementsByTagName("row");
	    	int rowNum = rows.getLength();
	    	if (rowNum>0) {
	    		NodeList tempCols = ((Element)rows.item(0)).getElementsByTagName("value");
	    		int colNum = tempCols.getLength();
	    		long[][] Mat = new long[rowNum][colNum];
	    		for (int j=0; j<rowNum; j++) {
	    			NodeList Cols = ((Element) rows.item(j)).getElementsByTagName("value");
	    			for (int k=0; k<colNum; k++) {
	    				String val = Cols.item(k).getFirstChild().getNodeValue().trim();
	    				Mat[j][k] = Long.parseLong(val);
	    			}
	    		}
	    		LongMatrixToken t = new LongMatrixToken(Mat);
	    		return t;
	    	} else return new LongMatrixToken();
	    }

	    if (tagName.equals("booleanmatrix")) {
	    	NodeList rows = tag.getElementsByTagName("row");
	    	int rowNum = rows.getLength();
	    	if (rowNum>0) {
	    		NodeList tempCols = ((Element)rows.item(0)).getElementsByTagName("value");
	    		int colNum = tempCols.getLength();
	    		boolean[][] Mat = new boolean[rowNum][colNum];
	    		for (int j=0; j<rowNum; j++) {
	    			NodeList Cols = ((Element) rows.item(j)).getElementsByTagName("value");
	    			for (int k=0; k<colNum; k++) {
	    				String val = Cols.item(k).getFirstChild().getNodeValue().trim();
	    				Mat[j][k] = Boolean.getBoolean(val);
	    			}
	    		}
	    		BooleanMatrixToken t = new BooleanMatrixToken(Mat);
	    		return t;
	    	} else return new BooleanMatrixToken();
	    }

	    if (tagName.equals("string")) {
	    	String val = tag.getFirstChild().getNodeValue().trim();
	    	StringToken t = new StringToken(val);
	    	return t;
	    }

	    if (tagName.equals("array")) {
	    	Vector tVec = new Vector();
	    	NodeList arrChilds = tag.getChildNodes();

	    	// find only the element children
	    	for (int j=0; j< arrChilds.getLength(); j++) {
	    		if (arrChilds.item(j) instanceof Element) {

	    			Token token = process((Element)arrChilds.item(j));
	    			tVec.add(token);
	    		}
	    	}
	    	Token tArr[] = new Token[tVec.size()];
	    	tVec.toArray(tArr);
	    	ArrayToken t = new ArrayToken(tArr);
	    	return t;
	    }

	   	if (tagName.equals("record")) {
	   		NodeList labelNodes = tag.getElementsByTagName("label");
	   		NodeList valueNodes = tag.getElementsByTagName("value");
	   		int recLen = labelNodes.getLength();
	   		String[] labels = new String[recLen];
	   		Token[] tokens = new Token[recLen];
	   		for (int j=0; j<recLen; j++) {
	   			labels[j] = labelNodes.item(j).getFirstChild().getNodeValue().trim();
	   		}
	   		int k = 0;
	   		for (int j=0; j<valueNodes.getLength(); j++) {
        		Element value = (Element) valueNodes.item(j);
            	NodeList childs = value.getChildNodes();
            	for (int l=0; l<childs.getLength(); l++) {
            		Node node = childs.item(l);
            		if (node instanceof Element) {
            			tokens[k++] = process((Element) node);
            		}
            	}
	   		}
	   		RecordToken t = new RecordToken(labels, tokens);
	   		return t;
	   	}

    	Token t = new Token();
    	return t;
    }


   	private void _setOutputs(CompositeActor CA) {

    	Iterator atts = CA.attributeList().iterator();
    	while (atts.hasNext()) {
    		Attribute att =  (Attribute)atts.next();
    		if (att instanceof Variable) {
	   			String attName = att.getName();
	    		if (attName.trim().toLowerCase().startsWith("out")) {
	    			Variable var = (Variable) att;
	    			System.out.println(var.getType().toString());
	    			//TODO:: set the type according to the input port type.
					try {  //TODO: perhaps this should be the const output type which should be set previously
						TypedIOPort p = new TypedIOPort(this, attName, false, true);
						if (var.getType().equals(BaseType.UNKNOWN)) {
	        				p.setTypeEquals(BaseType.GENERAL);
	        			} else p.setTypeEquals(var.getType());
					} catch (Exception ex) {
	                    System.out.println(ex + "Failed to create input port " +
	                        attName + " of type " + var.getType());
	                }
	    		}
    		}
		}
    }




   	/** Set postfire to false.
    *  @exception IllegalActionException If thrown by the super class.
    */
   public boolean postfire() throws IllegalActionException {
   	xml = "";
     return false;
   }


   private void deleteOutputPorts() {
    List outPortList = this.outputPortList();
    Iterator ports = outPortList.iterator();
    while (ports.hasNext()) {
      IOPort p = (IOPort) ports.next();
      if (p.isOutput()) {
        try {
            p.setContainer(null);
        }
        catch (Exception e) {}
      }
    }
   }
   private String _workspace;
   private int _workspaceLen;
   private String xml = "";
   private String _prevURL;
}
