/*
 *  The node controller for actor instances.
 *  Copyright (c) 2003-2004 The Regents of the University of California.
 *  All rights reserved.
 *  Permission is hereby granted, without written agreement and without
 *  license or royalty fees, to use, copy, modify, and distribute this
 *  software and its documentation for any purpose, provided that the above
 *  copyright notice and the following two paragraphs appear in all copies
 *  of this software.
 *  IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 *  FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 *  ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF
 *  THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF
 *  SUCH DAMAGE.
 *  THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 *  INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 *  PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
 *  CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
 *  ENHANCEMENTS, OR MODIFICATIONS.
 *  PT_COPYRIGHT_VERSION_2
 *  COPYRIGHTENDKEY
 */
package org.kepler.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JOptionPane;
import javax.swing.tree.TreePath;

import org.ecoinformatics.seek.sms.OntologyCatalog;

import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.ChangeListener;
import ptolemy.kernel.util.ChangeRequest;
import ptolemy.moml.EntityLibrary;
import ptolemy.moml.MoMLChangeRequest;
import ptolemy.vergil.basic.BasicGraphFrame;

/**
 * This action adds annotations to the tree
 *
 *@author     Chad Berkley
 *@created    February 17, 2005
 */
public class AddFolderAction extends TreeAction
{
  private final static String LABEL = "New Subfolder...";
  private NewFolderFrame nfFrame;


  /**
   * Constructor
   *
   *@param  path    Description of the Parameter
   *@param  parent  Description of the Parameter
   */
  public AddFolderAction(TreePath path, Component parent)
  {
    super(path, parent, LABEL);
  }

  /**
   * event handler
   *
   *@param  e  ActionEvent
   */
  public void actionPerformed(ActionEvent e)
  {
    super.actionPerformed(e);
    Component current = parent;
    while (parent != null && !(parent instanceof BasicGraphFrame))
    {
      parent = current.getParent();
      current = parent;
    }

    nfFrame = new NewFolderFrame(parent);
    ActionHandler handler = new ActionHandler();
    nfFrame.addActionListener(handler);
    nfFrame.setVisible(true);
  }

  /**
   * Listener used to changes from the NewFolderFrame
   *
   *@author     berkley
   *@created    March 1, 2005
   */
  private class ActionHandler implements ActionListener
  {
    /**
     *  Description of the Method
     *
     *@param  event  Description of Parameter
     */
    public void actionPerformed(ActionEvent event)
    {
      String command = event.getActionCommand();

      if (command.equals("okbutton_clicked"))
      {
        final String folderName = nfFrame.getFolderName();
        String conceptName = nfFrame.getConceptName();

        //add code here to actually add a folder.
        OntologyCatalog ontCatalog = OntologyCatalog.instance();
        CompositeEntity parentFolder =
            (CompositeEntity) path.getLastPathComponent();
        String parentConceptName = ontCatalog.getConceptNameWithLabel(
            parentFolder.getName());
        nfFrame.setVisible(false);
        nfFrame.dispose();
        if (parentConceptName != null)
        {
          // if it's null, something bad has happened
          ontCatalog.addConcept(conceptName, folderName);
          ontCatalog.assignSuperConcept(conceptName, parentConceptName);
          // add the folder
          try
          {
            final EntityLibrary folder = new EntityLibrary(parentFolder, folderName);
            java.io.StringWriter writer = null;
            writer = new java.io.StringWriter();
            folder.exportMoML(writer, 1, folderName);
            ChangeRequest request = new MoMLChangeRequest(folder, writer.toString());
            request.addChangeListener(
              new ChangeListener()
              {
                public void changeExecuted(ChangeRequest change)
                {
                  notifyListeners("new_folder_created");
                }
                
                public void changeFailed(ChangeRequest change, Exception e)
                {
                  notifyListeners("new_folder_created");
                }
              });
            // perform a change request to update tree
            /*
              This should work.  It does work for new folders inside of new
              folders, but it doesn't work for new folders inside existing folders
              I don't know why it doesn't work.  
            */
            folder.requestChange(request);
            folder.executeChangeRequests();
            //request.execute();
            //notifyListeners("new_folder_created");
          }
          catch (Exception e)
          {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null,
              "Something bad has happened and the requested action was not performed ... " +
              "please send an email to kepler-dev",
              "alert",
              JOptionPane.ERROR_MESSAGE);
          }
        }
        else
        {
          JOptionPane.showMessageDialog(null,
              "Something bad has happened and the requested action was not performed ... " +
              "please send an email to kepler-dev",
              "alert",
              JOptionPane.ERROR_MESSAGE);
        }
      }
      else if (command.equals("cancelbutton_clicked"))
      {
        nfFrame.setVisible(false);
        nfFrame.dispose();
      }
    }
  }
}

