/**
 *    '$RCSfile: RunWithFeedbackChkBoxAction.java,v $'
 *
 *     '$Author: brooke $'
 *       '$Date: 2006/03/03 04:33:38 $'
 *   '$Revision: 1.3 $'
 *
 *  For Details: http://kepler.ecoinformatics.org
 *
 * Copyright (c) 2004 The Regents of the University of California.
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 * FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 *
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY
 * OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
 * UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */

package org.kepler.gui;


import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.KeyStroke;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import diva.gui.GUIUtilities;
import ptolemy.actor.gui.TableauFrame;
import ptolemy.vergil.basic.MenuMapper;


/**
 * This action opens the Kelper Cookbook, which is an html file at the
 * classpath-relative location defined by COOKBOOK_URL_STR
 *
 *@author     Matthew Brooke
 *@created    27 January 2006
 */
public class RunWithFeedbackChkBoxAction extends AbstractAction {

////////////////////////////////////////////////////////////////////////////////
// Note that these are defaults - Instantiating code will
// probably override these in a localizable manner

  private final String DISPLAY_NAME = "Run with Feedback";
  private final String TOOLTIP = "Show feedback when running workflow";
  private final ImageIcon LARGE_ICON = null;
  private final Integer MNEMONIC_KEY = new Integer(KeyEvent.VK_F);
  private final KeyStroke ACCELERATOR_KEY = null;
//    = KeyStroke.getKeyStroke(KeyEvent.VK_C, Toolkit.getDefaultToolkit().
//                             getMenuShortcutKeyMask());
////////////////////////////////////////////////////////////////////////////////

  //old PTII display names used for actionCommand
  //text, for backward compatibility
  private final String FEEDBACK_ON_PTII_DISPLAY_NAME = "Animate Execution";
  private final String FEEDBACK_OFF_PTII_DISPLAY_NAME = "Stop Animating";

  //NOTE - Keys in PTIIMenuActionsMap are all UPPERCASE
  private final String FEEDBACK_ON_PTIIMENUPATH
    = ("Debug->" + FEEDBACK_ON_PTII_DISPLAY_NAME).toUpperCase();


  //NOTE - Keys in PTIIMenuActionsMap are all UPPERCASE
  private final String FEEDBACK_OFF_PTIIMENUPATH
    = ("Debug->" + FEEDBACK_OFF_PTII_DISPLAY_NAME).toUpperCase();

  private JCheckBoxMenuItem jcbMenuItem;
  private Action feedbackOnAction;
  private Action feedbackOffAction;

  /**
   * Constructor
   *
   * @param parent the "frame" (derived from ptolemy.gui.Top) where the menu is
   *   being added.
   */
  public RunWithFeedbackChkBoxAction(TableauFrame parent) {
    super();
    if (parent == null) {
      IllegalArgumentException iae = new IllegalArgumentException(
        "RunWithFeedbackChkBoxAction constructor received NULL argument for TableauFrame");
      iae.fillInStackTrace();
      throw iae;
    }
    this.putValue(Action.NAME, DISPLAY_NAME);
    this.putValue(GUIUtilities.LARGE_ICON, LARGE_ICON);
    this.putValue(GUIUtilities.MNEMONIC_KEY, MNEMONIC_KEY);
    this.putValue("tooltip", TOOLTIP);
    this.putValue(GUIUtilities.ACCELERATOR_KEY, ACCELERATOR_KEY);

    this.putValue(MenuMapper.MENUITEM_TYPE, MenuMapper.CHECKBOX_MENUITEM_TYPE);

    MenuMapper menuMapper = parent.getMenuMapper();

    feedbackOnAction = (Action) (menuMapper.getPTIIMenuActionsMap().get(
      FEEDBACK_ON_PTIIMENUPATH));
    feedbackOffAction = (Action) (menuMapper.getPTIIMenuActionsMap().get(
      FEEDBACK_OFF_PTIIMENUPATH));

    if (feedbackOnAction == null || feedbackOffAction == null) {
      IllegalArgumentException iae = new IllegalArgumentException(
        "RunWithFeedbackChkBoxAction constructor could not get actions for "
        + FEEDBACK_ON_PTIIMENUPATH + " or " + FEEDBACK_OFF_PTIIMENUPATH);
      iae.fillInStackTrace();
      throw iae;
    }
  }


  /**
   * Invoked when an action occurs.
   *
   *@param  e  ActionEvent
   */
  public void actionPerformed(ActionEvent e) {

    if (feedbackOnAction == null || feedbackOffAction == null) {
      if (isDebugging) {
        log.debug(
          "RunWithFeedbackChkBoxAction.actionPerformed() - null Action(s):"
          + "\n feedbackOnAction = " + feedbackOnAction
          + "\n feedbackOffAction = " + feedbackOffAction);
      }
      return;
    }

    if (jcbMenuItem == null) {
      jcbMenuItem
        = (JCheckBoxMenuItem)this.getValue(MenuMapper.NEW_JMENUITEM_KEY);
    }
    if (jcbMenuItem != null) {

      boolean isChecked = jcbMenuItem.getState();

      if (isChecked) {
        log.debug("FEEDBACK_ON");

        //NOTE - PTII uses ActionCommands for some listeners;
        //need to set this to PTII display name so it works...
        jcbMenuItem.setActionCommand(FEEDBACK_ON_PTII_DISPLAY_NAME);

        feedbackOnAction.actionPerformed(e);
      } else {
        log.debug("FEEDBACK_OFF");

        //NOTE - PTII uses ActionCommands for some listeners;
        //need to set this to PTII display name so it works...
        jcbMenuItem.setActionCommand(FEEDBACK_OFF_PTII_DISPLAY_NAME);

        feedbackOffAction.actionPerformed(e);
      }
    }
  }


  private static final Log log
    = LogFactory.getLog("UI." + RunWithFeedbackChkBoxAction.class.getName());

  private static final boolean isDebugging = log.isDebugEnabled();

}
