/**
 * Copyright (c) 2005 The Regents of the University of California.
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 * FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 *
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY
 * OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
 * UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */
package org.kepler.scia;


/*-------------------------------------------------------------------------------
  Vitaliy Zavesov
  Jan. 22, 2006

  File Name:      HelpViewer.java
  Description:    This class serves as an simple viewer to open help files.
  -----------------------------------------------------------------------------*/
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileOutputStream;
import java.io.PrintWriter;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;


public class HelpViewer extends JFrame {
    // global variables so that they could be set
    private String message;

    // global variables so that they could be set
    private String text;
    JPanel contentPane = new JPanel(new BorderLayout());
    JButton okButton;
    JTextArea textArea;

    // constructor
    public HelpViewer(final String tit, final String mes, final String tex) {
        setTitle(tit);

        // setting the global variable
        message = mes;
        text = tex;

        // position our popup window in the center of the screen
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension d = tk.getScreenSize();

        setLocation((d.width / 2) - 250, (d.height / 2) - 50);
        setSize(500, 500);

        // setting up the panel with a text area
        textArea = new JTextArea(text, 20, 40);

	int fontSize = textArea.getFont().getSize();
	int fontStyle = textArea.getFont().getStyle();
	Font newFont = new Font("Courier", fontStyle, fontSize);

	textArea.setFont(newFont);

        JScrollPane areaScrollPane = new JScrollPane(textArea,
                JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,
                JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
        areaScrollPane.setPreferredSize(new Dimension(400, 400));

        JLabel label = new JLabel(message);
        JPanel labPan = new JPanel();
        labPan.add(label);

        okButton = new JButton("OK");

        ActionListener aLok = new ActionListener() {
                public void actionPerformed(ActionEvent ae) {
                    if (ae.getSource() == okButton) {
                        hide();
                    }
                }
            };

        okButton.addActionListener(aLok);

        JPanel buttonPan = new JPanel();
        buttonPan.add(okButton);
        contentPane.add(buttonPan, BorderLayout.SOUTH);

        contentPane.add(labPan, BorderLayout.NORTH);
        contentPane.add(areaScrollPane, BorderLayout.CENTER);

        setContentPane(contentPane);
    }
}
