/**
 *  '$RCSfile: LSIDRepository.java,v $'
 *    Purpose: A Class that implements a metadata catalog as a java Servlet
 *  Copyright: 2000 Regents of the University of California and the
 *             National Center for Ecological Analysis and Synthesis
 *    Authors: Matt Jones, Dan Higgins, Jivka Bojilova, Chad Berkley
 *    Release: @release@
 *
 *   '$Author: berkley $'
 *     '$Date: 2006/03/21 23:33:10 $'
 * '$Revision: 1.2 $'
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.kepler.servlet;

import java.io.*;
import java.util.*;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import com.oreilly.servlet.multipart.FilePart;
import com.oreilly.servlet.multipart.MultipartParser;
import com.oreilly.servlet.multipart.ParamPart;
import com.oreilly.servlet.multipart.Part;

import org.kepler.objectmanager.lsid.LSIDTree;
import org.kepler.objectmanager.lsid.KeplerLSID;


/**
 * a repository for LSIDs.
 * 
 * The actions are:
 * addlsid: add an lsid specified in the lsid param
 * getnextrevision: return the next possible revision for the id passed
 *   in the lsid param
 * getnextobject: return the next possible object number for the id passed
 *   in the lsid param
 * isregistered: return true of the id passed in the lsid param is already in
 *   the registry
 */
public class LSIDRepository extends HttpServlet
{
  //the file to write the lsids to
  private File lsidFile = new File("lsidFile.txt");
  
  /**
   * init the servlet
   */
  public void init(ServletConfig config) throws ServletException
  {
    
  }
  
  /**
   * destroy the servlet
   */
  public void destroy()
  {
    
  }
  
  /**
   * handle a get requestion
   */
  public void doGet(HttpServletRequest request, HttpServletResponse response)
            throws ServletException, IOException
  {
    handleGetOrPost(request, response);
  }

  /**
   * handle a post request
   */
  public void doPost(HttpServletRequest request, HttpServletResponse response)
          throws ServletException, IOException
  {
    handleGetOrPost(request, response);
  }
  
  /**
   * handle a get or post request
   */
  private void handleGetOrPost(HttpServletRequest request,
            HttpServletResponse response) throws ServletException, IOException
  {
    String ctype = request.getContentType();

    String name = null;
    String[] value = null;
    String[] docid = new String[3];
    Hashtable params = new Hashtable();
    Enumeration paramlist = request.getParameterNames();

    while (paramlist.hasMoreElements()) 
    {
      name = (String) paramlist.nextElement();
      value = request.getParameterValues(name);

      // Decode the docid and mouse click information
      if (name.endsWith(".y")) 
      {
        docid[0] = name.substring(0, name.length() - 2);
        params.put("docid", docid);
        name = "ypos";
      }
      
      if (name.endsWith(".x")) 
      {
          name = "xpos";
      }

      params.put(name, value);
    }

    //handle param is emptpy
    if (params.isEmpty() || params == null) { return; }

    //if the user clicked on the input images, decode which image
    //was clicked then set the action.
    if(params.get("action") == null){
        PrintWriter out = response.getWriter();
        response.setContentType("text/xml");
        out.println("<?xml version=\"1.0\"?>");
        out.println("<error>");
        out.println("Action not specified");
        out.println("</error>");
        out.close();
        return;
    }

    String action = ((String[]) params.get("action"))[0];
    System.out.println("Action is: " + action);
    
    if (action.equals("addlsid")) 
    {
        PrintWriter out = response.getWriter();
        handleAddAction(out, params, request, response);
        out.close();
    }
    else if (action.equals("getnextrevision")) 
    {
        PrintWriter out = response.getWriter();
        handleGetNextRevisionAction(out, params, request, response);
        out.close();
    }
    else if (action.equals("getnextobject")) 
    {
        PrintWriter out = response.getWriter();
        handleGetNextObjectAction(out, params, request, response);
        out.close();
    }
    else if (action.equals("isregistered")) 
    {
        PrintWriter out = response.getWriter();
        handleIsRegisteredAction(out, params, request, response);
        out.close();
    }
  }
  
  /**
   * handle the add action
   */
  private void handleAddAction(PrintWriter out, Hashtable params, 
    HttpServletRequest request, HttpServletResponse response)
  {
    try
    {
      LSIDTree tree = LSIDTree.getInstance(lsidFile);
      String lsid = ((String[])params.get("lsid"))[0];
      KeplerLSID klsid = new KeplerLSID(lsid);
      tree.addLSID(klsid);
      printSuccess(out, response, lsid);
      return;
    }
    catch(Exception e)
    {
      printError(out, response, e);
    }
  }
  
  /**
   * handle the get next object action
   */
  private void handleGetNextObjectAction(PrintWriter out, Hashtable params, 
    HttpServletRequest request, HttpServletResponse response)
  {
    try
    {
      LSIDTree tree = LSIDTree.getInstance(lsidFile);
      String lsid = ((String[])params.get("lsid"))[0];
      KeplerLSID klsid = new KeplerLSID(lsid);
      KeplerLSID newLsid = tree.getNextObject(klsid, false);
      printSuccess(out, response, newLsid.toString());
      return;
    }
    catch(Exception e)
    {
      printError(out, response, e);
    }
  }
  
  /**
   * handle the get next revision action
   */
  private void handleGetNextRevisionAction(PrintWriter out, Hashtable params, 
    HttpServletRequest request, HttpServletResponse response)
  {
    try
    {
      LSIDTree tree = LSIDTree.getInstance(lsidFile);
      String lsid = ((String[])params.get("lsid"))[0];
      KeplerLSID klsid = new KeplerLSID(lsid);
      KeplerLSID newLsid = tree.getNextRevision(klsid, false);
      printSuccess(out, response, newLsid.toString());
      return;
    }
    catch(Exception e)
    {
      printError(out, response, e);
    }
  }
  
  /**
   * handle the is registered action
   */
  private void handleIsRegisteredAction(PrintWriter out, Hashtable params, 
    HttpServletRequest request, HttpServletResponse response)
  {
    try
    {
      LSIDTree tree = LSIDTree.getInstance(lsidFile);
      String lsid = ((String[])params.get("lsid"))[0];
      KeplerLSID klsid = new KeplerLSID(lsid);
      if(tree.isRegistered(klsid))
      {
        printSuccess(out, response, "true");
      }
      else
      {
        printSuccess(out, response, "false");
      }
    }
    catch(Exception e)
    {
      printError(out, response, e);
    }

    
  }
  
  /**
   * print and error message using the exception
   */
  private void printError(PrintWriter out, HttpServletResponse response, 
    Exception e)
  {
    response.setContentType("text/xml");
    out.println("<?xml version=\"1.0\"?>");
    out.println("<error>");
    out.println(e.getMessage() + "\n\n");
    e.printStackTrace(out);
    out.println("\n\n");
    out.println("</error>");
    out.close();
  }
  
  /**
   * print a success message.
   */
  private void printSuccess(PrintWriter out, HttpServletResponse response, 
    String msg)
  {
    response.setContentType("text/xml");
    out.println("<?xml version=\"1.0\"?>");
    out.println("<success>");
    out.println(msg);
    out.println("\n\n");
    out.println("</success>");
    out.close();
  }
}