/**
 *    '$RCSfile: OntologyConfiguration.java,v $'
 *
 *     '$Author: bowers $'
 *       '$Date: 2005/10/18 23:29:14 $'
 *   '$Revision: 1.2 $'
 *
 *  For Details: http://kepler.ecoinformatics.org
 *
 * Copyright (c) 2004 The Regents of the University of California.
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 * FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 *
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY
 * OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
 * UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */

package org.kepler.sms.util;


import java.util.*;
import javax.xml.parsers.*;
import org.xml.sax.*;
import java.io.*;
import org.w3c.dom.*;


/**
 * This class reads in ontology_catalog.xml and returns the set of
 * ontologies. It also gives those that are suitable as library
 * categorizations.
 */
public class OntologyConfiguration { 
    
    /**
     * This is a singleton class, so the constructor is "hidden"
     */
    protected OntologyConfiguration() {
	initialize();
    }

    /**
     * Initialize the catalog
     * TODO: read from config file
     */
    protected void initialize() {
	// load the index file
	try {
	    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
	    DocumentBuilder builder = factory.newDocumentBuilder();
	    _document = builder.parse(new File(INDEX_FILE));
	} catch (SAXException sxe) {
	    Exception  x = sxe;
	    if (sxe.getException() != null)
		x = sxe.getException();
	    x.printStackTrace();
	} catch (ParserConfigurationException pce) {
	    pce.printStackTrace();
	} catch (IOException ioe) {
	    ioe.printStackTrace();
	}
    }


    /**
     * This method must be called to create/obtain an instance of the catalog
     * @return The unique instance of this class
     */
    public static OntologyConfiguration instance() {
	if (_config == null)
	    _config = new OntologyConfiguration();
	return _config;
    }    

    /**
     * Get the file path names for the ontologies
     */
    public Iterator getFilePathNames() {
	Vector result = new Vector();
	if(_document == null)
	    return result.iterator();

	// get the root
	Element root = _document.getDocumentElement();
	if(root == null)
	    return result.iterator();
	
	// iterate through root, get each ontology element and its
	// filename
	NodeList lst = root.getElementsByTagName("ontology");
	for(int i = 0; i < lst.getLength(); i++) {
	    Element elem = (Element)lst.item(i);
	    Attr att = elem.getAttributeNode("filename");
	    if(att != null) {
		String filename = att.getValue();
		if(filename != null)
		    result.addElement(ONTO_PATH + filename);
	    }
	}
	
	return result.iterator();
    }


    /**
     * @return True if the filepath is suitable as a library categorization.
     */
    public boolean isLibraryOntology(String filepath) {
	if(_document == null || filepath == null)
	    return false;

	// get the root
	Element root = _document.getDocumentElement();
	if(root == null)
	    return false;
	// iterate to find the ontology with filepath
	NodeList lst = root.getElementsByTagName("ontology");
	for(int i = 0; i < lst.getLength(); i++) {
	    Element elem = (Element)lst.item(i);
	    Attr att = elem.getAttributeNode("filename");
	    if(att != null) {
		String filename = att.getValue();
		if(filepath.equals(ONTO_PATH + filename)) {
		    Attr libatt = elem.getAttributeNode("library");
		    if(libatt != null) {
			String library = libatt.getValue();
			if(library != null && library.equals("true"))
			    return true;
		    }
		}
	    }
	}
	return false;
    }


    /* PRIVATE MEMBERS */

    private static OntologyConfiguration _config = null; // singleton instance
    private String KEPLER = System.getProperty("KEPLER");
    private String ONTO_PATH = KEPLER + "/configs/ptolemy/configs/kepler/ontologies/"; 
    private String INDEX_FILE = ONTO_PATH + "ontology_catalog.xml";
    private Document _document; // the ontology document


}
