/* JGridletCreater    .....................

  Copyright (c) 2005 The Regents of the University of California.
 All rights reserved.

  Permission is hereby granted, without written agreement and without
 license or royalty fees, to use, copy, modify, and distribute this
 software and its documentation for any purpose, provided that the above
 copyright notice and the following two paragraphs appear in all copies
 of this software.

 IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF
 THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF
 SUCH DAMAGE.

 THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
 CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
 ENHANCEMENTS, OR MODIFICATIONS.

                                        PT_COPYRIGHT_VERSION_2
                                        COPYRIGHTENDKEY

*/

package org.monash.griddles;

import ptolemy.actor.TypedAtomicActor;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.actor.TypedIOPort;
import ptolemy.data.expr.StringParameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.util.StringAttribute;
import ptolemy.moml.EntityLibrary;
import java.io.File;
import org.kepler.objectmanager.lsid.KeplerLSID;
import org.kepler.objectmanager.lsid.LSIDGenerator;
import org.kepler.moml.NamedObjId;
import org.kepler.sms.SemanticType;
import org.kepler.ksw.KSWBuilder;

//import ptolemy.kernel.util.NamedObj;
//import org.sdm.spa.util.ActorInspector;
import java.util.Iterator;
import java.util.List;
import ptolemy.kernel.util.ConfigurableAttribute;
import ptolemy.data.expr.Parameter;

/*
   *  Gridlet is a dynamically created GriddLeS actor in the Kepler user interface. 
   *  This encapsulates functionality of either GriddlesExec or GriddlesRemoteExec 
   *  actors along with additional application specific information which could be 
   *  configured through the Kepler user interface when used. The GriddlesExec actor 
   *  is used while creating gridlet for executing command on the machine where the 
   *  Kepler process has been started, whereas the GriddlesRemoteExec actor is used 
   *  for creating gridlets that run commands on remote locations. The corresponding 
   *  actors that create gridlets are GridletCreator and GridletRemoteCreator respectively. 
   *  These actors hold configurable name of the gridlet along with list of input and output 
   *  ports, to create the gridlet with a specific name. They add a number of ports to it, 
   *  which store it in the Kepler library under griddles/gridlet with a local LSID (a Uniform 
   *  Resource Name (URN) specification) and can be annotated using a Kepler actor classification 
   *  ontology. While creating gridlets it is also possible to add additional attributes that are 
   *  needed by the application. These attribute values can also be configured through the Kepler 
   *  user interface while using gridlets. In this way different dynamic actors could be created 
   *  on the actor library depending on the chosen ontology and application. The gridlets are 
   *  dragged and dropped on to the Kepler�s vergil design interface for creating simple to complex 
   *  workflows or vitual applications.
   *
   *  This JGridletCreater actor creates new GriddlesExec actor with additional 
   *  input and output ports as specified in inPortsList, outPortList ....
   *  paramenters
   *  These parameters are configured through Kepler user interface .....
   * The other parameter needs to set is the unique name of the gridlet actor 
   *   and is also configured throught Kepler user interface      
   *  @author Jagan Kommineni, Monash University July 2005
   *  @version $Id: JGridletCreater.java,v 1.7 2006/03/12 10:22:20 mangal Exp $
 */


public class JGridletCreater extends TypedAtomicActor {
  /** Construct a WebService actor with the given container and name.
   *  @param container The container.
   *  @param name The name of this actor.
   *  @exception IllegalActionException If the actor cannot be contained
   *   by the proposed container.
   *  @exception NameDuplicationException If the container already has an
   *   actor with this name.
   */
  public JGridletCreater(CompositeEntity container, String name) throws
                                             NameDuplicationException, IllegalActionException {
    super(container, name);
    actorName = new StringAttribute(this, "actorName");
    actorName.setExpression("localActorName");
    inPortsList = new StringAttribute(this, "inPortsList");
    inPortsList.setExpression("inPortsListSeperatedByColon:");
    outPortsList = new StringAttribute(this, "outPortsList");
    outPortsList.setExpression("outPortsListSeperatedByColon:");
    //parameters = new StringAttribute(this, "parameters");
    //parameters.setExpression("add_new_params_by_seperating_with_:");
    //repositoryURL = new FileParameter(this, "repositoryURL");
    } // end of constructor
  ///////////////////////////////////////////////////////////////////
  ////                     ports and parameters                  ////

  // The url or the path of the wsdl list/repository.
  // public FileParameter repositoryURL;
  // The keywords for the selection of web services.
  //public StringAttribute parameters;
  public StringAttribute actorName;
  public StringAttribute inPortsList;
  public StringAttribute outPortsList;
  public File WSmomlfile;
  private CompositeEntity container;
  ///////////////////////////////////////////////////////////////////
  ////                        public methods                     ////

  /** Callback for changes in attribute values
   *  Get the file or url selected.
   *
   *  @param a The attribute that changed.
   *  @exception IllegalActionException If the offsets array is not
   *   nondecreasing and nonnegative.
   */
  public void attributeChanged(Attribute at) throws IllegalActionException {

    //   if (at == repositoryURL) {
    // FIX ME: I'm no sure what to do when the user changes the wsdl
    //       list/repository. We can either clean the pre-constructed folders,
    //       or we can add new actors. The actor folder will be too big if
    //       we don't delete the actors.
    //  } //end of if (at == wsdlUrl)
    } // end of attributeChanged

  /** Grab the WSDL urls from the file or repository url given.
   *
   *  @exception IllegalActionException If there is no director.
   */
  public void fire() throws IllegalActionException {
    super.fire();    
    try  
      {                        
      GriddlesExec gridlet = null;          
      _actorNameStr = actorName.getExpression();
      EntityLibrary container = new EntityLibrary();
      gridlet = new GriddlesExec(container, _actorNameStr);                     
      File kswFile = new File("kar/griddles/"+_actorNameStr+".kar");
      LSIDGenerator lsidGenerator = LSIDGenerator.getInstance();
      KeplerLSID lsid = lsidGenerator.getNewLSID("actor1");
      System.out.println("karLSID: " + lsid);
      NamedObjId objId = new NamedObjId(gridlet, "entityId");     
      objId.setContainer(gridlet);
      objId.setExpression(lsid.toString()); 
      SemanticType semanticType = new SemanticType(gridlet, "semanticType00");
      semanticType.setContainer(gridlet);
      semanticType.setExpression("urn:lsid:localhost:onto:1:1#PreConfiguredGridletActor");

      
      
      String inPortsStr = inPortsList.getExpression();
      if(inPortsStr.length() > 1) 
        {
        String inPortsArray[] = inPortsStr.split(":");
        for(int j=0;j<inPortsArray.length;j++) 
          {
          TypedIOPort inp = (TypedIOPort) gridlet.newPort("inp-"+inPortsArray[j]);
	  inp.setTypeEquals(BaseType.STRING);
          //Change the line above with:
	  // inp.setTypeEquals(convertTypeToPTIIType(typestr));
          //inp.setTypeEquals(convertTypeToPTIIType(BaseType.STRING));
	  inp.setInput(true); 
          StringParameter inPortParam = (StringParameter)gridlet.newStringParameter(inPortsArray[j]);
          inPortParam.setExpression(inPortsArray[j]); 
          }
        }
      String outPortsStr = outPortsList.getExpression();  
      if(outPortsStr.length() > 1) 
        {
        String outPortsArray[] = outPortsStr.split(":");
        for(int j=0;j<outPortsArray.length;j++)
          {
          TypedIOPort outp = (TypedIOPort) gridlet.newPort("outp-"+outPortsArray[j]);
	  outp.setTypeEquals(BaseType.STRING);              
	  //Change the line above with:
	  //outp.setTypeEquals(convertTypeToPTIIType(BaseType.STRING));
	  outp.setOutput(true); 
          StringParameter outPortParam = (StringParameter)gridlet.newStringParameter(outPortsArray[j]);
          outPortParam.setExpression(outPortsArray[j]); 
          }
        }                 
      String strParametersArray[] ="modelReference:executionHost:webServicePort".split(":");
      for(int j=0;j<strParametersArray.length;j++) 
        {
        StringParameter addParam = (StringParameter)gridlet.newStringParameter(strParametersArray[j]);
        addParam.setExpression(strParametersArray[j]); 
        }      
    //  for(int j=0;j<addParametersArray.length;j++)
    //    {
    //     StringParameter addParam = (StringParameter)gridlet.newStringParameter(addParametersArray[j]);
    //     addParam.setExpression(addParametersArray[j]); 
    //     }

/*
      List attrs = gridlet.attributeList();
      System.out.println("Attributes: " + attrs);
      Iterator it = gridlet.attributeList().iterator();
      while(it.hasNext()) 
        {
        Attribute at = (Attribute) it.next();
        String name = at.getName();
        String value;
        if(at instanceof Parameter) 
          {
          value = at.toString();
            System.out.println("In the loop if name="+name+" value="+value);
           if(name.equalsIgnoreCase("command"))
             {
              System.out.println("I am removing attibute from the container if side");       
             at.setContainer(null);        
             }        
           } 
         else if (at instanceof ConfigurableAttribute) 
           {
           value = ((ConfigurableAttribute)at).getExpression();
            } 
          else 
            {
            value = "";
            }
            System.out.println("name="+name+" value="+value);
        }
        
*/    
      KSWBuilder ksw = new KSWBuilder(gridlet , false , kswFile);
      GriddlesUtil.processKSW(kswFile); 
 
/*
     System.out.println("Printing Component Items");
     LibraryIndex index = LibraryIndex.getInstance();
     for ( Iterator iter = index.items(); iter.hasNext(); )
       {
       LibraryIndexComponentItem key = (LibraryIndexComponentItem) iter.next();
       System.out.println( key );
       }
      System.out.println("Printing Ontologies");
      for ( Iterator iter = index.ontologies(); iter.hasNext(); )
       {
       LibraryIndexOntologyItem key = (LibraryIndexOntologyItem) iter.next();
       System.out.println( key );
       }
*/      
      }
    catch (Exception e) {
      System.out.println(e);
      }
    } // end of fire

    
    
  /** There's nothing to initialize currently.
   *  @exception IllegalActionException If the parent class throws it.
   */
  public void initialize() throws IllegalActionException {
    super.initialize();
    } // end of initialize

  /** Post fire the actor. Return false to indicate that the
   * process has finished. If it returns true, the process will
   * continue indefinitely.
   */
  public boolean postfire() {
    return false;
    } // end of postfire

  /** Pre fire the actor.
   *  Calls the super class's prefire in case something is set there.
   */
  public boolean prefire() throws IllegalActionException {
    return super.prefire();
    } // end of prefire
  //////////////////////////////////////////////////////////////////////
  ////                         private variables                    ////
 
  // The name of the method that this web service actor binds to
  String _actorNameStr = new String();
  
  }