/* CollectionPort that buffers tokens and later sends them to another port.
 *
 * Copyright (c) 2005 Natural Diversity Discovery Project.
 * All rights reserved.
 * 
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 * 
 * IN NO EVENT SHALL THE NATURAL DIVERSITY DISCOVERY PROJECT BE LIABLE 
 * TO ANY PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR 
 * CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND 
 * ITS DOCUMENTATION, EVEN IF THE NATURAL DIVERSITY DISCOVERY PROJECT
 * HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * THE NATURAL DIVERSITY DISCOVERY PROJECT SPECIFICALLY DISCLAIMS ANY 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE NATURAL 
 * DIVERSITY DISCOVERY PROJECT HAS NO OBLIGATION TO PROVIDE MAINTENANCE, 
 * SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

   @ProposedRating Red (tmcphillips@naturaldiversity.org)
   @AcceptedRating Red (tmcphillips@naturaldiversity.org) 
 */
 
package org.nddp;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import ptolemy.data.Token;
import ptolemy.kernel.util.IllegalActionException;

public class CollectionPortBuffer implements CollectionPort {

    public CollectionPortBuffer() {
        super();
    }

	///////////////////////////////////////////////////////////////////
	////                         public methods                    //// 

    public void clear() {
        tokenBuffer.clear();
    }
    
    public void flushToPort(CollectionPort port) throws IllegalActionException {

        if (port == null) {
            throw new NullPointerException("Null collectionPort not allowed.");
        }
        
        for (Iterator i = tokenBuffer.iterator(); i.hasNext(); ) {
                port.send((Token)i.next());
        }

        tokenBuffer.clear();
    }

    public Token get() {
        
        try {
	        return (Token)tokenBuffer.remove(0);
        } 
        catch(IndexOutOfBoundsException exception) {
            return null;
        }
    }
    
    public Token get(boolean unused) {
    		return get();
    }
    
    public void send(Token token) throws IllegalActionException {

        if (token == null) {
            throw new NullPointerException("Null token not allowed.");
        }
        
        tokenBuffer.add(token);
    }
    
    public int size() {
        return tokenBuffer.size();
    }

    ///////////////////////////////////////////////////////////////////
	////                         private variables                 ////
	
    private List tokenBuffer = new LinkedList();
}
