/* TODO One line description of class.
 *
 * Copyright (c) 2005 Natural Diversity Discovery Project.
 * All rights reserved.
 * 
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 * 
 * IN NO EVENT SHALL THE NATURAL DIVERSITY DISCOVERY PROJECT BE LIABLE 
 * TO ANY PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR 
 * CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND 
 * ITS DOCUMENTATION, EVEN IF THE NATURAL DIVERSITY DISCOVERY PROJECT
 * HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * THE NATURAL DIVERSITY DISCOVERY PROJECT SPECIFICALLY DISCLAIMS ANY 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE NATURAL 
 * DIVERSITY DISCOVERY PROJECT HAS NO OBLIGATION TO PROVIDE MAINTENANCE, 
 * SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

   @ProposedRating Red (tmcphillips@naturaldiversity.org)
   @AcceptedRating Red (tmcphillips@naturaldiversity.org) 
 */
 
package org.nddp.actors.phylip;

import java.io.IOException;

import org.nddp.actors.EnvironmentActor;
import org.nddp.exceptions.ExternalApplicationException;
import org.nddp.util.ProcessEnvironment;
import org.nddp.util.ProcessRunnerConcrete;

import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;

/**
 * @nddp.actor type="phylogenetics"
 *
 *  @author Timothy M. McPhillips
 */

public class RunDrawgram extends EnvironmentActor {

    public RunDrawgram(CompositeEntity container, String name)
    throws NameDuplicationException, IllegalActionException  {
        
        super(container, name);
    }

    ///////////////////////////////////////////////////////////////////
    ////                         public methods                    ////

    public void fire() throws IllegalActionException {
 
        // call superclass method
        super.fire();
        
        // get a reference to the process environment
        ProcessEnvironment processEnvironment = receiveEnvironment();

        // run drawgram
        try {
            
            // create a new process runner and start consense
            ProcessRunnerConcrete runner = new ProcessRunnerConcrete(
                processEnvironment, System.getProperty("PHYLIP_EXE_DIR") + "/drawgram");
        
            // write to the standard input of consense
            _writeStandardInput(runner);
            
            // wait for consense to complete
            runner.waitForProgramCompletion();

        } catch (ExternalApplicationException e) {
            e.printStackTrace();
        }

        // forward the process environment
        sendEnvironment();
    }
 
    private void _writeStandardInput(ProcessRunnerConcrete runner) 
        throws ExternalApplicationException {
    
        try {
            // sprecify the font file to use
            runner.writeToProcess(System.getProperty("PHYLIP_EXE_DIR") + "/font3");

            // specify custom output device (svg)
            runner.writeToProcess("P");           
            runner.writeToProcess("U");
                
            // specify width of svg canvas in cm 
            runner.writeToProcess("14");          

            // specify height of svg canvas in cm 
            runner.writeToProcess("11");
                
            // request no preview device
            runner.writeToProcess("V");           
            runner.writeToProcess("N");           
                
            runner.writeToProcess("F");
            runner.writeToProcess("Times");

            // accept configuration and begin execution
            runner.writeToProcess("Y");
                
        } catch (IOException e) {
            throw new ExternalApplicationException(
                "Error writing to DRAWGRAM process");
        }                     
    }    
    
    ///////////////////////////////////////////////////////////////////
    ////                    private variables                      ////
 
    private static final long serialVersionUID = 1L;
}
