/* Actor that constructs record tokens from incoming data.
 *
 * Copyright (c) 2005 Natural Diversity Discovery Project.
 * All rights reserved.
 * 
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 * 
 * IN NO EVENT SHALL THE NATURAL DIVERSITY DISCOVERY PROJECT BE LIABLE 
 * TO ANY PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR 
 * CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND 
 * ITS DOCUMENTATION, EVEN IF THE NATURAL DIVERSITY DISCOVERY PROJECT
 * HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * THE NATURAL DIVERSITY DISCOVERY PROJECT SPECIFICALLY DISCLAIMS ANY 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE NATURAL 
 * DIVERSITY DISCOVERY PROJECT HAS NO OBLIGATION TO PROVIDE MAINTENANCE, 
 * SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

   @ProposedRating Red (tmcphillips@naturaldiversity.org)
   @AcceptedRating Red (tmcphillips@naturaldiversity.org) 
 */
 
package org.nddp.coactors;

import java.util.Iterator;

import org.nddp.AtomicCoactor;
import org.nddp.CollectionIOPort;

import ptolemy.data.RecordToken;
import ptolemy.data.Token;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.*;

/**
 * @nddp.coactor type="general"
 */
public class RecordAssembler extends AtomicCoactor {

	public RecordAssembler(CompositeEntity container, String name)
        throws NameDuplicationException, IllegalActionException  {

        super(container, name);
        		
		output = CollectionIOPort.createOutputPort(this, "output");	
	
		/* specify the shape of the icon representing this actor using svg */
        _attachText("_iconDescription", "<svg>\n" +
            "<rect x=\"0\" y=\"0\" "
            + "width=\"60\" height=\"90\" "
            + "style=\"fill:white\"/>\n" +
            "</svg>\n");
    }

	///////////////////////////////////////////////////////////////////
	////                         public variables                  ////
	
    public CollectionIOPort output;

	///////////////////////////////////////////////////////////////////
	////                         public methods                    //// 

    public void fire() throws IllegalActionException {
 
        // call the superclass' fire method
        super.fire();

        for (int i = 0; i < _recordLabels.length; i++) {
        		_recordTokens[i] = _ports[i].get();
    		}
        
        output.send(new RecordToken(_recordLabels, _recordTokens));
    }
	
    public void initialize() throws IllegalActionException {
        
		// call the superclass's initialize method
		super.initialize();
		
		int portCount = inputPortList().size();
		
		if ( portCount == 0 ) {
			throw new IllegalActionException(this, 
		        "Must define one or more input ports.");
		}

		_recordLabels = new String[portCount];
		_recordTokens = new Token[portCount];
		_ports = new CollectionIOPort[portCount];

		int i = 0;
		for (Iterator iterator = inputPortList().iterator(); 
				iterator.hasNext(); i++) {    
		    
		    	_ports[i] = (CollectionIOPort)(iterator.next());
		    	_recordLabels[i] = _ports[i].getName();
		}
    }

	///////////////////////////////////////////////////////////////////
	////                         private variables                 ////

    private CollectionIOPort[] _ports;
    private String[] _recordLabels;
    private Token[] _recordTokens;
}
