/* Wrapper actor for Phylip CONSENSE.
 *
 * Copyright (c) 2005 Natural Diversity Discovery Project.
 * All rights reserved.
 * 
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 * 
 * IN NO EVENT SHALL THE NATURAL DIVERSITY DISCOVERY PROJECT BE LIABLE 
 * TO ANY PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR 
 * CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND 
 * ITS DOCUMENTATION, EVEN IF THE NATURAL DIVERSITY DISCOVERY PROJECT
 * HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * THE NATURAL DIVERSITY DISCOVERY PROJECT SPECIFICALLY DISCLAIMS ANY 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE NATURAL 
 * DIVERSITY DISCOVERY PROJECT HAS NO OBLIGATION TO PROVIDE MAINTENANCE, 
 * SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

   @ProposedRating Red (tmcphillips@naturaldiversity.org)
   @AcceptedRating Red (tmcphillips@naturaldiversity.org) 
 */
package org.nddp.coactors.phylogeny;

import org.nddp.AtomicCoactor;
import org.nddp.CollectionHandler;
import org.nddp.CollectionManager;
import org.nddp.DomainObject;
import org.nddp.exceptions.CollectionException;
import org.nddp.exceptions.CollectionStructureException;
import org.nddp.exceptions.InconsistentDataException;
import org.nddp.phylogeny.phylip.PhylipDnadistRunner;
import org.nddp.phylogeny.CharacterMatrix;
import org.nddp.phylogeny.DistanceMatrix;
import org.nddp.util.Parameters;
import org.nddp.util.ProcessRunner;
import org.nddp.util.ProcessRunningActor;

import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;

/**
 * @nddp.coactor type="phylogenetics"
 */
public class PhylipDnadist extends ProcessRunningActor {

    public PhylipDnadist(CompositeEntity container, String name)
        	throws NameDuplicationException, IllegalActionException {
        
        super(container, name);

        method = Parameters.stringParameter(this, "method", "F84");
        
        Parameters.fix(collectionPath, "Nexus/");
    }

//    public static class DistanceMethod {
//        private DistanceMethod(String name) {}
//    }

	///////////////////////////////////////////////////////////////////
	////                         public variables                  ////

    
    public Parameter method;

	///////////////////////////////////////////////////////////////////
	////                         public methods                    //// 

    public void initialize() throws IllegalActionException {
 
       	super.initialize();

       	_nexusCollectionManager = null;
    }

	///////////////////////////////////////////////////////////////////
	////                      protected methods                    //// 

    protected void _configureRunner() throws InconsistentDataException {

        PhylipDnadistRunner runner = (PhylipDnadistRunner)_runner;
	    runner.setCharacterMatrix(_characterMatrix);
    }

    protected ProcessRunner _getRunnerInstance() {
        
        	return new PhylipDnadistRunner();
    }

    public void _handleCollectionEnd(CollectionManager collectionManager) 
  		throws IllegalActionException, CollectionException {
    
		if (collectionManager == _nexusCollectionManager) {
		    
		    if (_characterMatrix != null) {
				_runProgram();
				DistanceMatrix distanceMatrix = (DistanceMatrix)_runResult;
			    _nexusCollectionManager.addDomainObject(distanceMatrix);
			   	
				_nexusCollectionManager = null;
		    }
		}
    }

    public CollectionHandler.CollectionDisposition _handleCollectionStart(CollectionManager 
        collectionManager) throws IllegalActionException {
    
	    	_nexusCollectionManager = collectionManager;
	    	_characterMatrix = null;
	        	
      	return  CollectionHandler.PROCESS_AND_FORWARD_COLLECTION;
    }

    public CollectionHandler.TokenDisposition _handleDomainObject(
        	CollectionManager fileCollectionManager, DomainObject object)
		throws IllegalActionException, CollectionException {

        	if (object instanceof CharacterMatrix) {
        	    
            if (_characterMatrix == null) {
		        _characterMatrix = (CharacterMatrix)object;
            } else {
                throw new CollectionStructureException(
                    "Multiple CharacterMatrix objects in one " +
                    "NexusFileCollection not allowed.");
            }
        	}
        	
        return  CollectionHandler.FORWARD_TOKEN;
    }

    public void _handleParameterChange(Parameter parameter, Token newValue) 
		throws IllegalActionException {
            
        super._handleParameterChange(parameter, newValue);
    }
  
	///////////////////////////////////////////////////////////////////
	////                         private variables                 ////

	private CollectionManager _nexusCollectionManager;
	private CharacterMatrix _characterMatrix;
    private static final long serialVersionUID = 1L;
}
